/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllStreamvsCursorSizeTest
extends PerformanceComparisonTestCase {
    public ReadAllStreamvsCursorSizeTest() {
        this.setDescription("This test compares the performance of cursored streams vs scrollable cursors.");
        this.addReadAllScrollableCursorTest();
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.useCursoredStream(1, 1);
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        stream.size();
        stream.close();
    }

    public void addReadAllScrollableCursorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.useScrollableCursor();
                ScrollableCursor cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
                cursor.size();
                cursor.close();
            }
        };
        test.setName("ReadAllScrollableCursorSizeTest");
        this.addTest((TestCase)test);
    }

    public void verify() {
        try {
            super.verify();
        }
        catch (TestErrorException slow) {
            throw new TestWarningException("Cursor size fetches all rows, should use count for size, known bug 3313298 and 3662233)");
        }
    }
}

