/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class NestedUnitOfWorkDeleteFromNestedObjectTest
extends AutoVerifyTestCase {
    public NestedUnitOfWorkDeleteFromNestedObjectTest() {
        this.setDescription("Test designed to verify that a object in relation deleted/removed in a nested unit of work are deleted/removed in main unit of work after commit of nested UOW.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork nestedUow1 = uow.acquireUnitOfWork();
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        query.setSelectionCriteria(expressionBuilder.get("firstName").equal((Object)"Bob").and(expressionBuilder.get("lastName").equal((Object)"Smith")));
        query.conformResultsInUnitOfWork();
        Vector results = (Vector)uow.executeQuery((DatabaseQuery)query);
        Employee employee = (Employee)results.firstElement();
        Employee employeeNested = (Employee)nestedUow1.registerObject((Object)employee);
        NestedUnitOfWorkDeleteFromNestedObjectTest.assertTrue((employeeNested.getPhoneNumbers().size() > 0 ? 1 : 0) != 0);
        for (PhoneNumber item : new Vector(employeeNested.getPhoneNumbers())) {
            if (item == null) continue;
            nestedUow1.deleteObject((Object)item);
            employeeNested.removePhoneNumber(item);
        }
        nestedUow1.deleteObject((Object)employeeNested);
        nestedUow1.commitAndResume();
        if (employee.getPhoneNumbers().size() != 0) {
            throw new TestErrorException("Objects removal from the nested unit of work is not merged into outer/main unit of work. Number of remaining objects is: " + employee.getPhoneNumbers().size());
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

