/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoCodecs;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoDatabaseConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecordFactory;

public class MongoDatabaseConnectionFactory
implements ConnectionFactory {
    protected transient MongoClient mongo;
    protected transient MongoDatabase db;

    public MongoDatabaseConnectionFactory() {
    }

    public MongoDatabaseConnectionFactory(MongoClient mongo) {
        this.mongo = mongo;
    }

    public MongoDatabaseConnectionFactory(MongoDatabase db) {
        this.db = db;
    }

    public Connection getConnection() throws ResourceException {
        return this.getConnection(new MongoJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        MongoJCAConnectionSpec connectionSpec = (MongoJCAConnectionSpec)spec;
        MongoDatabase db = this.db;
        boolean isExternal = true;
        if (db == null) {
            MongoClient mongo;
            ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
            int index = 0;
            while (index < connectionSpec.getHosts().size()) {
                String host = connectionSpec.getHosts().get(index);
                int port = ServerAddress.defaultPort();
                if (connectionSpec.getPorts().size() > index) {
                    port = connectionSpec.getPorts().get(index);
                }
                ServerAddress server = new ServerAddress(host, port);
                servers.add(server);
                ++index;
            }
            if (connectionSpec.getHosts().isEmpty()) {
                ServerAddress server = new ServerAddress("localhost", ServerAddress.defaultPort());
                servers.add(server);
            }
            if ((mongo = this.mongo) == null) {
                isExternal = false;
                ArrayList<MongoCredential> credentialsList = new ArrayList<MongoCredential>();
                if (connectionSpec.getUser() != null && connectionSpec.getUser().length() > 0) {
                    MongoCredential credential = MongoCredential.createCredential((String)connectionSpec.getUser(), (String)connectionSpec.getDB(), (char[])connectionSpec.getPassword());
                    credentialsList.add(credential);
                }
                MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
                optionsBuilder.serverSelectionTimeout(connectionSpec.getServerSelectionTimeout());
                if (connectionSpec.getReadPreference() != null) {
                    optionsBuilder.readPreference(connectionSpec.getReadPreference());
                }
                if (connectionSpec.getWriteConcern() != null) {
                    optionsBuilder.writeConcern(connectionSpec.getWriteConcern());
                }
                optionsBuilder.codecRegistry(MongoCodecs.codecRegistry());
                MongoClientOptions options = optionsBuilder.build();
                mongo = servers.isEmpty() ? new MongoClient(new ServerAddress(), credentialsList, options) : new MongoClient(servers, credentialsList, options);
            }
            db = mongo.getDatabase(connectionSpec.getDB());
            try {
                db.runCommand((Bson)new Document("ping", (Object)1));
            }
            catch (Exception exception) {
                ResourceException resourceException = new ResourceException((Throwable)exception);
                resourceException.initCause((Throwable)exception);
                throw resourceException;
            }
        }
        return new MongoDatabaseConnection(this.mongo, db, isExternal, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new MongoAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new MongoRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }
}

