/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import javax.persistence.EntityManager;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance2.Address;
import org.eclipse.persistence.testing.models.jpa.performance2.Employee;
import org.eclipse.persistence.testing.models.jpa.performance2.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance2.Gender;
import org.eclipse.persistence.testing.models.jpa.performance2.JobTitle;
import org.eclipse.persistence.testing.models.jpa.performance2.PhoneNumber;

public class JPA2InsertEmployeePerformanceComparisonTest
extends PerformanceRegressionTestCase {
    public JPA2InsertEmployeePerformanceComparisonTest() {
        this.setDescription("This test compares the performance of insert Employee.");
    }

    public void reset() {
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from Email where address = 'ceo@foo.com'").executeUpdate();
        em.createQuery("Delete from Degree where name = 'HighSchool'").executeUpdate();
        em.createQuery("Delete from PhoneNumber where number = '9991111'").executeUpdate();
        em.createQuery("Delete from Employee where firstName = 'NewGuy'").executeUpdate();
        em.createQuery("Delete from Address where street = 'Hasting Perf'").executeUpdate();
        em.createQuery("Delete from JobTitle where name = 'CEO'").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    public void test() throws Exception {
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        Employee empInsert = new Employee();
        empInsert.setFirstName("NewGuy");
        empInsert.setGender(Gender.Male);
        empInsert.setLastName("Doe");
        empInsert.setSalary(100000.0);
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(1895, 1, 1);
        employmentPeriod.setStartDate(1901, 12, 31);
        empInsert.setPeriod(employmentPeriod);
        empInsert.setAddress(new Address());
        empInsert.getAddress().setCity("Nepean");
        empInsert.getAddress().setPostalCode("N5J2N5");
        empInsert.getAddress().setProvince("ON");
        empInsert.getAddress().setStreet("Hasting Perf");
        empInsert.getAddress().setCountry("Canada");
        empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "9991111"));
        empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "9991111"));
        empInsert.setJobTitle(new JobTitle("CEO"));
        empInsert.addDegree("HighSchool");
        empInsert.addEmailAddress("work", "ceo@foo.com");
        empInsert.addResponsibility("code");
        em.persist((Object)empInsert);
        em.getTransaction().commit();
        em.close();
    }
}

