/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.Auditor;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.CustomerCollection;
import org.eclipse.persistence.testing.models.jpa.relationships.CustomerServiceRepresentative;
import org.eclipse.persistence.testing.models.jpa.relationships.Distributor;
import org.eclipse.persistence.testing.models.jpa.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.relationships.Lego;
import org.eclipse.persistence.testing.models.jpa.relationships.Manufacturer;
import org.eclipse.persistence.testing.models.jpa.relationships.Mattel;
import org.eclipse.persistence.testing.models.jpa.relationships.MegaBrands;
import org.eclipse.persistence.testing.models.jpa.relationships.Namco;
import org.eclipse.persistence.testing.models.jpa.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.relationships.OrderCard;
import org.eclipse.persistence.testing.models.jpa.relationships.OrderLabel;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;
import org.eclipse.persistence.testing.models.jpa.relationships.ServiceCall;
import org.eclipse.persistence.testing.models.jpa.relationships.TestInstantiationCopyPolicy;

public class RelationshipModelJUnitTestSuite
extends JUnitTestCase {
    private static Integer itemId;

    public RelationshipModelJUnitTestSuite() {
    }

    public RelationshipModelJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("RelationshipModelJUnitTestSuite");
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testSetup"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testCreateItem"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testModifyItem"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testVerifyItem"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testInstantiationCopyPolicy"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testCopyPolicy"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testCloneCopyPolicy"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testCollectionImplementation"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testCustomerServiceRepMap"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testOne2OneRelationTables"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testExecuteUpdateTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetResultCollectionTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetResultListTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetSingleResultTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testNamedQueryDoesNotExistTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testNamedQueryDoesNotExistTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testExcludeDefaultMappings"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testChangeSetForNewObject"));
        return suite;
    }

    public void testSetup() {
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testExcludeDefaultMappings() {
        ClassDescriptor descriptor = RelationshipModelJUnitTestSuite.getServerSession().getDescriptor(Mattel.class);
        RelationshipModelJUnitTestSuite.assertNull((String)"The 'ignoredBasic' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredBasic"));
        RelationshipModelJUnitTestSuite.assertNull((String)"The 'ignoredOneToOne' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredOneToOne"));
        RelationshipModelJUnitTestSuite.assertNull((String)"The 'ignoredVariableOneToOne' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredVariableOneToOne"));
        RelationshipModelJUnitTestSuite.assertNull((String)"The 'ignoredOneToMany' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredOneToMany"));
    }

    public void testCreateItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Item item = new Item();
            item.setName("Synergizer2000");
            item.setDescription("Every kid must have one ... ");
            Mattel mattel = new Mattel();
            mattel.setName("Mattel Inc.");
            em.persist((Object)mattel);
            item.setManufacturer((Manufacturer)mattel);
            Namco namco = new Namco();
            namco.setName("Namco Games");
            item.setDistributor((Distributor)namco);
            em.persist((Object)item);
            itemId = item.getItemId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testModifyItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Item item = (Item)em.find(Item.class, (Object)itemId);
            item.setName("Willy Waller");
            item.setDescription("For adults only!");
            RelationshipModelJUnitTestSuite.assertTrue((String)"The manufacturer was not persisted", (item.getManufacturer() != null ? 1 : 0) != 0);
            RelationshipModelJUnitTestSuite.assertTrue((String)"The manufacturer of the item was incorrect", (boolean)item.getManufacturer().getName().equals("Mattel Inc."));
            Lego lego = new Lego();
            lego.setName("The LEGO Group");
            item.setManufacturer((Manufacturer)lego);
            RelationshipModelJUnitTestSuite.assertTrue((String)"The distributor was not persisted", (item.getDistributor() != null ? 1 : 0) != 0);
            RelationshipModelJUnitTestSuite.assertTrue((String)"The distributor of the item was incorrect", (boolean)item.getDistributor().getName().equals("Namco Games"));
            MegaBrands megaBrands = new MegaBrands();
            megaBrands.setName("MegaBrands Inc.");
            item.setDistributor((Distributor)megaBrands);
            em.merge((Object)item);
            em.persist((Object)lego);
            em.persist((Object)megaBrands);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyItem() {
        EntityManager em = this.createEntityManager();
        Item item = (Item)em.find(Item.class, (Object)itemId);
        RelationshipModelJUnitTestSuite.assertTrue((String)"The manufacturer was not persisted", (item.getManufacturer() != null ? 1 : 0) != 0);
        RelationshipModelJUnitTestSuite.assertTrue((String)"The manufacturer of the item was incorrect", (boolean)item.getManufacturer().getName().equals("The LEGO Group"));
        RelationshipModelJUnitTestSuite.assertTrue((String)"The distributor was not persisted", (item.getDistributor() != null ? 1 : 0) != 0);
        RelationshipModelJUnitTestSuite.assertTrue((String)"The distributor of the item was incorrect", (boolean)item.getDistributor().getName().equals("MegaBrands Inc."));
        this.closeEntityManager(em);
    }

    public void testInstantiationCopyPolicy() {
        RelationshipModelJUnitTestSuite.assertTrue((String)"The InstantiationCopyPolicy was not properly set.", (boolean)(RelationshipModelJUnitTestSuite.getServerSession().getDescriptor(Item.class).getCopyPolicy() instanceof InstantiationCopyPolicy));
    }

    public void testCopyPolicy() {
        RelationshipModelJUnitTestSuite.assertTrue((String)"The CopyPolicy was not properly set.", (boolean)(RelationshipModelJUnitTestSuite.getServerSession().getDescriptor(Order.class).getCopyPolicy() instanceof TestInstantiationCopyPolicy));
    }

    public void testCloneCopyPolicy() {
        CopyPolicy copyPolicy = RelationshipModelJUnitTestSuite.getServerSession().getDescriptor(Namco.class).getCopyPolicy();
        RelationshipModelJUnitTestSuite.assertTrue((String)"The CloneCopyPolicy was not properly set.", (boolean)(copyPolicy instanceof CloneCopyPolicy));
        RelationshipModelJUnitTestSuite.assertTrue((String)"The method on CloneCopyPolicy was not properly set.", (boolean)((CloneCopyPolicy)copyPolicy).getMethodName().equals("cloneNamco"));
        RelationshipModelJUnitTestSuite.assertTrue((String)"The workingCopyMethod on CloneCopyPolicy was not properly set.", (boolean)((CloneCopyPolicy)copyPolicy).getWorkingCopyMethodName().equals("cloneWorkingCopyNamco"));
    }

    public void testCollectionImplementation() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer c = new Customer();
            CustomerCollection collection = new CustomerCollection();
            c.setCCustomers(collection);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCustomerServiceRepMap() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Customer cust = new Customer();
        cust.setName("Kovie");
        cust.setCity("Ottawa");
        CustomerServiceRepresentative rep = new CustomerServiceRepresentative();
        rep.setName("Brian");
        ServiceCall call = new ServiceCall();
        call.setDescription("Trade from Habs.");
        cust.addCSInteraction(call, rep);
        em.persist((Object)call);
        em.persist((Object)cust);
        em.flush();
        this.rollbackTransaction(em);
    }

    public void testOne2OneRelationTables() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Order order1 = new Order();
        Order order2 = new Order();
        Auditor auditor = new Auditor();
        try {
            OrderCard order1Card = new OrderCard();
            OrderLabel order1Label = new OrderLabel();
            order1Label.setDescription("I describe order 1");
            order1.setOrderLabel(order1Label);
            order1.setOrderCard(order1Card);
            em.persist((Object)order1);
            OrderCard order2Card = new OrderCard();
            OrderLabel order2Label = new OrderLabel();
            order2Label.setDescription("I describe order 2");
            order2.setOrderLabel(order2Label);
            order2.setOrderCard(order2Card);
            em.persist((Object)order2);
            auditor.setName("Guillaume");
            auditor.addOrder(order1);
            auditor.addOrder(order2);
            em.persist((Object)auditor);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        Auditor refreshedAuditor = (Auditor)em.find(Auditor.class, (Object)auditor.getId());
        Order refreshedOrder1 = (Order)em.find(Order.class, (Object)order1.getOrderId());
        Order refreshedOrder2 = (Order)em.find(Order.class, (Object)order2.getOrderId());
        RelationshipModelJUnitTestSuite.assertTrue((String)"Auditor read back did not match the original", (boolean)RelationshipModelJUnitTestSuite.getServerSession().compareObjects((Object)auditor, (Object)refreshedAuditor));
        RelationshipModelJUnitTestSuite.assertTrue((String)"Order1 read back did not match the original", (boolean)RelationshipModelJUnitTestSuite.getServerSession().compareObjects((Object)order1, (Object)refreshedOrder1));
        RelationshipModelJUnitTestSuite.assertTrue((String)"Order2 read back did not match the original", (boolean)RelationshipModelJUnitTestSuite.getServerSession().compareObjects((Object)order2, (Object)refreshedOrder2));
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteUpdateTest() {
        EntityManager em = this.createEntityManager();
        Integer[] cusIDs = new Integer[2];
        String nameChange1 = "New Name1";
        String nameChange2 = "New Name2";
        String nameChange3 = "New Name3";
        IllegalStateException expectedException = null;
        Exception expectedException2 = null;
        try {
            Customer cusClone1 = RelationshipsExamples.customerExample1();
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            this.commitTransaction(em);
            em.clear();
            this.clearCache();
            cusIDs[0] = cusClone1.getCustomerId();
            this.beginTransaction(em);
            Customer cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            Query query = em.createQuery("UPDATE Customer customer SET customer.name = '" + nameChange1 + "' WHERE customer.customerId = " + cusIDs[0]);
            query.executeUpdate();
            em.clear();
            this.clearCache();
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName1 = cus.getName();
            Query query2 = em.createQuery("UPDATE Customer customer SET customer.name = :name WHERE customer.customerId = " + cusIDs[0]);
            query2.setParameter("name", (Object)nameChange2);
            query2.executeUpdate();
            em.clear();
            this.clearCache();
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName2 = cus.getName();
            Query query3 = em.createQuery("UPDATE Customer customer SET customer.name = :name WHERE customer.customerId = :id");
            query3.setParameter("name", (Object)nameChange3);
            query3.setParameter("id", (Object)cusIDs[0]);
            query3.executeUpdate();
            em.clear();
            this.clearCache();
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName3 = cus.getName();
            try {
                Query query4 = em.createNamedQuery("findAllCustomers");
                query4.executeUpdate();
            }
            catch (IllegalStateException expected) {
                expectedException = expected;
            }
            expectedException2 = null;
            try {
                this.commitTransaction(em);
                expectedException2 = null;
            }
            catch (Exception ex) {
                expectedException2 = ex;
            }
            if (returnedName1 == null || !returnedName1.equals(nameChange1)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange1 + " is :" + returnedName1));
            }
            if (returnedName2 == null || !returnedName2.equals(nameChange2)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange2 + " is :" + returnedName2));
            }
            if (returnedName3 == null || !returnedName3.equals(nameChange3)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange3 + " is :" + returnedName3));
            }
            if (expectedException == null) {
                RelationshipModelJUnitTestSuite.fail((String)"excuteUpdate did not result in an exception on findAllCustomers named ReadAllQuery");
            }
            if (expectedException2 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"commit did not throw expected RollbackException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResultCollectionTest() {
        QueryException expectedException1 = null;
        String ejbql1 = "SELECT OBJECT(thecust) FROM Customer thecust WHERE thecust.customerId = :id";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)cusClone1);
        em.persist((Object)cusClone2);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        cusIDs[0] = cusClone1.getCustomerId();
        cusIDs[1] = cusClone2.getCustomerId();
        try {
            this.beginTransaction(em);
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query1 = (EJBQueryImpl)entityManagerImpl.createNamedQuery("findAllCustomers");
            Collection returnedCustomers1 = query1.getResultCollection();
            EJBQueryImpl query2 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query2.setParameter("id", (Object)-10);
            Collection returnedCustomers2 = query2.getResultCollection();
            EJBQueryImpl query3 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query3.setDatabaseQuery((DatabaseQuery)readAllQuery);
            try {
                query3.getResultCollection();
            }
            catch (PersistenceException exc) {
                expectedException1 = (QueryException)exc.getCause();
                this.rollbackTransaction(em);
                this.beginTransaction(em);
            }
            entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query4 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query4.setParameter("id", (Object)-10);
            ReadObjectQuery readObjectQuery2 = new ReadObjectQuery(Customer.class);
            readObjectQuery2.setEJBQLString(ejbql1);
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery2);
            query4.getResultCollection();
            this.commitTransaction(em);
            if (returnedCustomers1 == null || returnedCustomers1.size() < 2) {
                RelationshipModelJUnitTestSuite.fail((String)"Not all customers were returned from findAllCustomers query ");
            }
            if (returnedCustomers2 == null || returnedCustomers2.size() != 0) {
                RelationshipModelJUnitTestSuite.fail((String)"Customer from ReadObjectQuery was not returned using getResultCollection");
            }
            if (expectedException1 == null || expectedException1.getErrorCode() != 6123) {
                RelationshipModelJUnitTestSuite.fail((String)"getResultCollection on query returning a hashtable did not throw expected INVALID_CONTAINER_CLASS QueryException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResultListTest() {
        QueryException expectedException1 = null;
        String ejbql1 = "SELECT OBJECT(thecust) FROM Customer thecust WHERE thecust.customerId = :id";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)cusClone1);
        em.persist((Object)cusClone2);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        cusIDs[0] = cusClone1.getCustomerId();
        cusIDs[1] = cusClone2.getCustomerId();
        try {
            this.beginTransaction(em);
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            Query query1 = em.createNamedQuery("findAllCustomers");
            List returnedCustomers1 = query1.getResultList();
            Query query2 = em.createQuery(ejbql1);
            query2.setParameter("id", (Object)-10);
            List returnedCustomers2 = query2.getResultList();
            EJBQueryImpl query3 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query3.setDatabaseQuery((DatabaseQuery)readAllQuery);
            try {
                query3.getResultList();
            }
            catch (PersistenceException exc) {
                expectedException1 = (QueryException)exc.getCause();
                this.rollbackTransaction(em);
                this.beginTransaction(em);
            }
            entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query4 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query4.setParameter("id", (Object)-10);
            ReadObjectQuery readObjectQuery2 = new ReadObjectQuery(Customer.class);
            readObjectQuery2.setEJBQLString(ejbql1);
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery2);
            query4.getResultList();
            this.commitTransaction(em);
            if (returnedCustomers1 == null || returnedCustomers1.size() < 2) {
                RelationshipModelJUnitTestSuite.fail((String)"Not all customers were returned from findAllCustomers query ");
            }
            if (returnedCustomers2 == null || returnedCustomers2.size() != 0) {
                RelationshipModelJUnitTestSuite.fail((String)"Customer from ReadObjectQuery was not returned using getResultCollection");
            }
            if (expectedException1 == null || expectedException1.getErrorCode() != 6123) {
                RelationshipModelJUnitTestSuite.fail((String)"getResultCollection on query returning a hashtable did not throw expected INVALID_CONTAINER_CLASS QueryException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSingleResultTest() {
        Customer returnedCustomer2 = null;
        NonUniqueResultException expectedException1 = null;
        NoResultException expectedException2 = null;
        String searchString = "notAnItemName";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = this.createEntityManager();
        try {
            Customer returnedCustomer1;
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            em.persist((Object)cusClone2);
            this.commitTransaction(em);
            this.clearCache();
            cusIDs[0] = cusClone1.getCustomerId();
            cusIDs[1] = cusClone2.getCustomerId();
            this.beginTransaction(em);
            try {
                returnedCustomer1 = (Customer)em.createNamedQuery("findAllCustomers").getSingleResult();
            }
            catch (NonUniqueResultException exceptionExpected1) {
                expectedException1 = exceptionExpected1;
            }
            try {
                Query query1 = em.createNamedQuery("findAllItemsByName");
                Item item = (Item)query1.setParameter(1, (Object)searchString).getSingleResult();
                item.toString();
            }
            catch (NoResultException exceptionExpected2) {
                expectedException2 = exceptionExpected2;
            }
            EJBQueryImpl query2 = (EJBQueryImpl)em.createNamedQuery("findAllCustomers");
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query2.setDatabaseQuery((DatabaseQuery)readAllQuery);
            Map result = (Map)query2.getSingleResult();
            result.toString();
            Query query3 = em.createQuery("SELECT OBJECT(thecust) FROM Customer thecust WHERE thecust.customerId = :id");
            returnedCustomer1 = (Customer)query3.setParameter("id", (Object)cusIDs[0]).getSingleResult();
            EJBQueryImpl query4 = (EJBQueryImpl)em.createQuery("SELECT OBJECT(thecust) FROM Customer thecust WHERE thecust.customerId = :id");
            query4.setParameter("id", (Object)cusIDs[0]);
            ReadObjectQuery readObjectQuery = new ReadObjectQuery(Customer.class);
            readObjectQuery.setEJBQLString("SELECT OBJECT(thecust) FROM Customer thecust WHERE thecust.customerId = :id");
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery);
            returnedCustomer2 = (Customer)query4.getSingleResult();
            this.commitTransaction(em);
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
            if (expectedException1 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"getSingelResult on query returning multiple values did not throw a NonUniqueResultException");
            }
            if (expectedException2 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"getSingelResult on query returning multiple values did not throw an NoResultException");
            }
            if (returnedCustomer1 == null || !returnedCustomer1.getCustomerId().equals(cusIDs[0])) {
                RelationshipModelJUnitTestSuite.fail((String)("Incorrect Single Customer returned, found: " + returnedCustomer1));
            }
            if (returnedCustomer2 == null || !returnedCustomer2.getCustomerId().equals(cusIDs[0])) {
                RelationshipModelJUnitTestSuite.fail((String)("Incorrect Single Customer returned, found: " + returnedCustomer2));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    public void testNamedQueryDoesNotExistTest() {
        Exception m_exception = null;
        EntityManager em = this.createEntityManager();
        boolean m_npeCaught = false;
        boolean m_illegalArgumentExceptionCaught = false;
        try {
            Query query = em.createNamedQuery("doesNotExist");
            if (RelationshipModelJUnitTestSuite.getServerSession().getServerPlatform().getClass().getName().contains("WebLogic")) {
                query.getResultList();
            }
        }
        catch (NullPointerException e) {
            m_npeCaught = true;
        }
        catch (IllegalArgumentException e) {
            m_illegalArgumentExceptionCaught = true;
        }
        catch (Exception e) {
            m_exception = e;
        }
        if (m_npeCaught) {
            RelationshipModelJUnitTestSuite.fail((String)"A null pointer exception caught on the query.");
        } else if (!m_illegalArgumentExceptionCaught) {
            if (m_exception != null) {
                RelationshipModelJUnitTestSuite.fail((String)("Expected IllegalArgumentException, caught: " + m_exception));
            } else {
                RelationshipModelJUnitTestSuite.fail((String)"No exception was caught on a named query that does not exist.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedQueryWithArgumentsTest() {
        Integer[] cusIDs = new Integer[3];
        Integer[] orderIDs = new Integer[3];
        Integer[] itemIDs = new Integer[3];
        Exception exception = null;
        List list = null;
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Item item1 = RelationshipsExamples.itemExample1();
        Order order1 = RelationshipsExamples.orderExample1();
        order1.setCustomer(cusClone1);
        order1.setItem(item1);
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            em.persist((Object)order1);
            this.commitTransaction(em);
            cusIDs[0] = cusClone1.getCustomerId();
            orderIDs[0] = order1.getOrderId();
            itemIDs[0] = item1.getItemId();
            this.clearCache();
            try {
                ServerSession ss = RelationshipModelJUnitTestSuite.getServerSession();
                Vector<Integer> vec = new Vector<Integer>();
                vec.add(itemIDs[0]);
                list = (List)ss.executeQuery("findAllOrdersByItem", vec);
            }
            catch (Exception ex) {
                exception = ex;
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Order ord1 = (Order)em.find(Order.class, (Object)orderIDs[0]);
            em.remove((Object)ord1);
            Item it1 = (Item)em.find(Item.class, (Object)itemIDs[0]);
            em.remove((Object)it1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (exception != null) {
            RelationshipModelJUnitTestSuite.fail((String)("An exception is thrown: " + exception));
        }
        if (list.size() != 1) {
            RelationshipModelJUnitTestSuite.fail((String)("One order is expected but " + list.size() + " was returned"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeSetForNewObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Customer cust = new Customer();
        cust.setName("Joe");
        em.persist((Object)cust);
        Order order = new Order();
        order.setQuantity(1);
        em.persist((Object)order);
        cust.addOrder(order);
        this.commitTransaction(em);
        RepeatableWriteUnitOfWork uow = null;
        try {
            this.beginTransaction(em);
            cust = (Customer)em.find(Customer.class, (Object)cust.getCustomerId());
            Order order2 = new Order();
            order2.setQuantity(2);
            order2.setShippingAddress("123 Main St.");
            em.persist((Object)order2);
            cust.addOrder(order2);
            EntityManagerImpl impl = (EntityManagerImpl)JpaHelper.getEntityManager((EntityManager)em);
            uow = impl.getActivePersistenceContext(null);
            em.flush();
            UnitOfWorkChangeSet uowChangeSet = uow.getCumulativeUOWChangeSet();
            ObjectChangeSet customerChangeSet = (ObjectChangeSet)uowChangeSet.getCloneToObjectChangeSet().get(cust);
            CollectionChangeRecord orderChangeRecord = (CollectionChangeRecord)customerChangeSet.getChangesForAttributeNamed("orders");
            for (ObjectChangeSet orderChangeSet : orderChangeRecord.getAddObjectList().keySet()) {
                RelationshipModelJUnitTestSuite.assertTrue((String)"There are changes in the change set.  There should be no changes for a new object.", (boolean)orderChangeSet.getChanges().isEmpty());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.rollbackTransaction(em);
            this.beginTransaction(em);
            cust = (Customer)em.find(Customer.class, (Object)cust.getCustomerId());
            em.remove((Object)cust);
            this.commitTransaction(em);
        }
    }
}

