/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.multipletable;

import java.io.StringWriter;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.models.multipletable.Budget;
import org.eclipse.persistence.testing.models.multipletable.BusinessProject;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class LargeBusinessProject
extends BusinessProject {
    public Budget budget = new Budget(0.0);
    public Calendar milestoneVersion;

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeBusinessProject.class);
        descriptor.setTableName("LPROJ");
        descriptor.addPrimaryKeyFieldName("LPROJ.PROJ_ID");
        descriptor.getInheritancePolicy().setParentClass(BusinessProject.class);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("milestoneVersion");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("LPROJ.MILESTONE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("budget");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(false);
        onetoonemapping1.setReferenceClass(Budget.class);
        onetoonemapping1.setIsPrivateOwned(true);
        onetoonemapping1.addForeignKeyFieldName("BUDGET_ID", "ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        return descriptor;
    }

    public static LargeBusinessProject example1() {
        Calendar milestone = GregorianCalendar.getInstance();
        milestone.clear();
        milestone.set(1999, 5, 6);
        LargeBusinessProject lp = new LargeBusinessProject();
        lp.name = "Java";
        lp.setMilestoneVersion(milestone);
        lp.setBudget(4333.0);
        return lp;
    }

    public static LargeBusinessProject example2() {
        Calendar milestone = GregorianCalendar.getInstance();
        milestone.clear();
        milestone.set(2001, 11, 11);
        LargeBusinessProject lp = new LargeBusinessProject();
        lp.name = "Smalltalk";
        lp.description = "a thing";
        lp.setMilestoneVersion(milestone);
        lp.setBudget(433355.0);
        return lp;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public Calendar getMilestoneVersion() {
        return this.milestoneVersion;
    }

    public void setBudget(double amount) {
        this.setBudget(new Budget(amount));
    }

    public void setBudget(Budget theBudget) {
        this.budget = theBudget;
    }

    public void setMilestoneVersion(Calendar theMilestoneVersion) {
        this.milestoneVersion = theMilestoneVersion;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("LPROJ");
        definition.addField("PROJ_ID", BigInteger.class, 15);
        definition.addField("BUDGET_ID", BigInteger.class, 10);
        definition.addField("MILESTONE", Timestamp.class);
        return definition;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Large Project: ");
        writer.write(this.getName());
        writer.write(" ");
        writer.write(this.getDescription());
        writer.write(" " + this.getBudget());
        writer.write(" ");
        writer.write(String.valueOf(this.getMilestoneVersion()));
        return writer.toString();
    }
}

