/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.plsql;

import java.math.BigDecimal;
import java.sql.Array;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.plsql.Address;
import org.eclipse.persistence.testing.models.plsql.Employee;
import org.eclipse.persistence.testing.models.plsql.Phone;

public class PLSQLProject
extends Project {
    public PLSQLProject() {
        this.setName("PLSQLProject");
        this.buildAddressDescriptor();
        this.buildPhoneDescriptor();
        this.buildEmployeeDescriptor();
    }

    protected PLSQLrecord buildAddressRowTypeRecord() {
        PLSQLrecord record = this.buildAddressRowTypeDataRecord();
        record.setCompatibleType("PLSQL_P_PLSQL_ADDRESS_REC");
        record.setJavaType(Address.class);
        return record;
    }

    protected PLSQLrecord buildAddressRowTypeDataRecord() {
        PLSQLrecord record = new PLSQLrecord();
        record.setTypeName("PLSQL_ADDRESS%ROWTYPE");
        record.addField("ADDRESS_ID", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 0);
        record.addField("STREET_NUM", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 0);
        record.addField("STREET", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.addField("CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.addField("STATE", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        return record;
    }

    protected PLSQLrecord buildAddressRecord() {
        PLSQLrecord record = new PLSQLrecord();
        record.setTypeName("PLSQL_P.PLSQL_ADDRESS_REC");
        record.setCompatibleType("PLSQL_P_PLSQL_ADDRESS_REC");
        record.addField("ADDRESS_ID", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 0);
        record.addField("STREET_NUM", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 0);
        record.addField("STREET", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.addField("CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.addField("STATE", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.setJavaType(Address.class);
        return record;
    }

    protected PLSQLrecord buildPhoneRecord() {
        PLSQLrecord record = new PLSQLrecord();
        record.setTypeName("PLSQL_P.PLSQL_PHONE_REC");
        record.setCompatibleType("PLSQL_P_PLSQL_PHONE_REC");
        record.addField("AREA_CODE", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 3);
        record.addField("P_NUM", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 7);
        record.setJavaType(Phone.class);
        return record;
    }

    protected DatabaseQuery buildSimpleInQuery() {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_SIMPLE_IN");
        call.addNamedArgument("P_VARCHAR", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedArgument("P_NATURALN", (DatabaseType)OraclePLSQLTypes.NaturalN);
        call.addNamedArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedArgument("P_POSITIVEN", (DatabaseType)OraclePLSQLTypes.PositiveN);
        call.addNamedArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_VARCHAR", String.class);
        query.addArgument("P_BOOLEAN", Integer.class);
        query.addArgument("P_BINARY_INTEGER", Integer.class);
        query.addArgument("P_DEC", Integer.class);
        query.addArgument("P_INT", Integer.class);
        query.addArgument("P_NATURAL", Integer.class);
        query.addArgument("P_NATURALN", Integer.class);
        query.addArgument("P_PLS_INTEGER", Integer.class);
        query.addArgument("P_POSITIVE", Integer.class);
        query.addArgument("P_POSITIVEN", Integer.class);
        query.addArgument("P_SIGNTYPE", BigDecimal.class);
        query.addArgument("P_NUMBER", BigDecimal.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildSimpleInDefaults2Query() {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_SIMPLE_IN_DEFAULTS");
        call.addNamedArgument("P_VARCHAR", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedArgument("P_NATURALN", (DatabaseType)OraclePLSQLTypes.NaturalN);
        call.addNamedArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedArgument("P_POSITIVEN", (DatabaseType)OraclePLSQLTypes.PositiveN);
        call.addNamedArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        call.addOptionalArgument("P_VARCHAR");
        call.addOptionalArgument("P_BOOLEAN");
        call.addOptionalArgument("P_BINARY_INTEGER");
        call.addOptionalArgument("P_DEC");
        call.addOptionalArgument("P_INT");
        call.addOptionalArgument("P_NATURAL");
        call.addOptionalArgument("P_NATURALN");
        call.addOptionalArgument("P_PLS_INTEGER");
        call.addOptionalArgument("P_POSITIVE");
        call.addOptionalArgument("P_POSITIVEN");
        call.addOptionalArgument("P_SIGNTYPE");
        call.addOptionalArgument("P_NUMBER");
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_VARCHAR", String.class, true);
        query.addArgument("P_BOOLEAN", Integer.class, true);
        query.addArgument("P_BINARY_INTEGER", Integer.class, true);
        query.addArgument("P_DEC", Integer.class, true);
        query.addArgument("P_INT", Integer.class, true);
        query.addArgument("P_NATURAL", Integer.class, true);
        query.addArgument("P_NATURALN", Integer.class, true);
        query.addArgument("P_PLS_INTEGER", Integer.class, true);
        query.addArgument("P_POSITIVE", Integer.class, true);
        query.addArgument("P_POSITIVEN", Integer.class, true);
        query.addArgument("P_SIGNTYPE", BigDecimal.class, true);
        query.addArgument("P_NUMBER", BigDecimal.class, true);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildSimpleInFuncQuery() {
        PLSQLStoredFunctionCall call = new PLSQLStoredFunctionCall((DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.setProcedureName("PLSQL_SIMPLE_IN_Func");
        call.addNamedArgument("P_VARCHAR", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedArgument("P_NATURALN", (DatabaseType)OraclePLSQLTypes.NaturalN);
        call.addNamedArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedArgument("P_POSITIVEN", (DatabaseType)OraclePLSQLTypes.PositiveN);
        call.addNamedArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_VARCHAR", String.class);
        query.addArgument("P_BOOLEAN", Integer.class);
        query.addArgument("P_BINARY_INTEGER", Integer.class);
        query.addArgument("P_DEC", Integer.class);
        query.addArgument("P_INT", Integer.class);
        query.addArgument("P_NATURAL", Integer.class);
        query.addArgument("P_NATURALN", Integer.class);
        query.addArgument("P_PLS_INTEGER", Integer.class);
        query.addArgument("P_POSITIVE", Integer.class);
        query.addArgument("P_POSITIVEN", Integer.class);
        query.addArgument("P_SIGNTYPE", BigDecimal.class);
        query.addArgument("P_NUMBER", BigDecimal.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildSimpleInDefaultsQuery() {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_SIMPLE_IN");
        call.addNamedArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedArgument("P_NATURALN", (DatabaseType)OraclePLSQLTypes.NaturalN);
        call.addNamedArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedArgument("P_POSITIVEN", (DatabaseType)OraclePLSQLTypes.PositiveN);
        call.addNamedArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_BOOLEAN", Integer.class);
        query.addArgument("P_BINARY_INTEGER", Integer.class);
        query.addArgument("P_DEC", Integer.class);
        query.addArgument("P_INT", Integer.class);
        query.addArgument("P_NATURAL", Integer.class);
        query.addArgument("P_NATURALN", Integer.class);
        query.addArgument("P_PLS_INTEGER", Integer.class);
        query.addArgument("P_POSITIVE", Integer.class);
        query.addArgument("P_POSITIVEN", Integer.class);
        query.addArgument("P_SIGNTYPE", BigDecimal.class);
        query.addArgument("P_NUMBER", BigDecimal.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildSimpleInOutQuery() {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_SIMPLE_INOUT");
        call.addNamedInOutputArgument("P_VARCHAR", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedInOutputArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedInOutputArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedInOutputArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedInOutputArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedInOutputArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedInOutputArgument("P_NATURALN", (DatabaseType)OraclePLSQLTypes.NaturalN);
        call.addNamedInOutputArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedInOutputArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedInOutputArgument("P_POSITIVEN", (DatabaseType)OraclePLSQLTypes.PositiveN);
        call.addNamedInOutputArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedInOutputArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_VARCHAR", String.class);
        query.addArgument("P_BOOLEAN", Integer.class);
        query.addArgument("P_BINARY_INTEGER", Integer.class);
        query.addArgument("P_DEC", Integer.class);
        query.addArgument("P_INT", Integer.class);
        query.addArgument("P_NATURAL", Integer.class);
        query.addArgument("P_NATURALN", Integer.class);
        query.addArgument("P_PLS_INTEGER", Integer.class);
        query.addArgument("P_POSITIVE", Integer.class);
        query.addArgument("P_POSITIVEN", Integer.class);
        query.addArgument("P_SIGNTYPE", BigDecimal.class);
        query.addArgument("P_NUMBER", BigDecimal.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildSimpleOutQuery() {
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_SIMPLE_OUT");
        call.addNamedOutputArgument("P_VARCHAR", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedOutputArgument("P_BOOLEAN", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean);
        call.addNamedOutputArgument("P_BINARY_INTEGER", (DatabaseType)OraclePLSQLTypes.BinaryInteger);
        call.addNamedOutputArgument("P_DEC", (DatabaseType)OraclePLSQLTypes.Dec);
        call.addNamedOutputArgument("P_INT", (DatabaseType)OraclePLSQLTypes.Int);
        call.addNamedOutputArgument("P_NATURAL", (DatabaseType)OraclePLSQLTypes.Natural);
        call.addNamedOutputArgument("P_PLS_INTEGER", (DatabaseType)OraclePLSQLTypes.PLSQLInteger);
        call.addNamedOutputArgument("P_POSITIVE", (DatabaseType)OraclePLSQLTypes.Positive);
        call.addNamedOutputArgument("P_SIGNTYPE", (DatabaseType)OraclePLSQLTypes.SignType);
        call.addNamedOutputArgument("P_NUMBER", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 2);
        DataModifyQuery query = new DataModifyQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressInOutObjectQuery() {
        PLSQLrecord record = this.buildAddressRowTypeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_INOUT");
        call.addNamedInOutputArgument("P_ADDRESS", (DatabaseType)record);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("P_ADDRESS", Address.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressInOutDataQuery() {
        PLSQLrecord record = this.buildAddressRowTypeDataRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_INOUT_DATA");
        call.addNamedInOutputArgument("P_ADDRESS", (DatabaseType)record);
        call.addNamedInOutputArgument("P_LOCAL", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("ADDRESS_ID", BigDecimal.class);
        query.addArgument("STREET_NUM", Integer.class);
        query.addArgument("STREET", String.class);
        query.addArgument("CITY", String.class);
        query.addArgument("STATE", String.class);
        query.addArgument("P_LOCAL", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressInObjectQuery() {
        PLSQLrecord record = this.buildAddressRowTypeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_IN");
        call.addNamedArgument("P_ADDRESS", (DatabaseType)record);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_ADDRESS", Address.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressInDataQuery() {
        PLSQLrecord record = this.buildAddressRowTypeDataRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_IN_DATA");
        call.addNamedArgument("P_LOCAL", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        call.addNamedArgument("P_ADDRESS", (DatabaseType)record);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("ADDRESS_ID", BigDecimal.class);
        query.addArgument("STREET_NUM", Integer.class);
        query.addArgument("STREET", String.class);
        query.addArgument("CITY", String.class);
        query.addArgument("STATE", String.class);
        query.addArgument("P_LOCAL", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressOutObjectQuery() {
        PLSQLrecord record = this.buildAddressRowTypeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_OUT");
        call.addNamedOutputArgument("P_ADDRESS", (DatabaseType)record);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressOutObjectFuncQuery() {
        PLSQLrecord record = this.buildAddressRowTypeRecord();
        PLSQLStoredFunctionCall call = new PLSQLStoredFunctionCall((DatabaseType)record);
        call.setProcedureName("PLSQL_ADDRESS_OUT_FUNC");
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildBadAddressOutObjectQuery() {
        PLSQLrecord record = this.buildAddressRowTypeRecord();
        record.setTypeName(null);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_INOUT");
        call.addNamedOutputArgument("P_ADDRESS", (DatabaseType)record);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressOutDataQuery() {
        PLSQLrecord record = this.buildAddressRowTypeDataRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_ADDRESS_OUT_DATA");
        call.addNamedOutputArgument("P_ADDRESS", (DatabaseType)record);
        call.addNamedOutputArgument("P_LOCAL", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        DataReadQuery query = new DataReadQuery();
        query.dontMaintainCache();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildCityListInQuery() {
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_CITY_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_CITY_LIST");
        collection.setNestedType((DatabaseType)JDBCTypes.VARCHAR_TYPE);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_CITY_LIST_IN");
        call.addNamedArgument("P_CITY_LIST", (DatabaseType)collection);
        call.addNamedArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_CITY_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildCityListOutQuery() {
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_CITY_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_CITY_LIST");
        collection.setNestedType((DatabaseType)JDBCTypes.VARCHAR_TYPE);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_CITY_LIST_OUT");
        call.addNamedOutputArgument("P_CITY_LIST", (DatabaseType)collection);
        call.addNamedOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildCityListInOutQuery() {
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_CITY_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_CITY_LIST");
        collection.setNestedType((DatabaseType)JDBCTypes.VARCHAR_TYPE);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_CITY_LIST_INOUT");
        call.addNamedInOutputArgument("P_CITY_LIST", (DatabaseType)collection);
        call.addNamedInOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("P_CITY_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressListInQuery() {
        PLSQLrecord record = this.buildAddressRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_ADDRESS_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_ADDRESS_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_LIST_IN");
        call.addNamedArgument("P_ADDRESS_LIST", (DatabaseType)collection);
        call.addNamedArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_ADDRESS_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildMissingTypeAddressListOutQuery() {
        PLSQLrecord record = this.buildAddressRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_ADDRESS_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_LIST_OUT");
        call.addNamedOutputArgument("P_ADDRESS_LIST", (DatabaseType)collection);
        call.addNamedOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressListOutQuery() {
        PLSQLrecord record = this.buildAddressRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_ADDRESS_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_ADDRESS_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_LIST_OUT");
        call.addNamedOutputArgument("P_ADDRESS_LIST", (DatabaseType)collection);
        call.addNamedOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressOutCursorQuery() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_CUR_OUT");
        call.useNamedCursorOutputAsResultSet("P_ADDRESS");
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressRecOutCursorQuery() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_REC_CUR_OUT");
        call.useNamedCursorOutputAsResultSet("P_ADDRESS");
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildAddressListInOutQuery() {
        PLSQLrecord record = this.buildAddressRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_ADDRESS_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_ADDRESS_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_ADDRESS_LIST_INOUT");
        call.addNamedInOutputArgument("P_ADDRESS_LIST", (DatabaseType)collection);
        call.addNamedInOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("P_ADDRESS_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected PLSQLrecord buildEmployeeRecord() {
        PLSQLrecord record = new PLSQLrecord();
        record.setTypeName("PLSQL_P.PLSQL_EMP_REC");
        record.setCompatibleType("PLSQL_P_PLSQL_EMP_REC");
        record.addField("EMP_ID", (DatabaseType)JDBCTypes.NUMERIC_TYPE, 10, 0);
        record.addField("NAME", (DatabaseType)JDBCTypes.VARCHAR_TYPE, 30);
        record.addField("ACTIVE", (DatabaseType)OraclePLSQLTypes.PLSQLBoolean, 30);
        record.addField("ADDRESS", (DatabaseType)this.buildAddressRecord());
        record.setJavaType(Employee.class);
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_PHONE_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_PHONE_LIST");
        collection.setNestedType((DatabaseType)this.buildPhoneRecord());
        record.addField("PHONES", (DatabaseType)collection);
        return record;
    }

    protected DatabaseQuery buildEmployeeListInQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_EMP_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_EMP_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_LIST_IN");
        call.addNamedArgument("P_EMP_LIST", (DatabaseType)collection);
        call.addNamedArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_EMP_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildEmployeeListOutQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_EMP_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_EMP_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_LIST_OUT");
        call.addNamedOutputArgument("P_EMP_LIST", (DatabaseType)collection);
        call.addNamedOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildEmployeeListInOutQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLCollection collection = new PLSQLCollection();
        collection.setTypeName("PLSQL_P.PLSQL_EMP_LIST");
        collection.setCompatibleType("PLSQL_P_PLSQL_EMP_LIST");
        collection.setNestedType((DatabaseType)record);
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_LIST_INOUT");
        call.addNamedInOutputArgument("P_EMP_LIST", (DatabaseType)collection);
        call.addNamedInOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("P_EMP_LIST", Array.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildEmployeeInQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_IN");
        call.addNamedArgument("P_EMP", (DatabaseType)record);
        call.addNamedArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument("P_EMP", Employee.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildEmployeeOutQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_OUT");
        call.addNamedOutputArgument("P_EMP", (DatabaseType)record);
        call.addNamedOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.setCall((Call)call);
        return query;
    }

    protected DatabaseQuery buildEmployeeInOutQuery() {
        PLSQLrecord record = this.buildEmployeeRecord();
        PLSQLStoredProcedureCall call = new PLSQLStoredProcedureCall();
        call.setProcedureName("PLSQL_P.PLSQL_EMP_INOUT");
        call.addNamedInOutputArgument("P_EMP", (DatabaseType)record);
        call.addNamedInOutputArgument("P_CITY", (DatabaseType)JDBCTypes.VARCHAR_TYPE);
        DataReadQuery query = new DataReadQuery();
        query.addArgument("P_EMP", Employee.class);
        query.addArgument("P_CITY", String.class);
        query.setCall((Call)call);
        return query;
    }

    protected void buildAddressDescriptor() {
        ObjectRelationalDataTypeDescriptor descriptor = new ObjectRelationalDataTypeDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.setTableName("PLSQL_ADDRESS");
        descriptor.setStructureName("PLSQL_P_PLSQL_ADDRESS_REC");
        descriptor.descriptorIsAggregate();
        descriptor.getQueryManager().addQuery("SimpleIn", this.buildSimpleInQuery());
        descriptor.getQueryManager().addQuery("SimpleInDefaults", this.buildSimpleInDefaultsQuery());
        descriptor.getQueryManager().addQuery("SimpleInDefaults2", this.buildSimpleInDefaults2Query());
        descriptor.getQueryManager().addQuery("SimpleInFunc", this.buildSimpleInFuncQuery());
        descriptor.getQueryManager().addQuery("SimpleOut", this.buildSimpleOutQuery());
        descriptor.getQueryManager().addQuery("SimpleInOut", this.buildSimpleInOutQuery());
        descriptor.getQueryManager().addQuery("AddressInOutObject", this.buildAddressInOutObjectQuery());
        descriptor.getQueryManager().addQuery("AddressInOutData", this.buildAddressInOutDataQuery());
        descriptor.getQueryManager().addQuery("AddressOutObject", this.buildAddressOutObjectQuery());
        descriptor.getQueryManager().addQuery("AddressOutObjectFunc", this.buildAddressOutObjectFuncQuery());
        descriptor.getQueryManager().addQuery("AddressOutData", this.buildAddressOutDataQuery());
        descriptor.getQueryManager().addQuery("AddressInObject", this.buildAddressInObjectQuery());
        descriptor.getQueryManager().addQuery("AddressInData", this.buildAddressInDataQuery());
        descriptor.getQueryManager().addQuery("CityListIn", this.buildCityListInQuery());
        descriptor.getQueryManager().addQuery("CityListOut", this.buildCityListOutQuery());
        descriptor.getQueryManager().addQuery("CityListInOut", this.buildCityListInOutQuery());
        descriptor.getQueryManager().addQuery("AddressListIn", this.buildAddressListInQuery());
        descriptor.getQueryManager().addQuery("AddressListOut", this.buildAddressListOutQuery());
        descriptor.getQueryManager().addQuery("AddressListInOut", this.buildAddressListInOutQuery());
        descriptor.getQueryManager().addQuery("BadAddressOut", this.buildBadAddressOutObjectQuery());
        descriptor.getQueryManager().addQuery("MissingTypeAddressListOut", this.buildMissingTypeAddressListOutQuery());
        descriptor.getQueryManager().addQuery("AddressOutCursor", this.buildAddressOutCursorQuery());
        descriptor.getQueryManager().addQuery("AddressRecOutCursor", this.buildAddressRecOutCursorQuery());
        descriptor.addFieldOrdering("ADDRESS_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        descriptor.addFieldOrdering("STREET_NUM");
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("STREET_NUM");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        descriptor.addFieldOrdering("STREET");
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        descriptor.addFieldOrdering("CITY");
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        descriptor.addFieldOrdering("STATE");
        DirectToFieldMapping stateMapping = new DirectToFieldMapping();
        stateMapping.setAttributeName("state");
        stateMapping.setFieldName("STATE");
        descriptor.addMapping((DatabaseMapping)stateMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPhoneDescriptor() {
        ObjectRelationalDataTypeDescriptor descriptor = new ObjectRelationalDataTypeDescriptor();
        descriptor.setJavaClass(Phone.class);
        descriptor.setStructureName("PLSQL_P_PLSQL_PHONE_REC");
        descriptor.descriptorIsAggregate();
        descriptor.addFieldOrdering("AREA_CODE");
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        descriptor.addFieldOrdering("P_NUM");
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("P_NUM");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmployeeDescriptor() {
        ObjectRelationalDataTypeDescriptor descriptor = new ObjectRelationalDataTypeDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.setTableName("PLSQL_EMP");
        descriptor.setStructureName("PLSQL_P_PLSQL_EMP_REC");
        descriptor.descriptorIsAggregate();
        descriptor.getQueryManager().addQuery("EmployeeListIn", this.buildEmployeeListInQuery());
        descriptor.getQueryManager().addQuery("EmployeeListOut", this.buildEmployeeListOutQuery());
        descriptor.getQueryManager().addQuery("EmployeeListInOut", this.buildEmployeeListInOutQuery());
        descriptor.getQueryManager().addQuery("EmployeeInObject", this.buildEmployeeInQuery());
        descriptor.getQueryManager().addQuery("EmployeeOutObject", this.buildEmployeeOutQuery());
        descriptor.getQueryManager().addQuery("EmployeeInOutObject", this.buildEmployeeInOutQuery());
        descriptor.addFieldOrdering("EMP_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        descriptor.addFieldOrdering("NAME");
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        descriptor.addFieldOrdering("ACTIVE");
        DirectToFieldMapping activeMapping = new DirectToFieldMapping();
        activeMapping.setAttributeName("active");
        activeMapping.setFieldName("ACTIVE");
        descriptor.addMapping((DatabaseMapping)activeMapping);
        descriptor.addFieldOrdering("ADDRESS");
        StructureMapping addressMapping = new StructureMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setFieldName("ADDRESS");
        addressMapping.setReferenceClass(Address.class);
        descriptor.addMapping((DatabaseMapping)addressMapping);
        descriptor.addFieldOrdering("PHONES");
        ObjectArrayMapping phonesMapping = new ObjectArrayMapping();
        phonesMapping.setStructureName("PLSQL_P_PLSQL_PHONE_LIST");
        phonesMapping.setAttributeName("phones");
        phonesMapping.setFieldName("PHONES");
        phonesMapping.setReferenceClass(Phone.class);
        descriptor.addMapping((DatabaseMapping)phonesMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

