/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapMappingBatchReadTest
extends AutoVerifyTestCase {
    DirectMapMappings queryResult;
    SessionEventAdapter sessionListener;
    boolean isPostExecutedQuery;

    public DirectMapMappingBatchReadTest() {
        this.setDescription("Tests that objects direct map mapping are batch read properly.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
        this.getSession().getEventManager().removeListener((SessionEventListener)this.sessionListener);
    }

    public void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
        this.sessionListener = new SessionEventAdapter(){

            public void postExecuteQuery(SessionEvent event) {
                DirectMapMappingBatchReadTest.this.isPostExecutedQuery = true;
            }
        };
        this.getSession().getEventManager().addListener((SessionEventListener)this.sessionListener);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps1 = (DirectMapMappings)uow.registerObject((Object)new DirectMapMappings());
        maps1.directMap.put(1, "guy");
        maps1.directMap.put(2, "axemen");
        DirectMapMappings maps2 = (DirectMapMappings)uow.registerObject((Object)new DirectMapMappings());
        maps2.directMap.put(1, "steve");
        maps2.directMap.put(2, "superman");
        uow.commit();
    }

    public void verify() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector maps = this.getSession().readAllObjects(DirectMapMappings.class);
        Hashtable batchRead = ((DirectMapMappings)maps.elementAt((int)0)).directMapForBatchRead;
        this.isPostExecutedQuery = false;
        batchRead = ((DirectMapMappings)maps.elementAt((int)1)).directMapForBatchRead;
        if (this.isPostExecutedQuery) {
            throw new TestErrorException("Batch read does not work with direct map mapping");
        }
    }
}

