/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class UpdateTest
extends AutoVerifyTestCase {
    public UpdateTest() {
        this.setDescription("Tests UpdateObject using Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Employee james = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%James%"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        james = (Employee)uow.registerObject((Object)james);
        Address add = james.getAddress();
        add.setCity("Tuscon");
        add.setState("AZ");
        add.setCountry("USA");
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee james = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"James"));
        Address address = james.getAddress();
        if (!(address.getCity().equals("Tuscon") && address.getState().equals("AZ") && address.getCountry().equals("USA"))) {
            throw new TestErrorException("Proxy object update did not work properly.\n" + address);
        }
    }
}

