/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.util.HashSet;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.CheckClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckMethodAdapter;

public class CheckModuleAdapter
extends ModuleVisitor {
    private final boolean isOpen;
    private final HashSet<String> requiredModules = new HashSet();
    private final HashSet<String> exportedPackages = new HashSet();
    private final HashSet<String> openedPackages = new HashSet();
    private final HashSet<String> usedServices = new HashSet();
    private final HashSet<String> providedServices = new HashSet();
    int classVersion;
    private boolean visitEndCalled;

    public CheckModuleAdapter(ModuleVisitor moduleVisitor, boolean bl) {
        this(393216, moduleVisitor, bl);
        if (this.getClass() != CheckModuleAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckModuleAdapter(int n, ModuleVisitor moduleVisitor, boolean bl) {
        super(n, moduleVisitor);
        this.isOpen = bl;
    }

    @Override
    public void visitMainClass(String string) {
        CheckMethodAdapter.checkInternalName(string, "module main class");
        super.visitMainClass(string);
    }

    @Override
    public void visitPackage(String string) {
        CheckMethodAdapter.checkInternalName(string, "module package");
        super.visitPackage(string);
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        this.checkVisitEndNotCalled();
        CheckClassAdapter.checkFullyQualifiedName(string, "required module");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(string, this.requiredModules, "Modules requires");
        CheckClassAdapter.checkAccess(n, 36960);
        if (this.classVersion >= 54 && string.equals("java.base") && (n & 0x60) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n + " java.base can not be declared ACC_TRANSITIVE or ACC_STATIC_PHASE");
        }
        super.visitRequire(string, n, string2);
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(string, "package name");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(string, this.exportedPackages, "Module exports");
        CheckClassAdapter.checkAccess(n, 36864);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CheckClassAdapter.checkFullyQualifiedName(string2, "module export to");
            }
        }
        super.visitExport(string, n, stringArray);
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        this.checkVisitEndNotCalled();
        if (this.isOpen) {
            throw new UnsupportedOperationException("An open module can not use open directive");
        }
        CheckMethodAdapter.checkInternalName(string, "package name");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(string, this.openedPackages, "Module opens");
        CheckClassAdapter.checkAccess(n, 36864);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CheckClassAdapter.checkFullyQualifiedName(string2, "module open to");
            }
        }
        super.visitOpen(string, n, stringArray);
    }

    @Override
    public void visitUse(String string) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(string, "service");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(string, this.usedServices, "Module uses");
        super.visitUse(string);
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(string, "service");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(string, this.providedServices, "Module provides");
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Providers cannot be null or empty");
        }
        for (String string2 : stringArray) {
            CheckMethodAdapter.checkInternalName(string2, "provider");
        }
        super.visitProvide(string, stringArray);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private static void checkNameNotAlreadyDeclared(String string, HashSet<String> hashSet, String string2) {
        if (!hashSet.add(string)) {
            throw new IllegalArgumentException(string2 + " " + string + " already declared");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

