/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.internal.eis.cobol.CompositeFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.CopyBookParseException;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.eis.cobol.helper.Helper;

public class CopyBookParser {
    private static final int maximumNestingLevels = 50;
    private String currentLine = null;
    private int currentLineNumber = 0;

    public Vector parse(InputStream stream) throws Exception {
        Vector records;
        this.currentLineNumber = 0;
        try {
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            String copyBookString = new String(bytes);
            records = this.buildStructure(copyBookString);
            int i = 0;
            while (i < records.size()) {
                this.setOffsetsForComposite((CompositeObject)records.elementAt(i), 0);
                ++i;
            }
        }
        catch (IOException exception) {
            throw CopyBookParseException.ioException(exception);
        }
        return records;
    }

    /*
     * Unable to fully structure code
     */
    private Vector buildStructure(String fileString) throws Exception {
        records = new Vector<Object>();
        lineTokenizer = new StringTokenizer(fileString, System.getProperty("line.separator"), false);
        record = new RecordMetaData();
        recordLines = new Vector<String>();
        lineNums = new Vector<Integer>();
        while (lineTokenizer.hasMoreTokens() && !"procedure division.".equalsIgnoreCase(this.currentLine)) {
            this.currentLine = lineTokenizer.nextToken();
            ++this.currentLineNumber;
            if (this.currentLine.trim().startsWith("*") || this.currentLine.trim().length() <= 0) continue;
            lineTokens = new StringTokenizer(this.currentLine);
            firstToken = lineTokens.nextToken();
            if (firstToken.endsWith(".")) {
                firstToken = firstToken.substring(0, this.currentLine.lastIndexOf("."));
            }
            if ((levelNumber = Helper.integerFromString(firstToken)) == null || levelNumber >= 50) continue;
            while (!this.currentLine.trim().endsWith(".")) {
                this.currentLine = String.valueOf(this.currentLine) + lineTokenizer.nextToken();
                ++this.currentLineNumber;
            }
            this.currentLine = this.currentLine.substring(0, this.currentLine.lastIndexOf("."));
            recordLines.addElement(this.currentLine);
            lineNums.addElement(this.currentLineNumber);
        }
        nestingLevel = 50;
        parents = new Stack<Object>();
        parentsToLevels = new Hashtable<Object, Integer>();
        recordsEnum = recordLines.elements();
        recordLineNums = lineNums.elements();
        while (recordsEnum.hasMoreElements()) {
            block7: {
                block6: {
                    this.currentLine = (String)recordsEnum.nextElement();
                    this.currentLineNumber = (Integer)recordLineNums.nextElement();
                    lineTokens = new StringTokenizer(this.currentLine);
                    if (!lineTokens.hasMoreTokens()) continue;
                    firstToken = lineTokens.nextToken();
                    levelNumber = Helper.integerFromString(firstToken);
                    if (levelNumber != 1) break block6;
                    nestingLevel = 50;
                    parents = new Stack<E>();
                    parentsToLevels = new Hashtable<K, V>();
                    component = this.buildRecord(lineTokens);
                    record = (RecordMetaData)component;
                    records.addElement(component);
                    break block7;
                }
                if (levelNumber < nestingLevel) ** GOTO lbl50
                component = this.buildField(lineTokens);
                ((CompositeObject)parents.peek()).addField((FieldMetaData)component);
                break block7;
lbl-1000:
                // 1 sources

                {
                    parents.pop();
lbl50:
                    // 2 sources

                    ** while (((Integer)parentsToLevels.get(parents.peek())).intValue() >= levelNumber.intValue())
                }
lbl51:
                // 1 sources

                component = this.buildField(lineTokens);
                ((CompositeObject)parents.peek()).addField((FieldMetaData)component);
            }
            nestingLevel = levelNumber;
            if (component instanceof FieldMetaData) {
                ((FieldMetaData)component).setRecord(record);
            }
            if (!(component instanceof CompositeObject)) continue;
            parents.push(component);
            parentsToLevels.put(component, levelNumber);
        }
        return records;
    }

    private void setOffsetsForComposite(CompositeObject object, int offset) {
        int currentOffset = offset;
        int previousFieldSize = 0;
        Vector fields = object.getFields();
        Enumeration fieldEnum = fields.elements();
        FieldMetaData previousField = null;
        while (fieldEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)fieldEnum.nextElement();
            if (field.isFieldRedefine()) {
                field.setFieldRedefined(previousField);
                if (field instanceof CompositeObject) {
                    this.setOffsetsForComposite((CompositeObject)((Object)field), previousField.getOffset());
                }
                field.setOffset(previousField.getOffset());
                if (previousFieldSize >= field.getSize()) continue;
                currentOffset += field.getSize() - previousFieldSize;
                previousFieldSize = field.getSize();
                continue;
            }
            if (field instanceof CompositeObject) {
                this.setOffsetsForComposite((CompositeObject)((Object)field), currentOffset);
            }
            field.setOffset(currentOffset);
            currentOffset += field.getSize();
            previousField = field;
            previousFieldSize = field.getSize();
        }
    }

    private RecordMetaData buildRecord(StringTokenizer lineTokens) throws Exception {
        if (lineTokens.hasMoreTokens()) {
            String recordName = lineTokens.nextToken();
            RecordMetaData record = new RecordMetaData(recordName);
            return record;
        }
        throw this.invalidCopyBookException("The record has no name.");
    }

    private FieldMetaData buildField(StringTokenizer lineTokens) throws Exception {
        FieldMetaData field;
        String fieldName;
        boolean redefine = false;
        int arraySize = -1;
        String[] tokens = new String[lineTokens.countTokens()];
        int index = 0;
        String dependentField = "";
        while (lineTokens.hasMoreTokens()) {
            tokens[index++] = lineTokens.nextToken();
        }
        index = 0;
        if (tokens.length > 0) {
            fieldName = this.isKeyWord(tokens[index]) ? "filler" : tokens[index];
        } else {
            CompositeFieldMetaData field2 = new CompositeFieldMetaData();
            field2.setName("filler");
            return field2;
        }
        int i = 0;
        while (i < tokens.length && !tokens[index].equalsIgnoreCase("pic") && !tokens[index].equalsIgnoreCase("picture")) {
            if (tokens[index].equalsIgnoreCase("redefines")) {
                redefine = true;
            }
            if (tokens[index].equalsIgnoreCase("occurs")) {
                arraySize = this.handleOccursStatement(tokens, ++index);
                --index;
            }
            if (tokens[index].equalsIgnoreCase("depending")) {
                dependentField = this.handleDependeningStatement(tokens, ++index);
                --index;
            }
            ++index;
            ++i;
        }
        if (index < tokens.length && (tokens[index].equalsIgnoreCase("pic") || tokens[index].equalsIgnoreCase("picture"))) {
            field = this.buildElementaryField(fieldName, tokens, index);
        } else {
            field = new CompositeFieldMetaData();
            field.setName(fieldName);
        }
        field.setIsFieldRedefine(redefine);
        field.setArraySize(arraySize);
        field.setDependentFieldName(dependentField);
        return field;
    }

    private String handleDependeningStatement(String[] tokens, int index) throws Exception {
        String fieldName = null;
        try {
            fieldName = tokens[index];
            if (index < tokens.length && fieldName.equalsIgnoreCase("on")) {
                fieldName = tokens[++index];
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw this.invalidCopyBookException("There was no field name following the depending clause.", exception);
        }
        return fieldName;
    }

    private int handleOccursStatement(String[] tokens, int index) throws Exception {
        try {
            Integer size = Helper.integerFromString(tokens[index]);
            if (index < tokens.length && tokens[++index].equalsIgnoreCase("to")) {
                Integer newSize = Helper.integerFromString(tokens[++index]);
                if (size > 0) {
                    newSize = newSize - size;
                }
                size = newSize;
            }
            if (size < 1) {
                throw this.invalidCopyBookException("Must occur at least once.");
            }
            return size;
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw this.invalidCopyBookException("Occurs clause must be folowed by and integer.", exception);
        }
    }

    private FieldMetaData buildElementaryField(String fieldName, String[] tokens, int index) throws Exception {
        String picStatment;
        ElementaryFieldMetaData field = new ElementaryFieldMetaData();
        int size = 0;
        try {
            field.setName(fieldName);
            picStatment = tokens[++index];
            if (picStatment.equalsIgnoreCase("is")) {
                picStatment = tokens[++index];
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw this.invalidCopyBookException("Picture clause must be followed by a pic statement.", exception);
        }
        if (picStatment.toUpperCase().startsWith("A")) {
            field.setType(4);
            size = this.calculateSizeOfAlphaNumeric(picStatment, field);
        } else if (picStatment.toUpperCase().startsWith("X")) {
            field.setType(2);
            size = this.calculateSizeOfAlphaNumeric(picStatment, field);
        } else if (picStatment.toUpperCase().startsWith("9") || picStatment.toUpperCase().startsWith("V") || picStatment.toUpperCase().startsWith("Z") || picStatment.startsWith("+") || picStatment.startsWith("-") || picStatment.toUpperCase().startsWith("S")) {
            field.setType(1);
            size = this.calculateSizeOfNumeric(picStatment, tokens, index, field);
        }
        field.setSize(size);
        return field;
    }

    private int calculateSizeOfAlphaNumeric(String picStatement, FieldMetaData field) throws Exception {
        char[] picChars = picStatement.toCharArray();
        int length = picChars.length;
        int index = 0;
        int size = 0;
        while (index < length) {
            char currentChar = picChars[index];
            switch (currentChar) {
                case '(': {
                    StringBuilder number = new StringBuilder();
                    --size;
                    currentChar = picChars[++index];
                    while (index < length && currentChar != ')') {
                        number.append(currentChar);
                        currentChar = picChars[++index];
                    }
                    try {
                        Integer value = Integer.valueOf(number.toString());
                        size += value.intValue();
                    }
                    catch (NumberFormatException exception) {
                        throw this.invalidCopyBookException("In pic statement a valid integer must be enclosed by the parenthesis.", exception);
                    }
                    if (currentChar == ')') {
                        ++index;
                        break;
                    }
                    throw this.invalidCopyBookException("An open parenthesis must be followed by a close parenthesis.");
                }
                case '+': 
                case '-': 
                case '9': 
                case 'A': 
                case 'P': 
                case 'X': 
                case 'Z': 
                case 'a': 
                case 'p': 
                case 'x': 
                case 'z': {
                    ++size;
                    ++index;
                    break;
                }
                case 'V': 
                case 'v': {
                    field.setDecimalPosition(size);
                    ++index;
                    break;
                }
                case 'S': 
                case 's': {
                    ++index;
                    break;
                }
                case '.': {
                    if (index == length - 1) {
                        return size;
                    }
                    ++index;
                    ++size;
                    break;
                }
                default: {
                    throw this.invalidCopyBookException("Invalid character: " + currentChar + " in pic statement.");
                }
            }
        }
        return size;
    }

    private int calculateSizeOfNumeric(String picStatement, String[] tokens, int index, FieldMetaData field) throws Exception {
        int size = 0;
        int digits = 0;
        if (picStatement.toUpperCase().startsWith("S")) {
            field.setIsSigned(true);
        }
        int i = index;
        while (i < tokens.length) {
            String nextStatement = tokens[i];
            if (nextStatement.equalsIgnoreCase("comp") || nextStatement.equalsIgnoreCase("computational")) {
                digits = this.calculateSizeOfAlphaNumeric(picStatement, field);
                field.setType(5);
                if (digits < 3) {
                    size = 1;
                } else if (digits < 5) {
                    size = 2;
                } else if (digits < 8) {
                    size = 3;
                } else if (digits < 10) {
                    size = 4;
                } else if (digits < 13) {
                    size = 5;
                } else if (digits < 15) {
                    size = 6;
                } else if (digits < 17) {
                    size = 7;
                } else if (digits < 20) {
                    size = 8;
                }
                if (field.isSigned() && (digits == 7 || digits == 12 || digits == 19)) {
                    ++size;
                }
            } else {
                if (nextStatement.equalsIgnoreCase("comp-2") || nextStatement.equalsIgnoreCase("computational-2")) {
                    field.setType(6);
                    return 4;
                }
                if (nextStatement.equalsIgnoreCase("comp-3") || nextStatement.equalsIgnoreCase("computational-3") || nextStatement.equalsIgnoreCase("packed-decimal")) {
                    int tempSize = this.calculateSizeOfAlphaNumeric(picStatement, field);
                    field.setType(7);
                    size = (tempSize + 1) / 2;
                    if ((tempSize + 1) % 2 > 0) {
                        ++size;
                    }
                } else if (nextStatement.equalsIgnoreCase("seperate")) {
                    size = this.calculateSizeOfAlphaNumeric(picStatement, field);
                    ++size;
                } else {
                    field.setType(2);
                    size = this.calculateSizeOfAlphaNumeric(picStatement, field);
                }
            }
            ++i;
            ++index;
        }
        return size;
    }

    private boolean isKeyWord(String word) {
        String[] keyWords = new String[]{"pic", "picture", "redefines", "blank", "external", "global", "justified", "just", "occurs"};
        int i = 0;
        while (i < keyWords.length) {
            if (word.equalsIgnoreCase(keyWords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CopyBookParseException invalidCopyBookException(String message) {
        return CopyBookParseException.invalidCopyBookException(String.valueOf(message) + " Error occrured on line " + this.currentLineNumber + ":" + this.currentLine);
    }

    private CopyBookParseException invalidCopyBookException(String message, Exception internalException) {
        CopyBookParseException exception = this.invalidCopyBookException(message);
        exception.setInternalException(internalException);
        return exception;
    }
}

