/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class ReadAllQueryConformExpiryTest
extends CacheExpiryTest {
    protected int originalNumber = 0;
    protected int postInvalidationNumber = 0;

    public ReadAllQueryConformExpiryTest() {
        this.setDescription("Test to ensure expired objects are still returned when conform results is used.");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression smiths = employees.get("lastName").equal((Object)"Smith");
        Vector employeeSmiths = uow.readAllObjects(Employee.class, smiths);
        this.originalNumber = employeeSmiths.size();
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression way = emp.get("lastName").equal((Object)"Way");
        Employee employee = (Employee)uow.readObject(Employee.class, way);
        employee.setLastName("Smith");
        uow.getIdentityMapAccessor().invalidateObject((Object)employee);
        ReadAllQuery query = new ReadAllQuery(Employee.class, smiths);
        query.conformResultsInUnitOfWork();
        employeeSmiths = (Vector)uow.executeQuery((DatabaseQuery)query);
        this.postInvalidationNumber = employeeSmiths.size();
        uow.release();
    }

    public void verify() {
        if (this.originalNumber + 1 != this.postInvalidationNumber) {
            throw new TestErrorException("Conforming with invalidated items did not return the correct number of objects.");
        }
    }
}

