/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class CustomAccessorAttributeAccessor
extends AttributeAccessor {
    private Object accessor;
    private transient Method getMethod;
    private transient Method setMethod;

    public CustomAccessorAttributeAccessor(Object accessor) {
        this.accessor = accessor;
        Class[] getMethodParams = new Class[]{Object.class};
        Class[] setMethodParams = new Class[]{Object.class, Object.class};
        try {
            this.getMethod = PrivilegedAccessHelper.getDeclaredMethod(accessor.getClass(), (String)"get", (Class[])getMethodParams);
            this.setMethod = PrivilegedAccessHelper.getDeclaredMethod(accessor.getClass(), (String)"set", (Class[])setMethodParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return PrivilegedAccessHelper.invokeMethod((Method)this.getMethod, (Object)this.accessor, (Object[])new Object[]{object});
        }
        catch (Exception ex) {
            throw JAXBException.errorInvokingAccessor((Object)this.accessor, (String)"get", (Exception)ex);
        }
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        try {
            PrivilegedAccessHelper.invokeMethod((Method)this.setMethod, (Object)this.accessor, (Object[])new Object[]{object, value});
        }
        catch (Exception ex) {
            throw JAXBException.errorInvokingAccessor((Object)this.accessor, (String)"set", (Exception)ex);
        }
    }
}

