/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLName {
    private String file;
    private String host;
    private String password;
    private int port;
    private String protocol;
    private String ref;
    private String username;
    protected String fullURL;
    private int hashCode;

    public URLName(String url) {
        this.parseString(url);
    }

    protected void parseString(String url) {
        URI uri;
        try {
            uri = url == null ? null : new URI(url);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (uri == null) {
            this.protocol = null;
            this.host = null;
            this.port = -1;
            this.file = null;
            this.ref = null;
            this.username = null;
            this.password = null;
            return;
        }
        this.protocol = URLName.checkBlank(uri.getScheme());
        this.host = URLName.checkBlank(uri.getHost());
        this.port = uri.getPort();
        this.file = URLName.checkBlank(uri.getPath());
        this.ref = URLName.checkBlank(uri.getFragment());
        String userInfo = URLName.checkBlank(uri.getUserInfo());
        if (userInfo == null) {
            this.username = null;
            this.password = null;
        } else {
            int pos = userInfo.indexOf(58);
            if (pos == -1) {
                this.username = userInfo;
                this.password = null;
            } else {
                this.username = userInfo.substring(0, pos);
                this.password = userInfo.substring(pos + 1);
            }
        }
        this.updateFullURL();
    }

    public URLName(String protocol, String host, int port, String file, String username, String password) {
        this.protocol = URLName.checkBlank(protocol);
        this.host = URLName.checkBlank(host);
        this.port = port;
        if (file == null || file.length() == 0) {
            this.file = null;
            this.ref = null;
        } else {
            int pos = file.indexOf(35);
            if (pos == -1) {
                this.file = file;
                this.ref = null;
            } else {
                this.file = file.substring(0, pos);
                this.ref = file.substring(pos + 1);
            }
        }
        this.username = URLName.checkBlank(username);
        this.password = this.username != null ? URLName.checkBlank(password) : null;
        this.updateFullURL();
    }

    public URLName(URL url) {
        this.protocol = URLName.checkBlank(url.getProtocol());
        this.host = URLName.checkBlank(url.getHost());
        this.port = url.getPort();
        this.file = URLName.checkBlank(url.getFile());
        this.ref = URLName.checkBlank(url.getRef());
        String userInfo = URLName.checkBlank(url.getUserInfo());
        if (userInfo == null) {
            this.username = null;
            this.password = null;
        } else {
            int pos = userInfo.indexOf(58);
            if (pos == -1) {
                this.username = userInfo;
                this.password = null;
            } else {
                this.username = userInfo.substring(0, pos);
                this.password = userInfo.substring(pos + 1);
            }
        }
        this.updateFullURL();
    }

    private static String checkBlank(String target) {
        if (target == null || target.length() == 0) {
            return null;
        }
        return target;
    }

    private void updateFullURL() {
        this.hashCode = 0;
        StringBuffer buf = new StringBuffer(100);
        if (this.protocol != null) {
            buf.append(this.protocol).append(':');
            if (this.host != null) {
                buf.append("//");
                if (this.username != null) {
                    buf.append(this.username);
                    if (this.password != null) {
                        buf.append(':').append(this.password);
                    }
                    buf.append('@');
                }
                buf.append(this.host);
                if (this.port != -1) {
                    buf.append(':').append(this.port);
                }
                if (this.file != null) {
                    buf.append(this.file);
                }
                this.hashCode = buf.toString().hashCode();
                if (this.ref != null) {
                    buf.append('#').append(this.ref);
                }
            }
        }
        this.fullURL = buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLName)) {
            return false;
        }
        URLName other = (URLName)o;
        if (this.protocol == null || other.protocol == null || !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return URLName.areSame(this.host, other.host) && URLName.areSame(this.file, other.file) && URLName.areSame(this.username, other.username) && URLName.areSame(this.password, other.password);
    }

    private static boolean areSame(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.fullURL;
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.fullURL);
    }

    public String getUsername() {
        return this.username;
    }
}

