/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.utility;

import java.util.HashMap;
import java.util.Map;

public final class XmlEscapeCharacterConverter {
    public static final String AMPERSAND_ENTITY_NAME = "&amp;";
    public static final String APOSTROPHE_ENTITY_NAME = "&apos;";
    private static final Map<String, String> dictionary = XmlEscapeCharacterConverter.buildDictionary();
    public static final String GREATER_THAN_ENTITY_NAME = "&gt;";
    public static final String LESS_THAN_ENTITY_NAME = "&lt;";
    public static final String QUOTATION_MARK_NAME = "&quot;";

    private XmlEscapeCharacterConverter() {
    }

    private static Map<String, String> buildDictionary() {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("quot", "\"");
        dictionary.put("apos", "'");
        dictionary.put("amp", "&");
        dictionary.put("lt", "<");
        dictionary.put("gt", ">");
        dictionary.put("nbsp", "\u00a0");
        dictionary.put("iexcl", "\u00a1");
        dictionary.put("cent", "\u00a2");
        dictionary.put("pound", "\u00a3");
        dictionary.put("curren", "\u00a4");
        dictionary.put("yen", "\u00a5");
        dictionary.put("brvbar", "\u00a6");
        dictionary.put("sect", "\u00a7");
        dictionary.put("uml", "\u00a8");
        dictionary.put("copy", "\u00a9");
        dictionary.put("ordf", "\u00aa");
        dictionary.put("laquo", "\u00ab");
        dictionary.put("not", "\u00ac");
        dictionary.put("shy", "\u00ad");
        dictionary.put("reg", "\u00ae");
        dictionary.put("macr", "\u00af");
        dictionary.put("deg", "\u00b0");
        dictionary.put("plusmn", "\u00b1");
        dictionary.put("sup2", "\u00b2");
        dictionary.put("sup3", "\u00b3");
        dictionary.put("acute", "\u00b4");
        dictionary.put("micro", "\u00b5");
        dictionary.put("para", "\u00b6");
        dictionary.put("middot", "\u00b7");
        dictionary.put("cedil", "\u00b8");
        dictionary.put("sup1", "\u00b9");
        dictionary.put("ordm", "\u00ba");
        dictionary.put("raquo", "\u00bb");
        dictionary.put("frac14", "\u00bc");
        dictionary.put("frac12", "\u00bd");
        dictionary.put("frac34", "\u00be");
        dictionary.put("iquest", "\u00bf");
        dictionary.put("times", "\u00d7");
        dictionary.put("divide", "\u00f7");
        dictionary.put("Agrave", "\u00c0");
        dictionary.put("Aacute", "\u00c1");
        dictionary.put("Acirc", "\u00c2");
        dictionary.put("Atilde", "\u00c3");
        dictionary.put("Auml", "\u00c4");
        dictionary.put("Aring", "\u00c5");
        dictionary.put("AElig", "\u00c6");
        dictionary.put("Ccedil", "\u00c7");
        dictionary.put("Egrave", "\u00c8");
        dictionary.put("Eacute", "\u00c9");
        dictionary.put("Ecirc", "\u00ca");
        dictionary.put("Euml", "\u00cb");
        dictionary.put("Igrave", "\u00cc");
        dictionary.put("Iacute", "\u00cd");
        dictionary.put("Icirc", "\u00ce");
        dictionary.put("Iuml", "\u00cf");
        dictionary.put("ETH", "\u00d0");
        dictionary.put("Ntilde", "\u00d1");
        dictionary.put("Ograve", "\u00d2");
        dictionary.put("Oacute", "\u00d3");
        dictionary.put("Ocirc", "\u00d4");
        dictionary.put("Otilde", "\u00d5");
        dictionary.put("Ouml", "\u00d6");
        dictionary.put("Oslash", "\u00d8");
        dictionary.put("Ugrave", "\u00d9");
        dictionary.put("Uacute", "\u00da");
        dictionary.put("Ucirc", "\u00db");
        dictionary.put("Uuml", "\u00dc");
        dictionary.put("Yacute", "\u00dd");
        dictionary.put("THORN", "\u00de");
        dictionary.put("szlig", "\u00df");
        dictionary.put("agrave", "\u00e0");
        dictionary.put("aacute", "\u00e1");
        dictionary.put("acirc", "\u00e2");
        dictionary.put("atilde", "\u00e3");
        dictionary.put("auml", "\u00e4");
        dictionary.put("aring", "\u00e5");
        dictionary.put("aelig", "\u00e6");
        dictionary.put("ccedil", "\u00e7");
        dictionary.put("egrave", "\u00e8");
        dictionary.put("eacute", "\u00e9");
        dictionary.put("ecirc", "\u00ea");
        dictionary.put("euml", "\u00eb");
        dictionary.put("igrave", "\u00ec");
        dictionary.put("iacute", "\u00ed");
        dictionary.put("icirc", "\u00ee");
        dictionary.put("iuml", "\u00ef");
        dictionary.put("eth", "\u00f0");
        dictionary.put("ntilde", "\u00f1");
        dictionary.put("ograve", "\u00f2");
        dictionary.put("oacute", "\u00f3");
        dictionary.put("ocirc", "\u00f4");
        dictionary.put("otilde", "\u00f5");
        dictionary.put("ouml", "\u00f6");
        dictionary.put("oslash", "\u00f8");
        dictionary.put("ugrave", "\u00f9");
        dictionary.put("uacute", "\u00fa");
        dictionary.put("ucirc", "\u00fb");
        dictionary.put("uuml", "\u00fc");
        dictionary.put("yacute", "\u00fd");
        dictionary.put("thorn", "\u00fe");
        dictionary.put("yuml", "\u00ff");
        dictionary.put("forall", "\u2200");
        dictionary.put("part", "\u2202");
        dictionary.put("exist", "\u2203");
        dictionary.put("empty", "\u2205");
        dictionary.put("nabla", "\u2207");
        dictionary.put("isin", "\u2208");
        dictionary.put("notin", "\u2209");
        dictionary.put("ni", "\u220b");
        dictionary.put("prod", "\u220f");
        dictionary.put("sum", "\u2211");
        dictionary.put("minus", "\u2212");
        dictionary.put("lowast", "\u2217");
        dictionary.put("radic", "\u221a");
        dictionary.put("prop", "\u221d");
        dictionary.put("infin", "\u221e");
        dictionary.put("ang", "\u2220");
        dictionary.put("and", "\u2227");
        dictionary.put("or", "\u2228");
        dictionary.put("cap", "\u2229");
        dictionary.put("cup", "\u222a");
        dictionary.put("int", "\u222b");
        dictionary.put("there4", "\u2234");
        dictionary.put("sim", "\u223c");
        dictionary.put("cong", "\u2245");
        dictionary.put("asymp", "\u2248");
        dictionary.put("ne", "\u2260");
        dictionary.put("equiv", "\u2261");
        dictionary.put("le", "\u2264");
        dictionary.put("ge", "\u2265");
        dictionary.put("sub", "\u2282");
        dictionary.put("sup", "\u2283");
        dictionary.put("nsub", "\u2284");
        dictionary.put("sube", "\u2286");
        dictionary.put("supe", "\u2287");
        dictionary.put("oplus", "\u2295");
        dictionary.put("otimes", "\u2297");
        dictionary.put("perp", "\u22a5");
        dictionary.put("sdot", "\u22c5");
        dictionary.put("larr", "\u2190");
        dictionary.put("uarr", "\u2191");
        dictionary.put("rarr", "\u2192");
        dictionary.put("darr", "\u2193");
        dictionary.put("harr", "\u2194");
        dictionary.put("crarr", "\u21b5");
        dictionary.put("lArr", "\u21d0");
        dictionary.put("uArr", "\u21d1");
        dictionary.put("rArr", "\u21d2");
        dictionary.put("dArr", "\u21d3");
        dictionary.put("hArr", "\u21d4");
        dictionary.put("Alpha", "\u0391");
        dictionary.put("Beta", "\u0392");
        dictionary.put("Gamma", "\u0393");
        dictionary.put("Delta", "\u0394");
        dictionary.put("Epsilon", "\u0395");
        dictionary.put("Zeta", "\u0396");
        dictionary.put("Eta", "\u0397");
        dictionary.put("Theta", "\u0398");
        dictionary.put("Iota", "\u0399");
        dictionary.put("Kappa", "\u039a");
        dictionary.put("Lambda", "\u039b");
        dictionary.put("Mu", "\u039c");
        dictionary.put("Nu", "\u039d");
        dictionary.put("Xi", "\u039e");
        dictionary.put("Omicron", "\u039f");
        dictionary.put("Pi", "\u03a0");
        dictionary.put("Rho", "\u03a1");
        dictionary.put("Sigma", "\u03a3");
        dictionary.put("Tau", "\u03a4");
        dictionary.put("Upsilon", "\u03a5");
        dictionary.put("Phi", "\u03a6");
        dictionary.put("Chi", "\u03a7");
        dictionary.put("Psi", "\u03a8");
        dictionary.put("Omega", "\u03a9");
        dictionary.put("alpha", "\u03b1");
        dictionary.put("beta", "\u03b2");
        dictionary.put("gamma", "\u03b3");
        dictionary.put("delta", "\u03b4");
        dictionary.put("epsilon", "\u03b5");
        dictionary.put("zeta", "\u03b6");
        dictionary.put("eta", "\u03b7");
        dictionary.put("theta", "\u03b8");
        dictionary.put("iota", "\u03b9");
        dictionary.put("kappa", "\u03ba");
        dictionary.put("lambda", "\u03bb");
        dictionary.put("mu", "\u03bc");
        dictionary.put("nu", "\u03bd");
        dictionary.put("xi", "\u03be");
        dictionary.put("omicron", "\u03bf");
        dictionary.put("pi", "\u03c0");
        dictionary.put("rho", "\u03c1");
        dictionary.put("sigmaf", "\u03c2");
        dictionary.put("sigma", "\u03c3");
        dictionary.put("tau", "\u03c4");
        dictionary.put("upsilon", "\u03c5");
        dictionary.put("phi", "\u03c6");
        dictionary.put("chi", "\u03c7");
        dictionary.put("psi", "\u03c8");
        dictionary.put("omega", "\u03c9");
        dictionary.put("theta", "\u03d1");
        dictionary.put("upsih", "\u03d2");
        dictionary.put("piv", "\u03d6");
        dictionary.put("OElig", "\u0152");
        dictionary.put("oelig", "\u0153");
        dictionary.put("Scaron", "\u0160");
        dictionary.put("scaron", "\u0161");
        dictionary.put("Yuml", "\u0178");
        dictionary.put("fnof", "\u0192");
        dictionary.put("weierp", "\u2118");
        dictionary.put("image", "\u2111");
        dictionary.put("real", "\u211c");
        dictionary.put("trade", "\u2122");
        dictionary.put("alefsym", "\u2135");
        dictionary.put("spades", "\u2660");
        dictionary.put("clubs", "\u2663");
        dictionary.put("hearts", "\u2665");
        dictionary.put("diams", "\u2666");
        dictionary.put("loz", "\u25ca");
        dictionary.put("lceil", "\u2308");
        dictionary.put("rceil", "\u2309");
        dictionary.put("lfloor", "\u230a");
        dictionary.put("rfloor", "\u230b");
        dictionary.put("lang", "\u2329");
        dictionary.put("rang", "\u232a");
        dictionary.put("circ", "\u02c6");
        dictionary.put("tilde", "\u02dc");
        dictionary.put("zwnj", "\u200c");
        dictionary.put("zwj", "\u200d");
        dictionary.put("lrm", "\u200e");
        dictionary.put("rlm", "\u200f");
        dictionary.put("bull", "\u2022");
        dictionary.put("hellip", "\u2026");
        dictionary.put("prime", "\u2032");
        dictionary.put("Prime", "\u2033");
        dictionary.put("oline", "\u203e");
        dictionary.put("frasl", "\u2044");
        dictionary.put("ensp", "\u2002");
        dictionary.put("emsp", "\u2003");
        dictionary.put("thinsp", "\u2009");
        dictionary.put("zwnj", "\u200c");
        dictionary.put("zwj", "\u200d");
        dictionary.put("lrm", "\u200e");
        dictionary.put("rlm", "\u200f");
        dictionary.put("ndash", "\u2013");
        dictionary.put("mdash", "\u2014");
        dictionary.put("lsquo", "\u2018");
        dictionary.put("rsquo", "\u2019");
        dictionary.put("sbquo", "\u201a");
        dictionary.put("ldquo", "\u201c");
        dictionary.put("rdquo", "\u201d");
        dictionary.put("bdquo", "\u201e");
        dictionary.put("dagger", "\u2020");
        dictionary.put("Dagger", "\u2021");
        dictionary.put("permil", "\u2030");
        dictionary.put("lsaquo", "\u2039");
        dictionary.put("rsaquo", "\u203a");
        dictionary.put("euro", "\u20ac");
        return dictionary;
    }

    public static String escape(String value, int[] positions) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length());
        int startPosition = positions[0];
        int endPosition = positions.length > 1 ? positions[1] : -1;
        int index = 0;
        int count = value.length();
        while (index < count) {
            char character = value.charAt(index);
            if (XmlEscapeCharacterConverter.isReserved(character)) {
                String name = XmlEscapeCharacterConverter.getEscapeCharacter(character);
                sb.append(name);
                if (startPosition > index) {
                    positions[0] = positions[0] + (name.length() - 1);
                }
                if (endPosition > -1 && index < endPosition) {
                    positions[1] = positions[1] + (name.length() - 1);
                }
            } else {
                sb.append(character);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String getCharacter(String reference) {
        if (reference == null) {
            return null;
        }
        int length = reference.length();
        if (length == 0) {
            return null;
        }
        if (reference.charAt(0) == '#') {
            String value;
            int radix;
            if (length == 1) {
                return null;
            }
            if (reference.charAt(1) == 'x') {
                radix = 16;
                value = reference.substring(2);
            } else {
                radix = 10;
                value = reference.substring(1);
            }
            if (value.length() == 0 || value.charAt(0) == '-') {
                return null;
            }
            char character = '\u0000';
            try {
                character = (char)Integer.parseInt(value, radix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (character == '\u0000') {
                return null;
            }
            return String.valueOf(character);
        }
        return dictionary.get(reference);
    }

    public static String getEscapeCharacter(char character) {
        switch (character) {
            case '<': {
                return LESS_THAN_ENTITY_NAME;
            }
            case '>': {
                return GREATER_THAN_ENTITY_NAME;
            }
            case '&': {
                return AMPERSAND_ENTITY_NAME;
            }
            case '\'': {
                return APOSTROPHE_ENTITY_NAME;
            }
            case '\"': {
                return QUOTATION_MARK_NAME;
            }
        }
        return null;
    }

    public static boolean isReserved(char character) {
        switch (character) {
            case '\"': 
            case '&': 
            case '\'': 
            case '<': 
            case '>': {
                return true;
            }
        }
        return false;
    }

    public static void reposition(CharSequence query, int[] positions) {
        if (query == null || query.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(query);
        int index = 0;
        int count = sb.length();
        while (index < count) {
            String unicodeCharacter;
            String reference;
            int semiColonIndex;
            char character = sb.charAt(index);
            if (character == '&' && index + 1 < count && (semiColonIndex = sb.indexOf(";", index + 1)) > -1 && (reference = sb.substring(index + 1, semiColonIndex)).length() > 0 && (unicodeCharacter = XmlEscapeCharacterConverter.getCharacter(reference)) != null) {
                int length = semiColonIndex - index;
                if (index < positions[0]) {
                    positions[0] = positions[0] + length;
                    positions[1] = positions[1] + length;
                } else if (index < positions[1]) {
                    positions[1] = positions[1] + length;
                }
                index = semiColonIndex;
            }
            ++index;
        }
    }

    public static String unescape(String value, int[] position) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value);
        int index = 0;
        int count = sb.length();
        while (index < count) {
            String specialCharacter;
            String reference;
            int semiColonIndex;
            char character = sb.charAt(index);
            if (character == '&' && index + 1 < count && (semiColonIndex = sb.indexOf(";", index + 1)) > -1 && (reference = sb.substring(index + 1, semiColonIndex)).length() > 0 && (specialCharacter = XmlEscapeCharacterConverter.getCharacter(reference)) != null) {
                sb.replace(index, semiColonIndex + 1, specialCharacter);
                count -= semiColonIndex - index;
                int length = 1 + reference.length();
                if (position[0] >= index && position[0] <= index + length) {
                    position[0] = index;
                } else if (position[0] > index + length) {
                    position[0] = position[0] - length;
                }
            }
            ++index;
        }
        return sb.toString();
    }
}

