/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.mapping;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Shipment
implements Serializable,
Cloneable {
    public static Timestamp lastCreationTimestamp;
    public Timestamp creationTimestamp;
    public int creationTimestampMillis;
    public String quantityShipped;
    public String shipMode;
    public Vector employees = new Vector();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static Shipment example1() {
        Shipment example = new Shipment();
        example.quantityShipped = "1 ton";
        example.shipMode = "Air";
        return example;
    }

    public static Shipment example2() {
        Shipment example = new Shipment();
        example.quantityShipped = "2 ton";
        example.shipMode = "Air";
        return example;
    }

    public static Shipment example3() {
        Shipment example = new Shipment();
        example.quantityShipped = "3 ton";
        example.shipMode = "Ship";
        return example;
    }

    public static Shipment example4() {
        Shipment example = new Shipment();
        example.quantityShipped = "4 ton";
        example.shipMode = "Ship";
        return example;
    }

    public static Shipment example5() {
        Shipment example = new Shipment();
        example.quantityShipped = "6 ton";
        example.shipMode = "Plane";
        return example;
    }

    public static Shipment example6() {
        Shipment example = new Shipment();
        example.quantityShipped = "2 kg";
        example.shipMode = "Pony Express";
        return example;
    }

    public void prepareForInsert(DescriptorEvent event) {
        AbstractSession session = event.getSession();
        if (this.creationTimestamp != null) {
            throw new RuntimeException("Insert event fired twice");
        }
        this.creationTimestamp = new Timestamp(System.currentTimeMillis());
        while (this.creationTimestamp.equals(lastCreationTimestamp)) {
            try {
                Thread.sleep(1L);
                if (session.getLogin().getPlatform().isSymfoware()) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.creationTimestamp = new Timestamp(System.currentTimeMillis());
        }
        lastCreationTimestamp = (Timestamp)this.creationTimestamp.clone();
        if (session.getLogin().getPlatform().isDB2() || session.getLogin().getPlatform().isAccess() || session.getLogin().getPlatform().isSQLServer() || session.getLogin().getPlatform().isOracle() || session.getLogin().getPlatform().isSybase() || session.getLogin().getPlatform().isSQLAnywhere() || session.getLogin().getPlatform().isMySQL() || session.getLogin().getPlatform().isSymfoware()) {
            this.creationTimestampMillis = this.creationTimestamp.getNanos();
            this.creationTimestamp.setNanos(0);
        }
    }

    public void removeEmployee(Employee employee) {
        this.employees.removeElement(employee);
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_SHIP");
        definition.addPrimaryKeyField("SP_TS", Timestamp.class);
        definition.addPrimaryKeyField("SP_TSMIL", Integer.class);
        definition.addField("QUANTITY", String.class, 20);
        definition.addField("SHP_MODE", String.class, 50);
        return definition;
    }

    public String toString() {
        return "Shipment(" + this.quantityShipped + ")";
    }
}

