/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.bldnumberdetection;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.persistence.Version;

public class BuildNumberDetectionTester {
    public static void main(String[] args) throws IOException {
        FileWriter sucDifWriter;
        String tWork = System.getenv("T_WORK");
        String sucDifFile = tWork + File.separator + "buildnumbermatch";
        System.out.println("T_WORK:  " + tWork);
        System.out.println("filename:  " + sucDifFile);
        System.out.println(Version.getProduct() + " jar build String:  " + Version.getVersionString());
        System.out.println(Version.getProduct() + " jar build date (yymmdd):  " + Version.getBuildDate());
        if (args != null) {
            String strLine;
            FileInputStream fstream = new FileInputStream(tWork + File.separator + "mats-bld-toplink-oc4j" + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String tlOc4jJarBuildNumber = "undefined";
            while ((strLine = br.readLine()) != null) {
                if (!strLine.startsWith("Implementation-Version")) continue;
                tlOc4jJarBuildNumber = strLine.substring(strLine.lastIndexOf(46) + 1);
            }
            in.close();
            System.out.println("toplink-oc4j.jar test jar build:  " + tlOc4jJarBuildNumber);
            String testBuildNumber = args[0].substring(args[0].lastIndexOf(46) + 1);
            System.out.println("TopLink test jar build:  " + testBuildNumber);
            if (Version.getBuildNumber().equals(tlOc4jJarBuildNumber)) {
                if (Version.getBuildNumber().equals(testBuildNumber)) {
                    sucDifWriter = new FileWriter(sucDifFile + ".result");
                    sucDifWriter.write("The builds match: " + Version.getBuildNumber() + "(toplink.jar) and " + testBuildNumber + "(test jars).");
                } else {
                    sucDifWriter = new FileWriter(sucDifFile + ".result");
                    sucDifWriter.write("The builds DO NOT match: " + Version.getBuildNumber() + "(toplink.jar) and " + testBuildNumber + "(test jars).");
                }
            } else {
                sucDifWriter = new FileWriter(sucDifFile + ".result");
                sucDifWriter.write("The TopLink binaries DO NOT match: " + Version.getBuildNumber() + "(toplink.jar) and " + tlOc4jJarBuildNumber + "(toplink-oc4j.jar).");
            }
        } else {
            sucDifWriter = new FileWriter(sucDifFile + ".result");
            sucDifWriter.write("No test build number provided: " + Version.getBuildNumber() + "(toplink.jar).");
        }
        sucDifWriter.close();
    }
}

