/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transactions;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class InsertRollbackTransactionTest
extends AutoVerifyTestCase {
    Employee employee;
    Expression searchExpression;

    public InsertRollbackTransactionTest() {
        this.createEmployeeAndSearchExpression();
    }

    private void createEmployeeAndSearchExpression() {
        this.employee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        this.employee.setFirstName("Timugen");
        this.employee.setLastName("Singaera");
        this.employee.addResponsibility("Answer the phones.");
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression exp1 = expressionBuilder.get("firstName").equal((Object)this.employee.getFirstName());
        Expression exp2 = expressionBuilder.get("lastName").equal((Object)this.employee.getLastName());
        this.searchExpression = exp1.or(exp2);
    }

    public String getDescription() {
        return "This test verifies that the commit transaction feature works for database inserts.";
    }

    private Employee getEmployee() {
        return this.employee;
    }

    private Expression getSearchExpression() {
        return this.searchExpression;
    }

    public void reset() {
        Employee databaseEmployee = (Employee)this.getSession().readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            this.getDatabaseSession().deleteObject((Object)this.getEmployee());
        }
    }

    protected void resetVerify() {
        Session session = this.getSession();
        Employee databaseEmployee = (Employee)session.readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            throw new TestErrorException("The example employee object should have been deleted from the database.");
        }
    }

    protected void test() {
        this.getDatabaseSession().beginTransaction();
        this.getDatabaseSession().insertObject((Object)this.getEmployee());
        this.getDatabaseSession().rollbackTransaction();
    }

    protected void verify() {
        Employee databaseEmployee = (Employee)this.getSession().readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            this.getDatabaseSession().deleteObject((Object)this.getEmployee());
            throw new TestErrorException("Employee object should not have been inserted into database after rollback.");
        }
    }
}

