/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.utility;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class CollectionTools {
    private CollectionTools() {
    }

    public static <T extends Collection<E>, E> T addAll(T collection, E[] array) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            collection.add(item);
            ++n2;
        }
        return collection;
    }

    public static <T extends Collection<E>, E> T addAll(T collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <T extends Collection<E>, E> T addAll(T collection, Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <T> T[] array(Class<T> componentType, Iterable<? extends T> iterable) {
        return CollectionTools.array(componentType, iterable.iterator());
    }

    public static <T> T[] array(Class<T> componentType, Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        Object[] array = (Object[])Array.newInstance(componentType, list.size());
        return list.toArray(array);
    }

    public static <E> List<E> list(E ... array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            list.add(item);
            ++n2;
        }
        return list;
    }

    public static <T> List<T> list(Iterator<? extends T> iterator) {
        return CollectionTools.addAll(new ArrayList(), iterator);
    }
}

