/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Camera;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.models.optimisticlocking.PowerSupplyUnit;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullAggregateValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected GamesConsole original;
    protected GamesConsole original2;

    public UpdateNullAggregateValueTest(Class optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(GamesConsole.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new GamesConsole("PloughStation3", "black");
        this.original.setCamera(new Camera("lookcam3", "black"));
        this.original.setPsu(null);
        this.original2 = new GamesConsole();
        this.original2.setName("GameCub");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit("7-898-213-378"));
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit("6-432-573-232"));
            this.readObjectAndModifyAttributeValue(null);
            this.readObjectAndModifyAttributeValue("7-432-888-44");
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit("5-321-325-183"));
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit(null));
            this.readObjectAndModifyAttributeValue("2-322-324-678");
            this.readObjectAndModifyAttributeValue("5-324-874-273");
            this.readObjectAndChangeAttributeValue(new PowerSupplyUnit("6-432-573-232"));
            this.readObjectAndChangeAttributeValue(null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
            this.tlException.printStackTrace();
        }
    }

    public void readObjectAndChangeAttributeValue(PowerSupplyUnit newObject) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullAggregateValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        clone.setPsu(newObject);
        uow.commit();
    }

    public void readObjectAndModifyAttributeValue(String newSerialNumber) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullAggregateValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        clone.getPsu().setSerialNumber(newSerialNumber);
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

