/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Cubicle;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class InterfaceProxyInvocationTest
extends AutoVerifyTestCase {
    protected Cubicle cubicle;
    protected Employee employee;

    public InterfaceProxyInvocationTest() {
        this.setDescription("Tests an attempt to invoke a method on a value-held proxy-indirection enabled object that is null");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector theCondemned = uow.readAllObjects(Employee.class);
        uow.deleteAllObjects((Collection)theCondemned);
        uow.commit();
        this.cubicle = (Cubicle)this.getSession().readObject(Cubicle.class);
    }

    public void test() {
        this.employee = this.cubicle.getEmployee();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() {
        block8: {
            boolean exceptionThrown = false;
            if (this.employee == null) {
                throw new TestErrorException("Proxy for Employee should not be null");
            }
            try {
                String string = this.employee.getFirstName();
            }
            catch (Exception n) {
                exceptionThrown = true;
                if (!(n instanceof EclipseLinkException)) {
                    throw new TestErrorException("Unhandled non-TopLink Exception occurred upon invocation of getName() on employee");
                }
                EclipseLinkException w = (EclipseLinkException)((Object)n);
                if (w.getErrorCode() != 7103) {
                    throw new TestErrorException("An unexpected exception occurred", (Throwable)w);
                }
            }
            finally {
                if (exceptionThrown) break block8;
                throw new TestErrorException("No exception was thrown within the test case. Expected an exception.");
            }
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
    }
}

