/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;

public class JoinedAttributeAdvancedJunitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Employee.class, Address.class, PhoneNumber.class, Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null, null, null};
    protected static EmployeePopulator populator = new EmployeePopulator();
    protected DatabaseSession dbSession;

    public JoinedAttributeAdvancedJunitTest() {
    }

    public JoinedAttributeAdvancedJunitTest(String name) {
        super(name);
    }

    protected DatabaseSession getDbSession() {
        if (this.dbSession == null) {
            this.dbSession = JoinedAttributeAdvancedJunitTest.getServerSession();
        }
        return this.dbSession;
    }

    protected UnitOfWork acquireUnitOfWork() {
        return this.getDbSession().acquireUnitOfWork();
    }

    protected void clear() {
        UnitOfWork uow = this.acquireUnitOfWork();
        if (!JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            UpdateAllQuery updateEmployees = new UpdateAllQuery(Employee.class);
            updateEmployees.addUpdate("manager", null);
            updateEmployees.addUpdate("address", null);
            uow.executeQuery((DatabaseQuery)updateEmployees);
            uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Employee.class));
        } else {
            for (Employee emp : uow.readAllObjects(Employee.class)) {
                emp.setManager(null);
                emp.setAddress((String)null);
                uow.deleteObject((Object)emp);
            }
        }
        UpdateAllQuery updateProjects = new UpdateAllQuery(Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(PhoneNumber.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Address.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Project.class));
        uow.commit();
        this.dbSessionClearCache();
    }

    protected void populate() {
        populator.buildExamples();
        populator.persistExample((Session)this.getDbSession());
        this.dbSessionClearCache();
        for (int i = 0; i < classes.length; ++i) {
            JoinedAttributeAdvancedJunitTest.objectVectors[i] = this.getDbSession().readAllObjects(classes[i]);
        }
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)JoinedAttributeAdvancedJunitTest.suiteSpring();
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersOuterJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersOuterJoinAddress_NoBase"));
        return suite;
    }

    public static Test suiteSpring() {
        TestSuite suite = new TestSuite();
        suite.setName("JoinedAttributeAdvancedJunitTest");
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testSetup"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembers"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersJoinAddress_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersJoinAddress_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersOuterJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersOuterJoinAddress_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProblemReporterProjectJoinTeamMembersJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProblemReporterProjectJoinTeamMembersJoinAddress_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjects"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjectsOnUOW"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinManagerAddressOuterJoinManagerAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinManagerAddressOuterJoinManagerAddress_NoBase"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToManyJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testMultipleUnrelatedResultWithOneToManyJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToOneJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testOuterJoinSortingWithOneToOneJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testFetchOuterJoinSubClass"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testAddressQK"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testManagedProjects"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testManagedLargeProjects"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectsQK"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testLargeProjects"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testOwner"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployees"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.populate();
        this.clearCache();
    }

    public void tearDown() {
        this.dbSessionClearCache();
        this.dbSession = null;
        super.tearDown();
    }

    public void testProjectJoinTeamMembers() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("teamMembers"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull() {
        this.internalProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull(false);
    }

    public void testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull_NoBase() {
        this.internalProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull(true);
    }

    protected void internalProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        Expression teamLeader = query.getExpressionBuilder().get("teamLeader");
        query.setSelectionCriteria(teamLeader.notNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        if (!noBase) {
            query.addJoinedAttribute(teamLeader);
        }
        Expression teamLeaderAddress = teamLeader.get("address");
        query.addJoinedAttribute(teamLeaderAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamMembersJoinAddress() {
        this.internalProjectJoinTeamMembersJoinAddress(false);
    }

    public void testProjectJoinTeamMembersJoinAddress_NoBase() {
        this.internalProjectJoinTeamMembersJoinAddress(true);
    }

    protected void internalProjectJoinTeamMembersJoinAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamMembersJoinAddress() {
        this.internalProjectOuterJoinTeamMembersJoinAddress(false);
    }

    public void testProjectOuterJoinTeamMembersJoinAddress_NoBase() {
        this.internalProjectOuterJoinTeamMembersJoinAddress(true);
    }

    protected void internalProjectOuterJoinTeamMembersJoinAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamMembersOuterJoinAddress() {
        this.internalProjectOuterJoinTeamMembersOuterJoinAddress(false);
    }

    public void testProjectOuterJoinTeamMembersOuterJoinAddress_NoBase() {
        this.internalProjectOuterJoinTeamMembersOuterJoinAddress(true);
    }

    protected void internalProjectOuterJoinTeamMembersOuterJoinAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamMembersOuterJoinAddress() {
        this.internalProjectJoinTeamMembersOuterJoinAddress(false);
    }

    public void testProjectJoinTeamMembersOuterJoinAddress_NoBase() {
        this.internalProjectJoinTeamMembersOuterJoinAddress(true);
    }

    protected void internalProjectJoinTeamMembersOuterJoinAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProblemReporterProjectJoinTeamMembersJoinAddress() {
        this.internalProblemReporterProjectJoinTeamMembersJoinAddress(false);
    }

    public void testProblemReporterProjectJoinTeamMembersJoinAddress_NoBase() {
        this.internalProblemReporterProjectJoinTeamMembersJoinAddress(true);
    }

    protected void internalProblemReporterProjectJoinTeamMembersJoinAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporter"));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinProjects() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("projects"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinProjectsOnUOW() {
        Collection controlledResults;
        String errorMsg;
        if (JoinedAttributeAdvancedJunitTest.usesSOP()) {
            return;
        }
        ReadAllQuery controlQuery = new ReadAllQuery();
        controlQuery.setReferenceClass(Employee.class);
        ReadAllQuery queryWithJoins = (ReadAllQuery)controlQuery.clone();
        queryWithJoins.addJoinedAttribute(queryWithJoins.getExpressionBuilder().anyOf("projects"));
        UnitOfWork uow = this.acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)controlQuery);
        uow.commit();
        ((UnitOfWorkImpl)uow).setShouldCascadeCloneToJoinedRelationship(true);
        Collection results = (Collection)uow.executeQuery((DatabaseQuery)queryWithJoins);
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (JoinedAttributeAdvancedJunitTest.usesSOP()) {
            queryWithJoins.setShouldUseSerializedObjectPolicy(false);
        }
        if ((errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)(controlledResults = (Collection)this.getDbSession().executeQuery((DatabaseQuery)queryWithJoins)), (Collection)results, (ClassDescriptor)controlQuery.getDescriptor(), (AbstractSession)((AbstractSession)this.getDbSession()))).length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull() {
        this.internalEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull(false);
    }

    public void testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull_NoBase() {
        this.internalEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull(true);
    }

    protected void internalEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("manager").isNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression projects = query.getExpressionBuilder().anyOf("projects");
        if (!noBase) {
            query.addJoinedAttribute(projects);
        }
        Expression teamLeader = projects.get("teamLeader");
        if (!noBase) {
            query.addJoinedAttribute(teamLeader);
        }
        Expression teamLeaderAddress = teamLeader.get("address");
        query.addJoinedAttribute(teamLeaderAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName() {
        this.internalProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName(false);
    }

    public void testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName_NoBase() {
        this.internalProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName(true);
    }

    protected void internalProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporting System").or(query.getExpressionBuilder().get("name").equal((Object)"Bleep Blob")));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamLeader = query.getExpressionBuilder().getAllowingNull("teamLeader");
        if (!noBase) {
            query.addJoinedAttribute(teamLeader);
        }
        Expression teamLeaderAddress = teamLeader.getAllowingNull("address");
        query.addJoinedAttribute(teamLeaderAddress);
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        Expression teamMembersPhones = teamMembers.anyOfAllowingNone("phoneNumbers");
        query.addJoinedAttribute(teamMembersPhones);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones() {
        this.internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones(false);
    }

    public void testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones_NoBase() {
        this.internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones(true);
    }

    protected void internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().getAllowingNull("address"));
        query.addJoinedAttribute(query.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        Expression projects = query.getExpressionBuilder().anyOfAllowingNone("projects");
        if (!noBase) {
            query.addJoinedAttribute(projects);
        }
        Expression teamLeader = projects.getAllowingNull("teamLeader");
        if (!noBase) {
            query.addJoinedAttribute(teamLeader);
        }
        Expression teamLeaderAddress = teamLeader.getAllowingNull("address");
        query.addJoinedAttribute(teamLeaderAddress);
        Expression teamMembers = projects.anyOfAllowingNone("teamMembers");
        if (!noBase) {
            query.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersPhones = teamMembers.anyOfAllowingNone("phoneNumbers");
        query.addJoinedAttribute(teamMembersPhones);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW() {
        this.internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW(false);
    }

    public void testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW_NoBase() {
        this.internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW(true);
    }

    protected void internalEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhonesOnUOW(boolean noBase) {
        ReadAllQuery controlQuery = new ReadAllQuery();
        controlQuery.setReferenceClass(Employee.class);
        ReadAllQuery queryWithJoins = (ReadAllQuery)controlQuery.clone();
        queryWithJoins.addJoinedAttribute(queryWithJoins.getExpressionBuilder().getAllowingNull("address"));
        queryWithJoins.addJoinedAttribute(queryWithJoins.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        Expression projects = queryWithJoins.getExpressionBuilder().anyOfAllowingNone("projects");
        if (!noBase) {
            queryWithJoins.addJoinedAttribute(projects);
        }
        Expression teamLeader = projects.getAllowingNull("teamLeader");
        if (!noBase) {
            queryWithJoins.addJoinedAttribute(teamLeader);
        }
        Expression teamLeaderAddress = teamLeader.getAllowingNull("address");
        queryWithJoins.addJoinedAttribute(teamLeaderAddress);
        Expression teamMembers = projects.anyOfAllowingNone("teamMembers");
        if (!noBase) {
            queryWithJoins.addJoinedAttribute(teamMembers);
        }
        Expression teamMembersPhones = teamMembers.anyOfAllowingNone("phoneNumbers");
        queryWithJoins.addJoinedAttribute(teamMembersPhones);
        UnitOfWork uow = this.acquireUnitOfWork();
        uow.commit();
        uow.executeQuery((DatabaseQuery)controlQuery);
        ((UnitOfWorkImpl)uow).setShouldCascadeCloneToJoinedRelationship(true);
        Collection results = (Collection)uow.executeQuery((DatabaseQuery)queryWithJoins);
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Collection controlledResults = (Collection)JoinedAttributeTestHelper.getControlResultsFromControlQuery((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)queryWithJoins, (AbstractSession)((AbstractSession)uow));
        String errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)controlledResults, (Collection)results, (ClassDescriptor)controlQuery.getDescriptor(), (AbstractSession)((AbstractSession)this.getDbSession()));
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinManagerAddressOuterJoinManagerAddress() {
        this.internalEmployeeJoinManagerAddressOuterJoinManagerAddress(false);
    }

    public void testEmployeeJoinManagerAddressOuterJoinManagerAddress_NoBase() {
        this.internalEmployeeJoinManagerAddressOuterJoinManagerAddress(true);
    }

    protected void internalEmployeeJoinManagerAddressOuterJoinManagerAddress(boolean noBase) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("lastName").equal((Object)"Way").or(query.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression manager = query.getExpressionBuilder().get("manager");
        if (!noBase) {
            query.addJoinedAttribute(manager);
        }
        query.addJoinedAttribute(manager.get("address"));
        Expression managersManager = manager.getAllowingNull("manager");
        if (!noBase) {
            query.addJoinedAttribute(managersManager);
        }
        query.addJoinedAttribute(managersManager.get("address"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToManyJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession().logMessage("Test testTwoUnrelatedResultWithOneToManyJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getPhoneNumbers();
        Iterator iterator = emp.getPhoneNumbers().iterator();
        while (iterator.hasNext()) {
            ((PhoneNumber)iterator.next()).getOwner();
        }
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator2 = addr.getEmployees().iterator();
        while (iterator2.hasNext()) {
            ((Employee)iterator2.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("ID").equal(addr.getID())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().anyOf("phoneNumbers"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        DeleteAllQuery deleteAll = new DeleteAllQuery(PhoneNumber.class);
        deleteAll.setSelectionCriteria(deleteAll.getExpressionBuilder().get("owner").get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)deleteAll);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("ID").equal(addr.getID()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = (Employee)((Object[])result.firstElement())[0];
            Address addr2 = (Address)((Object[])result.firstElement())[1];
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("PhoneNumbers were not joined correctly, emp.getPhoneNumbers().size = " + emp.getPhoneNumbers().size() + " emp2.getPhoneNumbers().size = " + emp2.getPhoneNumbers().size()), (emp.getPhoneNumbers().size() == emp2.getPhoneNumbers().size() ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleUnrelatedResultWithOneToManyJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession().logMessage("Test testMultipleUnrelatedResultWithOneToManyJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().notEmpty("phoneNumbers"));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getPhoneNumbers();
        Iterator iterator = emp.getPhoneNumbers().iterator();
        while (iterator.hasNext()) {
            ((PhoneNumber)iterator.next()).getOwner();
        }
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        for (Employee addrEmp : addr.getEmployees()) {
            addrEmp.getAddress();
            addrEmp.getPhoneNumbers().size();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Address.class);
        ExpressionBuilder eb = new ExpressionBuilder(Employee.class);
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(eb.anyOf("phoneNumbers"));
        query.addItem("employee", (Expression)eb, list);
        list = new ArrayList();
        list.add(query.getExpressionBuilder().anyOf("employees"));
        query.addItem("address", (Expression)query.getExpressionBuilder(), list);
        query.setSelectionCriteria(query.getExpressionBuilder().get("ID").equal(addr.getID()));
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        DeleteAllQuery deleteAll = new DeleteAllQuery(PhoneNumber.class);
        deleteAll.setSelectionCriteria(deleteAll.getExpressionBuilder().get("owner").get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)deleteAll);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("ID").equal(addr.getID()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = null;
            Address addr2 = null;
            for (Object[] items : result) {
                emp2 = (Employee)items[0];
                if (!emp2.getId().equals(emp.getId())) continue;
                addr2 = (Address)items[1];
                break;
            }
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("PhoneNumbers were not joined correctly, emp.getPhoneNumbers().size = " + emp.getPhoneNumbers().size() + " emp2.getPhoneNumbers().size = " + emp2.getPhoneNumbers().size()), (emp.getPhoneNumbers().size() == emp2.getPhoneNumbers().size() ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToOneJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession().logMessage("Test testTwoUnrelatedResultWithOneToOneJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getAddress();
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator = addr.getEmployees().iterator();
        while (iterator.hasNext()) {
            ((Employee)iterator.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("ID").equal(addr.getID())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().get("address"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        List result = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)updall);
        updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("ID").equal(addr.getID()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = (Employee)((Object[])result.get(0))[0];
            Address addr2 = (Address)((Object[])result.get(0))[1];
            JoinedAttributeAdvancedJunitTest.assertTrue((String)"Address were not joined correctly, emp.getAddress() = null", (emp2.getAddress() != null ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    public void testOuterJoinSortingWithOneToOneJoins() {
        ReadAllQuery controlQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder controlBuilder = controlQuery.getExpressionBuilder();
        Expression dept = controlBuilder.get("department");
        controlQuery.setSelectionCriteria(dept.notNull().and(dept.get("departmentHead").isNull()));
        List controlResults = (List)this.getDbSession().executeQuery((DatabaseQuery)controlQuery);
        JoinedAttributeAdvancedJunitTest.assertNotNull((String)"Control query results should be non-null", (Object)controlResults);
        JoinedAttributeAdvancedJunitTest.assertFalse((String)"Control query results should be non-empty", (boolean)controlResults.isEmpty());
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("department");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("departmentHead");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("manager");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("address");
        query.addJoinedAttribute(expression);
        List actualResults = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        JoinedAttributeAdvancedJunitTest.assertNotNull((String)"Query results should be non-null.", (Object)actualResults);
        JoinedAttributeAdvancedJunitTest.assertFalse((String)"Query results should be non-empty.", (boolean)actualResults.isEmpty());
        JoinedAttributeAdvancedJunitTest.assertEquals((String)"Query results should be the same.", (int)controlResults.size(), (int)actualResults.size());
        for (Employee emp : controlResults) {
            if (actualResults.contains(emp)) continue;
            JoinedAttributeAdvancedJunitTest.fail((String)("Actual results do not contain employee with id " + emp.getId()));
        }
    }

    public void testFetchOuterJoinSubClass() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        ExpressionBuilder eb = query.getExpressionBuilder();
        Expression expression = eb.getAllowingNull("address");
        query.addJoinedAttribute(expression);
        expression = eb.get("manager");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("address");
        query.addJoinedAttribute(expression);
        expression = eb.getAllowingNull("hugeProject");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("evangelist");
        query.addJoinedAttribute(expression);
        List results = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession().logMessage("Test testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getAddress();
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator = addr.getEmployees().iterator();
        while (iterator.hasNext()) {
            ((Employee)iterator.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("ID").equal(addr.getID())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().get("address"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        query.addItem("employee_name", query.getExpressionBuilder().get("firstName"));
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        List result = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)updall);
        updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("ID").equal(addr.getID()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = (Employee)((Object[])result.get(0))[0];
            Address addr2 = (Address)((Object[])result.get(0))[2];
            JoinedAttributeAdvancedJunitTest.assertTrue((String)"Address were not joined correctly, emp.getAddress() = null", (emp2.getAddress() != null ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
            if (!emp2.getFirstName().equals(((Object[])result.get(0))[1])) {
                JoinedAttributeAdvancedJunitTest.fail((String)"Failed to return employee name as an separate item");
            }
        }
        finally {
            this.testSetup();
        }
    }

    public void testAddressQK() {
        ReadAllQuery controlQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder controlEb = controlQuery.getExpressionBuilder();
        controlQuery.setSelectionCriteria(controlEb.getAllowingNull("address").get("city").like("O%"));
        List controlEmps = (List)this.getDbSession().executeQuery((DatabaseQuery)controlQuery);
        if (controlEmps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail((String)"Test setup problem: control query result is empty. Choose selection criteria such that something is actually selected");
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.getAllowingNull("addressQK").get("city").like("O%"));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        String errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)controlEmps, (Collection)emps, (ClassDescriptor)this.getDbSession().getDescriptor(Employee.class), (AbstractSession)((AbstractSession)this.getDbSession()));
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testManagedProjects() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("managedProjects").get("name").containsSubstring("Enterprise"));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (emps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    public void testManagedLargeProjects() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("managedLargeProjects").get("name").containsSubstring("Enterprise"));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (emps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    public void testProjectsQK() {
        ReadAllQuery controlQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder controlEb = controlQuery.getExpressionBuilder();
        controlQuery.setSelectionCriteria(controlEb.anyOfAllowingNone("projects").get("name").containsSubstring("Enterprise"));
        List controlEmps = (List)this.getDbSession().executeQuery((DatabaseQuery)controlQuery);
        if (controlEmps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail((String)"Test setup problem: control query result is empty. Choose selection criteria such that something is actually selected");
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("projectsQK").get("name").containsSubstring("Enterprise"));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (emps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    public void testLargeProjects() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("largeProjects").get("name").containsSubstring("Enterprise"));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (emps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    public void testResponsibilitiesQK() {
        ReadAllQuery controlQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder controlEb = controlQuery.getExpressionBuilder();
        controlQuery.setSelectionCriteria(controlEb.anyOfAllowingNone("responsibilities").equal((Object)"Make the coffee."));
        List controlEmps = (List)this.getDbSession().executeQuery((DatabaseQuery)controlQuery);
        if (controlEmps.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail((String)"Test setup problem: control query result is empty. Choose selection criteria such that something is actually selected");
        }
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("responsibilitiesQK").equal((Object)"Make the coffee."));
        List emps = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        String errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)controlEmps, (Collection)emps, (ClassDescriptor)this.getDbSession().getDescriptor(Employee.class), (AbstractSession)((AbstractSession)this.getDbSession()));
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testOwner() {
        ReadAllQuery query = new ReadAllQuery(Address.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.getAllowingNull("owner").get("firstName").like("J%"));
        List addresses = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (addresses.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    public void testEmployees() {
        ReadAllQuery query = new ReadAllQuery(Project.class);
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.anyOfAllowingNone("employees").get("firstName").equal((Object)"John"));
        List projects = (List)this.getDbSession().executeQuery((DatabaseQuery)query);
        if (projects.isEmpty()) {
            JoinedAttributeAdvancedJunitTest.fail();
        }
    }

    protected String executeQueriesAndCompareResults(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins) {
        return JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)queryWithJoins, (AbstractSession)((AbstractSession)this.getDbSession()));
    }

    protected boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (this.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = this.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = this.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)this.getDbSession())) continue;
            return false;
        }
        return true;
    }

    public void dbSessionClearCache() {
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

