/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class CompareKeyWithBackupTest
extends TestCase {
    protected Restaurant originalRestaurant = null;
    protected String menuType;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.originalRestaurant = null;
        this.beginTransaction();
        Vector restaurants = this.getSession().readAllObjects(Restaurant.class);
        Iterator iterator = restaurants.iterator();
        while (this.originalRestaurant == null && iterator.hasNext()) {
            Restaurant restaurant = (Restaurant)iterator.next();
            if (restaurant.getMenus().size() <= 0) continue;
            this.originalRestaurant = restaurant;
        }
        if (this.originalRestaurant == null) {
            throw new TestErrorException("Unable to SetUp Test need to add restaurant with a menu");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Restaurant restaurantClone = (Restaurant)uow.registerObject((Object)this.originalRestaurant);
        restaurantClone.getMenus();
        Iterator enumtr = this.originalRestaurant.getMenus().values().iterator();
        Menu menu = (Menu)enumtr.next();
        this.menuType = menu.getType();
        menu.setType("Brunch");
        this.originalRestaurant.getMenus().remove(this.menuType);
        this.originalRestaurant.addMenu(menu);
        uow.commit();
    }

    public void verify() {
        if (this.originalRestaurant.getMenus().containsKey(this.menuType)) {
            throw new TestErrorException("CR 4172 Even though the key in a Map did not change in the clone it was updated in the shared cache");
        }
    }
}

