/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ScrollableCursorAPITest
extends TestCase {
    protected ScrollableCursor employeeStream;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public ScrollableCursorAPITest() {
        this.setDescription("Test the scrollable cursor APIs like hasNext(), hasPrevious() when no result will be returned from the query");
    }

    protected void setup() {
        if (this.getSession().getPlatform().isDB2() || this.getSession().getPlatform().isAccess() || this.getSession().getPlatform().isTimesTen() || this.getSession().getPlatform().isHANA()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform");
        }
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        if (this.getSession().getPlatform().isSymfoware()) {
            this.CONCUR_UPDATABLE_isSupported = false;
        }
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("lastName").like("%blablablabla%");
        query.setSelectionCriteria(exp);
        if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
            query.useScrollableCursor();
        } else {
            ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
            if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                policy.setResultSetType(1005);
            }
            if (!this.CONCUR_UPDATABLE_isSupported) {
                policy.setResultSetConcurrency(1007);
            }
            policy.setPageSize(10);
            query.useScrollableCursor(policy);
        }
        this.employeeStream = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        if (this.employeeStream.hasNext() || this.employeeStream.hasPrevious() || this.employeeStream.isLast() || this.employeeStream.isFirst()) {
            this.employeeStream.close();
            throw new TestErrorException("The  the scrollable cursor APIs are not working properly");
        }
        this.employeeStream.close();
    }
}

