/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class MemoryQueryAcrossManyToManyAcrossOneToManyMapping
extends AutoVerifyTestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadAllQuery queryObjects;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector employees;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.allEmployees = new Vector();
        this.employees = new Vector();
        Vector<Employee> leaders = new Vector<Employee>();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("projects").get("teamLeader").anyOf("phoneNumbers").get("areaCode").greaterThan((Object)"416"));
        this.getSession().removeQuery("getAllEmployees");
        this.getSession().addQuery("getAllEmployees", (DatabaseQuery)this.queryAll);
        this.allEmployees = this.getSession().readAllObjects(Employee.class);
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            Vector projects = ((Employee)enumtr.nextElement()).getProjects();
            this.employees.addAll(projects);
        }
        enumtr = this.employees.elements();
        while (enumtr.hasMoreElements()) {
            Employee leader = (Employee)((Project)enumtr.nextElement()).getTeamLeader();
            if (leader == null) continue;
            leaders.add(leader);
        }
        enumtr = leaders.elements();
        while (enumtr.hasMoreElements()) {
            Vector phones = ((Employee)enumtr.nextElement()).getPhoneNumbers();
            Vector allPhones = new Vector();
            allPhones.addAll(phones);
        }
    }

    public void test() {
        this.queryObjects = new ReadAllQuery();
        this.queryObjects.setReferenceClass(Employee.class);
        this.queryObjects.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("projects").get("teamLeader").anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        this.queryObjects.setSelectionCriteria(exp);
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryObjects);
    }
}

