/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.CMClient;
import org.eclipse.persistence.testing.tests.clientserver.CMServer;

public class ConcurrencyManagerTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected CMClient[] clients;
    protected CMServer server;
    protected final int MaxThread;

    public ConcurrencyManagerTest() {
        this.MaxThread = 200;
        this.clients = new CMClient[this.MaxThread];
        this.setDescription("Tests Read concurrency with the Concurrency Manager");
    }

    public void reset() {
        block3: {
            try {
                for (int index = 0; index < this.MaxThread; ++index) {
                    this.clients[index].release();
                }
                this.server.logout();
                this.getDatabaseSession().logout();
                this.getDatabaseSession().login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void setup() {
        block3: {
            try {
                this.login = (DatabaseLogin)this.getSession().getLogin().clone();
                this.server = new CMServer(this.login);
                this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
                this.server.login();
                this.server.copyDescriptors(this.getSession());
                for (int index = 0; index < this.MaxThread; ++index) {
                    this.clients[index] = new CMClient(this.server, index, this.getSession());
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void test() {
        block6: {
            try {
                int index;
                for (index = 0; index < this.MaxThread; ++index) {
                    this.clients[index].start();
                }
                try {
                    for (index = 0; index < this.MaxThread; ++index) {
                        this.clients[index].join();
                    }
                }
                catch (InterruptedException exception) {
                    TestErrorException testException = new TestErrorException("Client threads are interrupted");
                    testException.setInternalException((Throwable)exception);
                    throw testException;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void verify() {
        try {
            if (this.server.errorOccured) {
                throw new TestErrorException("An error occurred on one of the clients, check System.out.");
            }
            for (int index = 0; index < this.MaxThread; ++index) {
                if (this.clients[0].objectRead == this.clients[index].objectRead) continue;
                throw new TestErrorException("Objects are not the same!!!");
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof ValidationException) || ((ValidationException)((Object)ex)).getErrorCode() == 7090) {
                // empty if block
            }
        }
    }
}

