/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NoDefaultNullValueTest
extends AutoVerifyTestCase {
    Map saveDefaultNullValues;
    Employee employee;

    public NoDefaultNullValueTest() {
        this.setDescription("Verify that the appropriate values are put in the object when nulls are encountered on the database");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().getLogin().getPlatform().getConversionManager().setDefaultNullValues(this.saveDefaultNullValues);
    }

    protected void setup() {
        this.saveDefaultNullValues = this.getSession().getLogin().getPlatform().getConversionManager().getDefaultNullValues();
        this.getSession().getLogin().getPlatform().getConversionManager().setDefaultNullValues(new Hashtable());
        this.beginTransaction();
        this.employee = new Employee();
        this.employee.setFirstName(null);
        this.employee.setLastName("Flintstone");
        this.employee.setSalary(22);
        this.employee.setGender("Male");
        this.getDatabaseSession().writeObject((Object)this.employee);
        this.getSession().executeNonSelectingCall((Call)new SQLCall("update SALARY set SALARY = null where EMP_ID = " + this.employee.getId()));
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        try {
            this.employee = (Employee)this.getSession().readObject((Object)this.employee);
        }
        catch (NullPointerException exception) {
            throw new TestErrorException("Null Pointer exception was thrown when null was returned from the database for a primitive attribute");
        }
    }

    protected void verify() {
    }
}

