/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class NestedUOWWithNewObjectRegisteredTwiceTest
extends AutoVerifyTestCase {
    String firstName;
    String areaCode;
    PhoneNumber pNT02REL;
    PhoneNumber pNT02REG;

    public NestedUOWWithNewObjectRegisteredTwiceTest() {
        this.setDescription("");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        this.firstName = "Master_" + System.currentTimeMillis();
        this.areaCode = "617";
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee emp = (Employee)uow.registerObject((Object)new Employee());
        emp.setFirstName(this.firstName);
        uow.commit();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
    }

    public void test() {
        Employee empRO = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)this.firstName));
        UnitOfWork uowT0 = this.getSession().acquireUnitOfWork();
        Employee empT0 = (Employee)uowT0.registerObject((Object)empRO);
        UnitOfWork uowT01 = uowT0.acquireUnitOfWork();
        Employee empT01 = (Employee)uowT01.registerObject((Object)empT0);
        PhoneNumber pN = (PhoneNumber)uowT01.registerObject((Object)new PhoneNumber());
        pN.setAreaCode(this.areaCode);
        empT01.addPhoneNumber(pN);
        uowT01.commit();
        PhoneNumber pNT0 = (PhoneNumber)empT0.getPhoneNumbers().get(0);
        UnitOfWork uowT02 = uowT0.acquireUnitOfWork();
        uowT02.setShouldNewObjectsBeCached(true);
        Employee empT02 = (Employee)uowT02.registerObject((Object)empT0);
        this.pNT02REL = (PhoneNumber)empT02.getPhoneNumbers().get(0);
        this.pNT02REG = (PhoneNumber)uowT02.registerObject((Object)pNT0);
        uowT0.commit();
    }

    protected void verify() {
        if (this.pNT02REL != this.pNT02REG) {
            throw new TestErrorException("PhoneNumber is registered twice in the nested unit of work");
        }
    }
}

