/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.lob;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.lob.Image;
import org.eclipse.persistence.testing.models.jpa.lob.ImageSimulator;
import org.eclipse.persistence.testing.models.jpa.lob.LobTableCreator;
import org.eclipse.persistence.testing.models.jpa.lob.SerializableNonEntity;

public class LobJUnitTestCase
extends JUnitTestCase {
    private static Integer imageId;
    private static Image originalImage;

    public LobJUnitTestCase() {
    }

    public LobJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Lob Model");
        suite.addTest((Test)new LobJUnitTestCase("testSetup"));
        suite.addTest((Test)new LobJUnitTestCase("testMerge"));
        suite.addTest((Test)new LobJUnitTestCase("testCreate"));
        suite.addTest((Test)new LobJUnitTestCase("testRead"));
        suite.addTest((Test)new LobJUnitTestCase("testUpdate"));
        suite.addTest((Test)new LobJUnitTestCase("testDelete"));
        suite.addTest((Test)new LobJUnitTestCase("testMerge"));
        suite.addTest((Test)new LobJUnitTestCase("testRetrieveLazyBasicAfterTxnReadCommit"));
        return suite;
    }

    public void testSetup() {
        new LobTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCreate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Image image;
            originalImage = image = ImageSimulator.generateImage((int)4800, (int)4500);
            em.persist((Object)image);
            imageId = image.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testDelete() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Image.class, (Object)imageId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        LobJUnitTestCase.assertTrue((String)"Error deleting Image", (em.find(Image.class, (Object)imageId) == null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testRead() throws Exception {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Image image = (Image)em.find(Image.class, (Object)imageId);
        try {
            LobJUnitTestCase.assertTrue((image.getId() == imageId.intValue() ? 1 : 0) != 0);
            if (image instanceof PersistenceWeaved) {
                Field field = image.getClass().getDeclaredField("audio");
                field.setAccessible(true);
                if (field.get(image) != null) {
                    LobJUnitTestCase.fail((String)"Lazy basic should not be fetched.");
                }
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        LobJUnitTestCase.assertTrue((String)"byte-arrays do not match", (boolean)Helper.compareByteArrays((byte[])image.getAudio(), (byte[])originalImage.getAudio()));
        LobJUnitTestCase.assertTrue((String)"char-arrays do not match", (boolean)Helper.compareCharArrays((char[])image.getCommentary(), (char[])originalImage.getCommentary()));
        LobJUnitTestCase.assertTrue((String)"Byte-arrays do not match", (boolean)Helper.compareArrays((Object[])image.getPicture(), (Object[])originalImage.getPicture()));
        LobJUnitTestCase.assertTrue((boolean)image.getScript().equals(originalImage.getScript()));
    }

    public void testUpdate() {
        Image image;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            image = (Image)em.find(Image.class, (Object)imageId);
            image.setAudio(null);
            image.setCommentary(null);
            image.setPicture(null);
            image.setScript(null);
            em.merge((Object)image);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        image = (Image)em.find(Image.class, (Object)imageId);
        LobJUnitTestCase.assertNull((Object)image.getAudio());
        LobJUnitTestCase.assertNull((Object)image.getCommentary());
        LobJUnitTestCase.assertNull((Object)image.getPicture());
        LobJUnitTestCase.assertNull((Object)image.getScript());
        this.closeEntityManager(em);
    }

    public void testMerge() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Image image = new Image();
            image.setId(5001);
            SerializableNonEntity sne = new SerializableNonEntity();
            sne.setSomeValue(Long.valueOf(1L));
            image.setCustomAttribute1(sne);
            em.persist((Object)image);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            image.getCustomAttribute1().setSomeValue(Long.valueOf(2L));
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.merge((Object)image);
            this.commitTransaction(em);
            em.clear();
            this.clearCache();
            this.beginTransaction(em);
            image = (Image)em.find(Image.class, (Object)5001);
            LobJUnitTestCase.assertTrue((String)"Image.customAttribute1 not correctly updated.", (image.getCustomAttribute1().getSomeValue() == 2L ? 1 : 0) != 0);
            em.remove((Object)image);
            this.commitTransaction(em);
            this.clearCache();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetrieveLazyBasicAfterTxnReadCommit() {
        EntityManager em;
        Image image = null;
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            image = new Image();
            image.setId(1);
            image.setAudio(new byte[]{1, 2});
            image.setPicture(new Byte[]{(byte)3, (byte)4});
            em.persist((Object)image);
            int imageId = image.getId();
            this.commitTransaction(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Image i WHERE i.id > " + imageId).executeUpdate();
            image = (Image)em.find(Image.class, (Object)imageId);
            image.setPicture(new Byte[]{(byte)6, (byte)7});
            this.commitTransaction(em);
            em = this.createEntityManager();
            image = (Image)em.find(Image.class, (Object)imageId);
            LobJUnitTestCase.assertNotNull((String)"lazy basic entity audio is null ", (Object)image.getAudio());
        }
        finally {
            if (image != null) {
                em = this.createEntityManager();
                image = (Image)em.find(Image.class, (Object)image.getId());
                if (image != null) {
                    this.beginTransaction(em);
                    image = (Image)em.merge((Object)image);
                    em.remove((Object)image);
                    this.commitTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LobJUnitTestCase.suite());
    }
}

