/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProvider;
import junit.framework.Test;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.performance2.Address;
import org.eclipse.persistence.testing.models.jpa.performance2.Employee;
import org.eclipse.persistence.testing.models.jpa.performance2.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance2.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance2.Gender;
import org.eclipse.persistence.testing.models.jpa.performance2.JobTitle;
import org.eclipse.persistence.testing.models.jpa.performance2.LargeProject;
import org.eclipse.persistence.testing.models.jpa.performance2.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.performance2.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.performance.JPAPerformanceRegressionModel;
import org.eclipse.persistence.testing.tests.jpa.performance.misc.JPA2BootstrapPerformanceTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPA2ReadAllEmployeeCompletelyPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPA2ReadAllEmployeeComplexExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPA2ReadAllEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPA2ReadAllProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPA2ReadObjectCompletelyEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPA2ComplexUpdateEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPA2InsertDeleteEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPA2InsertEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPA2MassInsertEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPA2UpdateEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public class JPA2PerformanceRegressionModel
extends JPAPerformanceRegressionModel {
    public boolean isEmulated;

    public JPA2PerformanceRegressionModel() {
        this.setDescription("Performance tests that compare JPA 2 performance.");
    }

    @Override
    public void addTests() {
        this.addTest((Test)this.getReadingTestSuite());
        this.addTest((Test)this.getWritingTestSuite());
        this.addTest((Test)this.getMiscTestSuite());
    }

    @Override
    public TestSuite getReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPA2ReadingTestSuite");
        suite.setDescription("This suite tests reading performance.");
        suite.addTest((Test)new JPA2ReadAllEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPA2ReadAllEmployeeComplexExpressionPerformanceComparisonTest());
        suite.addTest((Test)new JPA2ReadAllEmployeeCompletelyPerformanceComparisonTest());
        suite.addTest((Test)new JPA2ReadAllProjectPerformanceComparisonTest());
        suite.addTest((Test)new JPA2ReadObjectCompletelyEmployeePerformanceComparisonTest());
        return suite;
    }

    @Override
    public TestSuite getWritingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPA2WritingTestSuite");
        suite.setDescription("This suite tests uow/writing performance.");
        suite.addTest((Test)new JPA2InsertEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPA2InsertDeleteEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPA2UpdateEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPA2ComplexUpdateEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPA2MassInsertEmployeePerformanceComparisonTest());
        return suite;
    }

    @Override
    public TestSuite getMiscTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAMiscTestSuite");
        suite.setDescription("This suite tests miscellaneous performance.");
        suite.addTest((Test)new JPA2BootstrapPerformanceTest());
        return suite;
    }

    @Override
    public void setupDatabase(EntityManager manager) {
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
    }

    @Override
    public void setup() {
        int j;
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EmulatedDriver.emulate = false;
        EntityManager em = this.getExecutor().createEntityManager();
        this.setupDatabase(em);
        em.getTransaction().begin();
        for (j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setGender(Gender.Male);
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000.0);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            employmentPeriod.setEndDate(1895, 1, 1);
            employmentPeriod.setStartDate(1901, 12, 31);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            empInsert.setJobTitle(new JobTitle("CO-OP"));
            empInsert.addDegree("BComp");
            empInsert.addDegree("MComp");
            empInsert.addEmailAddress("work", "bren@oracle.com");
            empInsert.addEmailAddress("home", "bren@rogers.com");
            empInsert.addResponsibility("fix bugs");
            empInsert.addResponsibility("run tests");
            em.persist((Object)empInsert);
        }
        for (j = 0; j < 50; ++j) {
            SmallProject project = new SmallProject("Tracker", "tracker app");
            project.setName("Tracker");
            em.persist((Object)project);
            project = new LargeProject();
            project.setName("Tracker");
            em.persist((Object)project);
        }
        em.getTransaction().commit();
        em.close();
        EmulatedDriver.emulate = true;
    }

    @Override
    public void setupProvider() {
        if (JUnitTestCase.isOnServer()) {
            return;
        }
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance2", properties));
    }
}

