/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.util.reflection.Reflections;

public class WeldUnusedMetadataExtension
implements Extension {
    private Set<InjectionPoint> componentInjectionPoints = new HashSet<InjectionPoint>();
    private Set<InjectionPoint> instanceInjectionPoints = new HashSet<InjectionPoint>();

    WeldUnusedMetadataExtension() {
    }

    void processInjectionPoints(@Observes ProcessInjectionPoint<?, ?> event) {
        if (event.getInjectionPoint().getBean() == null) {
            this.componentInjectionPoints.add(event.getInjectionPoint());
        }
        if (Instance.class.equals(Reflections.getRawType(event.getInjectionPoint().getType()))) {
            this.instanceInjectionPoints.add(event.getInjectionPoint());
        }
    }

    void clear(@Observes @Initialized(value=ApplicationScoped.class) Object obj) {
        this.componentInjectionPoints.clear();
        this.instanceInjectionPoints.clear();
    }

    public boolean isInjectedByEEComponent(Bean<?> bean, BeanManagerImpl beanManager) {
        if (this.componentInjectionPoints.isEmpty()) {
            return false;
        }
        for (InjectionPoint injectionPoint : this.componentInjectionPoints) {
            if (!((Set)beanManager.getBeanResolver().resolve(new ResolvableBuilder(injectionPoint, beanManager).create(), false)).contains(bean)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceResolvedBean(Bean<?> bean, BeanManagerImpl beanManager) {
        if (this.instanceInjectionPoints.isEmpty()) {
            return false;
        }
        for (InjectionPoint injectionPoint : this.instanceInjectionPoints) {
            Type facadeType = this.getFacadeType(injectionPoint);
            if (facadeType == null) continue;
            Resolvable resolvable = new ResolvableBuilder(facadeType, beanManager).addQualifiers(injectionPoint.getQualifiers()).setDeclaringBean(injectionPoint.getBean()).create();
            if (!((Set)beanManager.getBeanResolver().resolve(resolvable, false)).contains(bean)) continue;
            return true;
        }
        return false;
    }

    private Type getFacadeType(InjectionPoint injectionPoint) {
        Type genericType = injectionPoint.getType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return null;
    }
}

