/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.HouseClaim;

public class CacheHitWithNonPKCriteriaTest
extends ReadObjectTest {
    public CacheHitWithNonPKCriteriaTest() {
        this.setName("CacheHitWithNonPKCriteriaTest");
        this.setDescription("Test whether querying on PK plus additional fields (erroneously) results in a cache hit.");
    }

    public CacheHitWithNonPKCriteriaTest(Object originalObject) {
        super(originalObject);
        this.setName("CacheHitWithNonPKCriteriaTest");
        this.setDescription("Test whether querying on PK plus additional fields (erroneously) results in a cache hit.");
    }

    protected void setup() {
    }

    protected void test() {
        ExpressionBuilder builder1 = new ExpressionBuilder();
        Expression exp1 = builder1.get("id").equal(100);
        ReadObjectQuery query1 = new ReadObjectQuery(HouseClaim.class, exp1);
        HouseClaim claim = (HouseClaim)this.getSession().executeQuery((DatabaseQuery)query1);
        ExpressionBuilder builder2 = new ExpressionBuilder();
        Expression exp2 = builder2.get("id").equal(100);
        exp2 = exp2.and(builder2.get("amount").notEqual(claim.getAmount()));
        ReadObjectQuery query2 = new ReadObjectQuery(HouseClaim.class, exp2);
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)query2);
    }

    protected void verify() {
        if (this.originalObject != null) {
            throw new TestErrorException("Cache hit occurred when querying on PK plus additional field.");
        }
    }
}

