/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLStreamWriter {
    public void writeToStream(Node dom, String newUri, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xsw.writeStartDocument(doc.getXmlEncoding(), doc.getXmlVersion());
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, newUri, newName, xsw);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xsw.writeNamespace(attribute.getLocalName(), attribute.getValue());
            } else if (attribute.getPrefix() == null) {
                xsw.writeAttribute(attribute.getName(), attribute.getValue());
            } else {
                xsw.writeAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
            }
        } else if (currentNode.getNodeType() == 3) {
            xsw.writeCharacters(((Text)currentNode).getNodeValue());
        }
        if (dom.getNodeType() == 9) {
            xsw.writeEndDocument();
        }
    }

    private void writeElement(Element elem, String newNamespace, String newName, XMLStreamWriter xsw) throws XMLStreamException {
        String prefix = null;
        String namespace = null;
        String localName = null;
        String nodeName = null;
        if (newName != null) {
            namespace = newNamespace;
            localName = newName;
            nodeName = newName;
            if (newNamespace != null && newNamespace.length() > 0) {
                NamespaceResolver tempNR = new NamespaceResolver();
                tempNR.setDOM(elem);
                prefix = tempNR.resolveNamespaceURI(namespace);
                if (prefix == null || prefix.length() == 0) {
                    String defaultNamespace = elem.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    prefix = defaultNamespace == null ? tempNR.generatePrefix() : (defaultNamespace != namespace ? tempNR.generatePrefix() : "");
                }
            }
        } else {
            prefix = elem.getPrefix();
            namespace = elem.getNamespaceURI();
            localName = elem.getLocalName();
            nodeName = elem.getNodeName();
        }
        String defaultNamespace = xsw.getNamespaceContext().getNamespaceURI("");
        boolean needToAddDefaultNS = false;
        if (prefix != null && prefix.length() > 0) {
            String namespaceURI = xsw.getNamespaceContext().getNamespaceURI(prefix);
            xsw.writeStartElement(prefix, localName, namespace);
            if (!namespace.equals(namespaceURI)) {
                xsw.writeNamespace(prefix, namespace);
            }
        } else if (namespace == null || namespace.length() == 0) {
            xsw.writeStartElement(nodeName);
            if (defaultNamespace != null && defaultNamespace.length() > 0) {
                xsw.writeDefaultNamespace("");
            }
        } else {
            needToAddDefaultNS = true;
            xsw.writeStartElement("", localName, namespace);
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Attr> nonNamespaceDeclAttrs = new ArrayList<Attr>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getNodeType() != 2) continue;
            Attr attribute = attr;
            if (attr.getPrefix() != null && attr.getPrefix().equals("xmlns")) {
                String currentUri = xsw.getNamespaceContext().getNamespaceURI(attr.getLocalName());
                if (currentUri != null && currentUri.equals(attr.getValue())) continue;
                xsw.writeNamespace(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (attr.getName().equals("xmlns")) {
                xsw.writeDefaultNamespace(attr.getValue());
                needToAddDefaultNS = false;
                continue;
            }
            nonNamespaceDeclAttrs.add(attribute);
        }
        if (needToAddDefaultNS && (defaultNamespace == null || !defaultNamespace.equals(namespace))) {
            xsw.writeDefaultNamespace(namespace);
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xsw.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            xsw.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3) {
                xsw.writeCharacters(((Text)node).getNodeValue());
                continue;
            }
            if (node.getNodeType() == 4) {
                xsw.writeCData(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 8) {
                xsw.writeComment(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            this.writeElement((Element)node, null, null, xsw);
        }
        xsw.writeEndElement();
    }

    protected String getPrefix(NamespaceContext nc, Element elem, String uri) {
        NamespaceResolver tempResovler = new NamespaceResolver();
        tempResovler.setDOM(elem);
        String prefix = tempResovler.resolveNamespaceURI(uri);
        if (prefix == null || prefix.length() == 0) {
            prefix = tempResovler.generatePrefix();
        }
        return prefix;
    }
}

