/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.plugins;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JStringLiteral;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor2;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.AttributeUseImpl;
import com.sun.xml.xsom.impl.ParticleImpl;
import com.sun.xml.xsom.impl.RestrictionSimpleTypeImpl;
import com.sun.xml.xsom.impl.parser.DelayedRef;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class BeanValidationPlugin
extends Plugin {
    public static final String PLUGIN_OPTION = "XBeanVal";
    public static final String JSR_303_MOD = "jsr303";
    public static final String SIMPLE_REGEX_MOD = "simpleRegex";
    public static final String NS_URI = "http://jaxb.dev.java.net/plugin/bean-validation";
    public static final String FACET = "facet";
    private static final String VALUE = "value";
    private boolean jsr303 = false;
    private boolean simpleRegex = false;
    private static final String PATTERN_ANNOTATION_NOT_APPLICABLE = "Facet \"pattern\" was detected on a DOM node with non-string base type. Annotation was not generated, because it is not supported by the Bean Validation specification.";
    private final boolean securityEnabled = System.getSecurityManager() != null;
    private static final JClass ANNOTATION_VALID;
    private static final JClass ANNOTATION_NOTNULL;
    private static final JClass ANNOTATION_SIZE;
    private static final JClass ANNOTATION_DECIMALMIN;
    private static final JClass ANNOTATION_DECIMALMAX;
    private static final JClass ANNOTATION_DIGITS;
    private static final JClass ANNOTATION_PATTERN;
    private static final JClass ANNOTATION_PATTERNLIST;
    private static final JClass ANNOTATION_ASSERTFALSE;
    private static final JClass ANNOTATION_ASSERTTRUE;
    private static final JClass ANNOTATION_FUTURE;
    private static final JClass ANNOTATION_PAST;
    private static final JClass ANNOTATION_XMLELEMENT;
    private static final JCodeModel CODEMODEL;
    private final RegexMutator regexMutator = new RegexMutator();
    private static final Set<String> nonFloatingDigitsClasses;
    private static final Set<String> floatingDigitsClasses;
    private static final Map<String, MinMaxTuple> nonFloatingDigitsClassesBoundaries;

    public String getOptionName() {
        return PLUGIN_OPTION;
    }

    public String getUsage() {
        return "  -XBeanVal           :  convert xsd restrictions to jakarta.validation annotations. Usage with mods: -XBeanVal jsr303 simpleRegex";
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(NS_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(NS_URI) && localName.equals(FACET);
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int mods = 0;
        int argNumber = i;
        if ("-XBeanVal".equals(args[i])) {
            while (++argNumber < args.length) {
                if (args[argNumber].contains(JSR_303_MOD)) {
                    this.jsr303 = true;
                    ++mods;
                    continue;
                }
                if (!args[argNumber].contains(SIMPLE_REGEX_MOD)) continue;
                this.simpleRegex = true;
                ++mods;
            }
            return 1 + mods;
        }
        return 0;
    }

    public boolean run(Outline outline, Options opts, ErrorHandler errorHandler) {
        Visitor visitor = new Visitor();
        for (ClassOutline classOutline : outline.getClasses()) {
            for (CPropertyInfo property : classOutline.target.getProperties()) {
                property.accept((CPropertyVisitor2)visitor, (Object)classOutline);
            }
        }
        return true;
    }

    private void processValueFromExtendedBase(CValuePropertyInfo valueProperty, ClassOutline classOutline, List<FacetCustomization> customizations) {
        String valuePropertyName = valueProperty.getName(false);
        JFieldVar fieldVar = (JFieldVar)classOutline.implClass.fields().get(valuePropertyName);
        XSSimpleType type = ((RestrictionSimpleTypeImpl)valueProperty.getSchemaComponent()).asSimpleType();
        this.processSimpleType(null, type, fieldVar, customizations);
    }

    private void processAttribute(CAttributePropertyInfo attributeProperty, ClassOutline classOutline, List<FacetCustomization> customizations) {
        String attributePropertyName = attributeProperty.getName(false);
        JFieldVar fieldVar = (JFieldVar)classOutline.implClass.fields().get(attributePropertyName);
        AttributeUseImpl attribute = (AttributeUseImpl)attributeProperty.getSchemaComponent();
        XSSimpleType type = attribute.getDecl().getType();
        if (attribute.isRequired() && !fieldVar.type().isPrimitive()) {
            this.notNullAnnotate(fieldVar);
        }
        this.processSimpleType(null, type, fieldVar, customizations);
    }

    private void processElement(CElementPropertyInfo propertyInfo, ClassOutline co, List<FacetCustomization> customizations) {
        XSParticle particle = (XSParticle)propertyInfo.getSchemaComponent();
        JFieldVar fieldVar = (JFieldVar)co.implClass.fields().get(propertyInfo.getName(false));
        this.processMinMaxOccurs(particle, fieldVar);
        XSTerm term = particle.getTerm();
        if (term instanceof XSElementDecl) {
            this.processTermElement(particle, fieldVar, (XSElementDecl)term, customizations);
        } else if (term instanceof DelayedRef.Element) {
            this.processTermElement(particle, fieldVar, ((DelayedRef.Element)term).get(), customizations);
        }
    }

    private void processTermElement(XSParticle particle, JFieldVar fieldVar, XSElementDecl element, List<FacetCustomization> customizations) {
        int minOccurs = this.getOccursValue("minOccurs", particle);
        XSType elementType = element.getType();
        if (elementType.isComplexType()) {
            this.validAnnotate(fieldVar);
            if (!element.isNillable() && minOccurs > 0) {
                this.notNullAnnotate(fieldVar);
            }
            if (elementType.getBaseType().isSimpleType()) {
                this.processSimpleType(particle, elementType.getBaseType().asSimpleType(), fieldVar, customizations);
            }
        } else {
            this.processSimpleType(particle, elementType.asSimpleType(), fieldVar, customizations);
        }
    }

    private void processSimpleType(XSParticle particle, XSSimpleType simpleType, JFieldVar fieldVar, List<FacetCustomization> customizations) {
        HashMap<JAnnotationUse, FacetType> annotationsAndTheirOrigin = new HashMap<JAnnotationUse, FacetType>();
        this.applyAnnotations(particle, simpleType, fieldVar, annotationsAndTheirOrigin);
        this.applyCustomizations(fieldVar, customizations, annotationsAndTheirOrigin);
    }

    private void applyAnnotations(XSParticle particle, XSSimpleType simpleType, JFieldVar fieldVar, Map<JAnnotationUse, FacetType> a) {
        List patternList;
        Integer digits;
        String minIncValue;
        String maxIncValue;
        JType fieldType;
        XSFacet facet;
        block36: {
            facet = null;
            fieldType = fieldVar.type();
            if (this.notAnnotated(fieldVar, ANNOTATION_SIZE) && this.isSizeAnnotationApplicable(fieldType)) {
                try {
                    facet = simpleType.getFacet("length");
                    if (facet != null) {
                        int length = Integer.parseInt(facet.getValue().value);
                        a.put(fieldVar.annotate(ANNOTATION_SIZE).param("min", length).param("max", length), FacetType.length);
                    } else {
                        Integer maxLength;
                        facet = simpleType.getFacet("minLength");
                        Integer minLength = facet != null ? Integer.valueOf(Integer.parseInt(facet.getValue().value)) : null;
                        facet = simpleType.getFacet("maxLength");
                        Integer n = maxLength = facet != null ? Integer.valueOf(Integer.parseInt(facet.getValue().value)) : null;
                        if (minLength != null && maxLength != null) {
                            a.put(fieldVar.annotate(ANNOTATION_SIZE).param("min", minLength.intValue()).param("max", maxLength.intValue()), FacetType.minLength);
                        } else if (minLength != null) {
                            a.put(fieldVar.annotate(ANNOTATION_SIZE).param("min", minLength.intValue()), FacetType.minLength);
                        } else if (maxLength != null) {
                            a.put(fieldVar.annotate(ANNOTATION_SIZE).param("max", maxLength.intValue()), FacetType.maxLength);
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    if (facet == null) break block36;
                    String msg = "'" + facet.getName() + "' in '" + simpleType.getName() + "' cannot be parsed.";
                    throw new RuntimeException(new SAXParseException(msg, facet.getLocator(), nfe));
                }
            }
        }
        if ((facet = simpleType.getFacet("maxInclusive")) != null && this.isNumberOrCharSequence(fieldType, false) && this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMAX, maxIncValue = facet.getValue().value)) {
            a.put(fieldVar.annotate(ANNOTATION_DECIMALMAX).param(VALUE, maxIncValue), FacetType.maxInclusive);
            this.convertToElement(particle, fieldVar);
        }
        if ((facet = simpleType.getFacet("minInclusive")) != null && this.isNumberOrCharSequence(fieldType, false) && this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMIN, minIncValue = facet.getValue().value)) {
            a.put(fieldVar.annotate(ANNOTATION_DECIMALMIN).param(VALUE, minIncValue), FacetType.minInclusive);
            this.convertToElement(particle, fieldVar);
        }
        if ((facet = simpleType.getFacet("maxExclusive")) != null && this.isNumberOrCharSequence(fieldType, false)) {
            String maxExcValue = facet.getValue().value;
            if (!this.jsr303) {
                if (this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMAX, maxExcValue)) {
                    a.put(fieldVar.annotate(ANNOTATION_DECIMALMAX).param(VALUE, maxExcValue).param("inclusive", false), FacetType.maxExclusive);
                    this.convertToElement(particle, fieldVar);
                }
            } else {
                Integer intMaxExc = Integer.parseInt(maxExcValue) - 1;
                if (this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMAX, maxExcValue = intMaxExc.toString())) {
                    a.put(fieldVar.annotate(ANNOTATION_DECIMALMAX).param(VALUE, maxExcValue), FacetType.maxExclusive);
                    this.convertToElement(particle, fieldVar);
                }
            }
        }
        if ((facet = simpleType.getFacet("minExclusive")) != null && this.isNumberOrCharSequence(fieldType, false)) {
            String minExcValue = facet.getValue().value;
            if (!this.jsr303) {
                if (this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMIN, minExcValue)) {
                    a.put(fieldVar.annotate(ANNOTATION_DECIMALMIN).param(VALUE, minExcValue).param("inclusive", false), FacetType.minExclusive);
                    this.convertToElement(particle, fieldVar);
                } else {
                    Integer intMinExc = Integer.parseInt(minExcValue) + 1;
                    if (this.notAnnotatedAndNotDefaultBoundary(fieldVar, ANNOTATION_DECIMALMIN, minExcValue = intMinExc.toString())) {
                        a.put(fieldVar.annotate(ANNOTATION_DECIMALMIN).param(VALUE, minExcValue), FacetType.minExclusive);
                        this.convertToElement(particle, fieldVar);
                    }
                }
            }
        }
        if ((facet = simpleType.getFacet("totalDigits")) != null && this.isNumberOrCharSequence(fieldType, true) && (digits = Integer.valueOf(facet.getValue().value)) != null) {
            XSFacet fractionDigits = simpleType.getFacet("fractionDigits");
            int fractionDigs = 0;
            if (fractionDigits != null) {
                try {
                    fractionDigs = Integer.parseInt(fractionDigits.getValue().value);
                }
                catch (NumberFormatException nfe) {
                    fractionDigs = 0;
                }
            }
            if (this.notAnnotated(fieldVar, ANNOTATION_DIGITS)) {
                a.put(fieldVar.annotate(ANNOTATION_DIGITS).param("integer", digits - fractionDigs).param("fraction", fractionDigs), FacetType.totalDigits);
            }
        }
        if ((patternList = simpleType.getFacets("pattern")).size() > 1) {
            if (this.notAnnotated(fieldVar, ANNOTATION_PATTERNLIST)) {
                JAnnotationUse list = fieldVar.annotate(ANNOTATION_PATTERNLIST);
                JAnnotationArrayMember listValue = list.paramArray(VALUE);
                for (XSFacet xsFacet : patternList) {
                    if ("String".equals(fieldType.name())) {
                        a.put(listValue.annotate(ANNOTATION_PATTERN).param("regexp", this.eliminateShorthands(xsFacet.getValue().value)), FacetType.pattern);
                        continue;
                    }
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, PATTERN_ANNOTATION_NOT_APPLICABLE);
                }
            }
        } else {
            facet = simpleType.getFacet("pattern");
            if (facet != null) {
                if ("String".equals(fieldType.name())) {
                    if (this.notAnnotated(fieldVar, ANNOTATION_PATTERN)) {
                        a.put(fieldVar.annotate(ANNOTATION_PATTERN).param("regexp", this.eliminateShorthands(facet.getValue().value)), FacetType.pattern);
                    }
                } else {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, PATTERN_ANNOTATION_NOT_APPLICABLE);
                }
            }
        }
    }

    private void applyCustomizations(JFieldVar fieldVar, List<FacetCustomization> customizations, Map<JAnnotationUse, FacetType> a) {
        block8: for (FacetCustomization c : customizations) {
            try {
                switch (FacetType.valueOf(c.type)) {
                    case assertFalse: {
                        this.customizeAnnotation(fieldVar.annotate(ANNOTATION_ASSERTFALSE), c);
                        continue block8;
                    }
                    case assertTrue: {
                        this.customizeAnnotation(fieldVar.annotate(ANNOTATION_ASSERTTRUE), c);
                        continue block8;
                    }
                    case future: {
                        this.customizeAnnotation(fieldVar.annotate(ANNOTATION_FUTURE), c);
                        continue block8;
                    }
                    case past: {
                        this.customizeAnnotation(fieldVar.annotate(ANNOTATION_PAST), c);
                        continue block8;
                    }
                }
            }
            catch (IllegalArgumentException programmingByException) {
                JAnnotationUse annotationUse = fieldVar.annotate(CODEMODEL.ref(c.type));
                if (!c.value.equals("")) {
                    annotationUse.param(VALUE, c.value);
                }
                this.customizeAnnotation(annotationUse, c);
                continue;
            }
            this.customizeRegularAnnotations(a, c);
        }
    }

    private void customizeAnnotation(JAnnotationUse a, final FacetCustomization c) {
        if (c.groups != null && c.groups.length != 0) {
            final class GroupsParser
            extends JExpressionImpl {
                GroupsParser() {
                }

                public void generate(JFormatter f) {
                    if (c.groups.length == 1) {
                        f.p(c.groups[0] + ".class");
                    } else {
                        int i;
                        StringBuilder b = new StringBuilder(c.groups.length * 64);
                        b.append('{');
                        for (i = 0; i < c.groups.length - 1; ++i) {
                            b.append(c.groups[i]).append(".class, ");
                        }
                        b.append(c.groups[i]).append(".class}");
                        f.p(b.toString());
                    }
                }
            }
            a.param("groups", (JExpression)new GroupsParser());
        }
        if (!c.message.equals("")) {
            a.param("message", c.message);
        }
    }

    private void customizeRegularAnnotations(Map<JAnnotationUse, FacetType> annotations, FacetCustomization c) {
        for (Map.Entry<JAnnotationUse, FacetType> e : annotations.entrySet()) {
            if (FacetType.valueOf(c.type) != e.getValue()) continue;
            this.customizeAnnotation(e.getKey(), c);
        }
    }

    private void processMinMaxOccurs(XSParticle particle, JFieldVar fieldVar) {
        int maxOccurs = this.getOccursValue("maxOccurs", particle);
        int minOccurs = this.getOccursValue("minOccurs", particle);
        if (maxOccurs > 1) {
            if (this.notAnnotated(fieldVar, ANNOTATION_SIZE)) {
                fieldVar.annotate(ANNOTATION_SIZE).param("min", minOccurs).param("max", maxOccurs);
            }
        } else if (maxOccurs == -1 && this.notAnnotated(fieldVar, ANNOTATION_SIZE)) {
            fieldVar.annotate(ANNOTATION_SIZE).param("min", minOccurs);
        }
    }

    private void convertToElement(XSParticle particle, JFieldVar fieldVar) {
        if (this.notAnnotated(fieldVar, ANNOTATION_XMLELEMENT)) {
            fieldVar.annotate(XmlElement.class);
            if (particle != null && this.getOccursValue("minOccurs", particle) > 0) {
                this.notNullAnnotate(fieldVar);
            }
        }
    }

    private void validAnnotate(JFieldVar fieldVar) {
        if (this.notAnnotated(fieldVar, ANNOTATION_VALID)) {
            fieldVar.annotate(ANNOTATION_VALID);
        }
    }

    private void notNullAnnotate(JFieldVar fieldVar) {
        if (this.notAnnotated(fieldVar, ANNOTATION_NOTNULL)) {
            fieldVar.annotate(ANNOTATION_NOTNULL);
        }
    }

    private boolean notAnnotated(JFieldVar fieldVar, JClass annotationClass) {
        for (JAnnotationUse annotationUse : fieldVar.annotations()) {
            if (!annotationUse.getAnnotationClass().toString().equals(annotationClass.toString())) continue;
            return false;
        }
        return true;
    }

    private boolean notAnnotatedAndNotDefaultBoundary(JFieldVar fieldVar, JClass annotationClass, String boundaryValue) {
        if (this.isDefaultBoundary(fieldVar.type().name(), annotationClass.fullName(), boundaryValue)) {
            return false;
        }
        for (JAnnotationUse annotationUse : fieldVar.annotations()) {
            if (!annotationUse.getAnnotationClass().toString().equals(annotationClass.toString())) continue;
            boolean previousAnnotationRemoved = false;
            String annotationName = annotationUse.getAnnotationClass().fullName();
            if (annotationName.equals(ANNOTATION_DECIMALMIN.fullName())) {
                previousAnnotationRemoved = this.isMoreSpecificBoundary(fieldVar, boundaryValue, annotationUse, false);
            } else if (annotationName.equals(ANNOTATION_DECIMALMAX.fullName())) {
                previousAnnotationRemoved = this.isMoreSpecificBoundary(fieldVar, boundaryValue, annotationUse, true);
            }
            return previousAnnotationRemoved;
        }
        return true;
    }

    private boolean isMoreSpecificBoundary(JFieldVar fieldVar, String boundaryValue, JAnnotationUse annotationUse, boolean xorComplement) {
        String existingBoundaryValue = this.getExistingBoundaryValue(annotationUse);
        if (existingBoundaryValue == null) {
            return true;
        }
        if (Long.valueOf(boundaryValue).compareTo(Long.valueOf(existingBoundaryValue)) > 0 ^ xorComplement) {
            return fieldVar.removeAnnotation(annotationUse);
        }
        return false;
    }

    private boolean isSizeAnnotationApplicable(JType jType) {
        if (jType.isArray()) {
            return true;
        }
        Class<?> clazz = this.loadClass(jType.fullName());
        return clazz != null && (CharSequence.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz));
    }

    private Class<?> loadClass(String className) {
        Class clazz = null;
        if (this.securityEnabled) {
            try {
                clazz = (Class)AccessController.doPrivileged(ForNameActionExecutor.INSTANCE.with(className));
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else {
            try {
                clazz = BeanValidationPlugin.loadClassInternal(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private int getOccursValue(String attributeName, XSParticle xsParticle) {
        return this.securityEnabled ? ((BigInteger)AccessController.doPrivileged(OccursValueActionExecutor.INSTANCE.with(attributeName, xsParticle))).intValue() : BeanValidationPlugin.loadOccursValue(attributeName, xsParticle).intValue();
    }

    private String getExistingBoundaryValue(JAnnotationUse jAnnotationUse) {
        return this.securityEnabled ? (String)AccessController.doPrivileged(ExistingBoundaryValueActionExecutor.INSTANCE.with(jAnnotationUse)) : BeanValidationPlugin.loadExistingBoundaryValue(jAnnotationUse);
    }

    private String eliminateShorthands(String regex) {
        return this.regexMutator.mutate(regex);
    }

    private boolean isDefaultBoundary(String fieldVarType, String annotationClass, String boundaryValue) {
        return ANNOTATION_DECIMALMIN.fullName().equals(annotationClass) && nonFloatingDigitsClassesBoundaries.get(fieldVarType).min.equals(boundaryValue) || ANNOTATION_DECIMALMAX.fullName().equals(annotationClass) && nonFloatingDigitsClassesBoundaries.get(fieldVarType).max.equals(boundaryValue);
    }

    private boolean isNumberOrCharSequence(JType jType, boolean supportsFloating) {
        String shortClazzName = jType.name();
        if (nonFloatingDigitsClasses.contains(shortClazzName)) {
            return true;
        }
        if (supportsFloating && floatingDigitsClasses.contains(shortClazzName)) {
            return true;
        }
        Class<?> clazz = this.loadClass(jType.fullName());
        return clazz != null && CharSequence.class.isAssignableFrom(clazz);
    }

    private static Class<?> loadClassInternal(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private static BigInteger loadOccursValue(String fieldName, XSParticle xsParticle) {
        try {
            Field field = ParticleImpl.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (BigInteger)field.get(xsParticle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String loadExistingBoundaryValue(JAnnotationUse jAnnotationUse) {
        JAnnotationValue jAnnotationValue = (JAnnotationValue)jAnnotationUse.getAnnotationMembers().get(VALUE);
        Class<?> clazz = jAnnotationValue.getClass();
        try {
            Field theValueField = clazz.getDeclaredField(VALUE);
            theValueField.setAccessible(true);
            return ((JStringLiteral)theValueField.get((Object)jAnnotationValue)).str;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CODEMODEL = new JCodeModel();
        ANNOTATION_VALID = CODEMODEL.ref("jakarta.validation.Valid");
        ANNOTATION_NOTNULL = CODEMODEL.ref("jakarta.validation.constraints.NotNull");
        ANNOTATION_SIZE = CODEMODEL.ref("jakarta.validation.constraints.Size");
        ANNOTATION_DECIMALMIN = CODEMODEL.ref("jakarta.validation.constraints.DecimalMin");
        ANNOTATION_DECIMALMAX = CODEMODEL.ref("jakarta.validation.constraints.DecimalMax");
        ANNOTATION_DIGITS = CODEMODEL.ref("jakarta.validation.constraints.Digits");
        ANNOTATION_PATTERN = CODEMODEL.ref("jakarta.validation.constraints.Pattern");
        ANNOTATION_PATTERNLIST = CODEMODEL.ref("jakarta.validation.constraints.Pattern.List");
        ANNOTATION_ASSERTFALSE = CODEMODEL.ref("jakarta.validation.constraints.AssertFalse");
        ANNOTATION_ASSERTTRUE = CODEMODEL.ref("jakarta.validation.constraints.AssertTrue");
        ANNOTATION_FUTURE = CODEMODEL.ref("jakarta.validation.constraints.Future");
        ANNOTATION_PAST = CODEMODEL.ref("jakarta.validation.constraints.Past");
        ANNOTATION_XMLELEMENT = CODEMODEL.ref("jakarta.xml.bind.annotation.XmlElement");
        HashSet<String> set = new HashSet<String>();
        set.add("byte");
        set.add("Byte");
        set.add("short");
        set.add("Short");
        set.add("int");
        set.add("Integer");
        set.add("long");
        set.add("Long");
        set.add("BigDecimal");
        set.add("BigInteger");
        nonFloatingDigitsClasses = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("float");
        set.add("Float");
        set.add("double");
        set.add("Double");
        floatingDigitsClasses = Collections.unmodifiableSet(new HashSet(set));
        HashMap map = new HashMap();
        map.put("byte", new MinMaxTuple((byte)-128, (byte)127, null));
        map.put("Byte", new MinMaxTuple((byte)-128, (byte)127, null));
        map.put("short", new MinMaxTuple((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, null));
        map.put("Short", new MinMaxTuple((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, null));
        map.put("int", new MinMaxTuple(Integer.MIN_VALUE, Integer.MAX_VALUE, null));
        map.put("Integer", new MinMaxTuple(Integer.MIN_VALUE, Integer.MAX_VALUE, null));
        map.put("long", new MinMaxTuple(Long.MIN_VALUE, Long.MAX_VALUE, null));
        map.put("Long", new MinMaxTuple(Long.MIN_VALUE, Long.MAX_VALUE, null));
        nonFloatingDigitsClassesBoundaries = Collections.unmodifiableMap(map);
    }

    private static final class ExistingBoundaryValueActionExecutor {
        private static final PrivilegedActionWith<String> INSTANCE = new PrivilegedActionWith<String>(){
            private JAnnotationUse jAnnotationUse;

            @Override
            public String run() {
                return BeanValidationPlugin.loadExistingBoundaryValue(this.jAnnotationUse);
            }

            @Override
            public PrivilegedAction<String> with(JAnnotationUse jAnnotationUse) {
                this.jAnnotationUse = jAnnotationUse;
                return this;
            }
        };

        private ExistingBoundaryValueActionExecutor() {
        }

        private static interface PrivilegedActionWith<T>
        extends PrivilegedAction<T> {
            public PrivilegedAction<T> with(JAnnotationUse var1);
        }
    }

    private static final class OccursValueActionExecutor {
        private static final PrivilegedActionWith<BigInteger> INSTANCE = new PrivilegedActionWith<BigInteger>(){
            private String fieldName;
            private XSParticle xsParticle;

            @Override
            public BigInteger run() {
                return BeanValidationPlugin.loadOccursValue(this.fieldName, this.xsParticle);
            }

            @Override
            public PrivilegedActionWith<BigInteger> with(String className, XSParticle xsParticle) {
                this.fieldName = className;
                this.xsParticle = xsParticle;
                return this;
            }
        };

        private OccursValueActionExecutor() {
        }

        private static interface PrivilegedActionWith<T>
        extends PrivilegedAction<T> {
            public PrivilegedAction<T> with(String var1, XSParticle var2);
        }
    }

    private static final class ForNameActionExecutor {
        private static final PrivilegedExceptionActionWith<Class<?>> INSTANCE = new PrivilegedExceptionActionWith<Class<?>>(){
            private String className;

            @Override
            public Class<?> run() throws ClassNotFoundException {
                return BeanValidationPlugin.loadClassInternal(this.className);
            }

            @Override
            public PrivilegedExceptionActionWith<Class<?>> with(String className) {
                this.className = className;
                return this;
            }
        };

        private ForNameActionExecutor() {
        }

        private static interface PrivilegedExceptionActionWith<T>
        extends PrivilegedExceptionAction<T> {
            public PrivilegedExceptionAction<T> with(String var1);
        }
    }

    private static final class MinMaxTuple<T extends Number> {
        private final String min;
        private final String max;

        private MinMaxTuple(T min, T max) {
            this.min = String.valueOf(min);
            this.max = String.valueOf(max);
        }

        /* synthetic */ MinMaxTuple(Number x0, Number x1, 1 x2) {
            this(x0, x1);
        }
    }

    private final class RegexMutator {
        private final Map<Pattern, String> shorthandReplacements;

        private RegexMutator() {
            this.shorthandReplacements = BeanValidationPlugin.this.simpleRegex ? new LinkedHashMap<Pattern, String>(8){
                {
                    this.put(Pattern.compile("\\\\i"), "[_:A-Za-z]");
                    this.put(Pattern.compile("\\\\I"), "[^:A-Z_a-z]");
                    this.put(Pattern.compile("\\\\c"), "[-.0-9:A-Z_a-z]");
                    this.put(Pattern.compile("\\\\C"), "[^-.0-9:A-Z_a-z]");
                }
            } : new LinkedHashMap<Pattern, String>(32){
                {
                    this.put(Pattern.compile("\\\\i"), "[:A-Z_a-z\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u02FF\\\\u0370-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD]");
                    this.put(Pattern.compile("\\\\I"), "[^:A-Z_a-z\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u02FF\\\\u0370-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD]");
                    this.put(Pattern.compile("\\\\c"), "[-.0-9:A-Z_a-z\\\\u00B7\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u203F\\\\u2040\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD]");
                    this.put(Pattern.compile("\\\\C"), "[^-.0-9:A-Z_a-z\\\\u00B7\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u203F\\\\u2040\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD]");
                    this.put(Pattern.compile("\\\\s"), "[\\\\u0009-\\\\u000D\\\\u0020\\\\u0085\\\\u00A0\\\\u1680\\\\u180E\\\\u2000-\\\\u200A\\\\u2028\\\\u2029\\\\u202F\\\\u205F\\\\u3000]");
                    this.put(Pattern.compile("\\\\S"), "[^\\\\u0009-\\\\u000D\\\\u0020\\\\u0085\\\\u00A0\\\\u1680\\\\u180E\\\\u2000-\\\\u200A\\\\u2028\\\\u2029\\\\u202F\\\\u205F\\\\u3000]");
                    this.put(Pattern.compile("\\\\v"), "[\\\\u000A-\\\\u000D\\\\u0085\\\\u2028\\\\u2029]");
                    this.put(Pattern.compile("\\\\V"), "[^\\\\u000A-\\\\u000D\\\\u0085\\\\u2028\\\\u2029]");
                    this.put(Pattern.compile("\\\\h"), "[\\\\u0009\\\\u0020\\\\u00A0\\\\u1680\\\\u180E\\\\u2000-\\\\u200A\\\\u202F\\\\u205F\\\\u3000]");
                    this.put(Pattern.compile("\\\\H"), "[^\\\\u0009\\\\u0020\\\\u00A0\\\\u1680\\\\u180E\\\\u2000\\\\u2001-\\\\u200A\\\\u202F\\\\u205F\\\\u3000]");
                    this.put(Pattern.compile("\\\\w"), "[\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]]");
                    this.put(Pattern.compile("\\\\W"), "[^\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]]");
                    this.put(Pattern.compile("\\\\b"), "(?:(?<=[\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])(?![\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])|(?<![\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])(?=[\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]]))");
                    this.put(Pattern.compile("\\\\B"), "(?:(?<=[\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])(?=[\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])|(?<![\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]])(?![\\\\pL\\\\pM\\\\p{Nd}\\\\p{Nl}\\\\p{Pc}[\\\\p{InEnclosedAlphanumerics}&&\\\\p{So}]]))");
                    this.put(Pattern.compile("\\\\d"), "\\\\p{Nd}");
                    this.put(Pattern.compile("\\\\D"), "\\\\P{Nd}");
                    this.put(Pattern.compile("\\\\R"), "(?:(?>\\\\u000D\\\\u000A)|[\\\\u000A\\\\u000B\\\\u000C\\\\u000D\\\\u0085\\\\u2028\\\\u2029])");
                    this.put(Pattern.compile("\\\\X"), "(?:(?:\\\\u000D\\\\u000A)|(?:[\\\\u0E40\\\\u0E41\\\\u0E42\\\\u0E43\\\\u0E44\\\\u0EC0\\\\u0EC1\\\\u0EC2\\\\u0EC3\\\\u0EC4\\\\uAAB5\\\\uAAB6\\\\uAAB9\\\\uAABB\\\\uAABC]*(?:[\\\\u1100-\\\\u115F\\\\uA960-\\\\uA97C]+|([\\\\u1100-\\\\u115F\\\\uA960-\\\\uA97C]*((?:[[\\\\u1160-\\\\u11A2\\\\uD7B0-\\\\uD7C6][\\\\uAC00\\\\uAC1C\\\\uAC38]][\\\\u1160-\\\\u11A2\\\\uD7B0-\\\\uD7C6]*|[\\\\uAC01\\\\uAC02\\\\uAC03\\\\uAC04])[\\\\u11A8-\\\\u11F9\\\\uD7CB-\\\\uD7FB]*))|[\\\\u11A8-\\\\u11F9\\\\uD7CB-\\\\uD7FB]+|[^[\\\\p{Zl}\\\\p{Zp}\\\\p{Cc}\\\\p{Cf}&&[^\\\\u000D\\\\u000A\\\\u200C\\\\u200D]]\\\\u000D\\\\u000A])[[\\\\p{Mn}\\\\p{Me}\\\\u200C\\\\u200D\\\\u0488\\\\u0489\\\\u20DD\\\\u20DE\\\\u20DF\\\\u20E0\\\\u20E2\\\\u20E3\\\\u20E4\\\\uA670\\\\uA671\\\\uA672\\\\uFF9E\\\\uFF9F][\\\\p{Mc}\\\\u0E30\\\\u0E32\\\\u0E33\\\\u0E45\\\\u0EB0\\\\u0EB2\\\\u0EB3]]*)|(?s:.))");
                }
            };
        }

        private String mutate(String xmlRegex) {
            for (Map.Entry<Pattern, String> entry : this.shorthandReplacements.entrySet()) {
                Matcher m = entry.getKey().matcher(xmlRegex);
                xmlRegex = m.replaceAll(entry.getValue());
            }
            return xmlRegex;
        }
    }

    private static enum FacetType {
        maxExclusive,
        minExclusive,
        maxInclusive,
        minInclusive,
        nillable,
        pattern,
        length,
        maxLength,
        minLength,
        minOccurs,
        maxOccurs,
        totalDigits,
        fractionDigits,
        assertFalse,
        assertTrue,
        future,
        past;

    }

    private static final class FacetCustomization {
        private final String[] groups;
        private final String message;
        private final String type;
        private final String value;

        private FacetCustomization(String groups, String message, String type, String value) {
            this.groups = groups.isEmpty() ? null : this.groups(groups);
            this.message = message;
            this.type = type;
            this.value = value;
        }

        private String[] groups(String groups) {
            return ClassNameTrimmer.trim(groups).split(",");
        }

        private static final class ClassNameTrimmer {
            private static final Pattern ws = Pattern.compile("[\\u0009-\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000-\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+");

            private ClassNameTrimmer() {
            }

            private static String trim(String s) {
                return ws.matcher(s).replaceAll("").replace('$', '.');
            }
        }
    }

    private final class Visitor
    implements CPropertyVisitor2<Void, ClassOutline> {
        private Visitor() {
        }

        public Void visit(CElementPropertyInfo t, ClassOutline p) {
            BeanValidationPlugin.this.processElement(t, p, this.detectCustomizations((CCustomizable)t));
            return null;
        }

        public Void visit(CAttributePropertyInfo t, ClassOutline p) {
            BeanValidationPlugin.this.processAttribute(t, p, this.detectCustomizations((CCustomizable)t));
            return null;
        }

        public Void visit(CValuePropertyInfo t, ClassOutline p) {
            BeanValidationPlugin.this.processValueFromExtendedBase(t, p, this.detectCustomizations((CCustomizable)t));
            return null;
        }

        public Void visit(CReferencePropertyInfo t, ClassOutline p) {
            return null;
        }

        private List<FacetCustomization> detectCustomizations(CCustomizable ca) {
            ArrayList<FacetCustomization> facetCustomizations = new ArrayList<FacetCustomization>();
            CCustomizations pluginCustomizations = ca.getCustomizations();
            if (pluginCustomizations != null) {
                for (CPluginCustomization c : pluginCustomizations) {
                    c.markAsAcknowledged();
                    String groups = c.element.getAttribute("groups");
                    String message = c.element.getAttribute("message");
                    String type = c.element.getAttribute("type");
                    if ("".equals(type)) {
                        throw new RuntimeException("DOM attribute \"type\" is required in custom facet declarations.");
                    }
                    String value = c.element.getAttribute(BeanValidationPlugin.VALUE);
                    facetCustomizations.add(new FacetCustomization(groups, message, type, value));
                }
            }
            return facetCustomizations;
        }
    }
}

