/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class SequencingRollbackTest
extends AutoVerifyTestCase {
    protected boolean shouldUseSeparateConnection;
    protected boolean shouldUseSeparateConnectionOriginal;
    protected int sequencePreallocationSizeOriginal;
    protected boolean failed;

    public SequencingRollbackTest(boolean shouldUseSeparateConnection) {
        String name = "Sequencing rollback test - ";
        this.shouldUseSeparateConnection = shouldUseSeparateConnection;
        if (shouldUseSeparateConnection) {
            this.setName(name + "separate sequencing accessor is allowed");
        } else {
            this.setName(name + "separate sequencing accessor is NOT allowed");
        }
    }

    protected SequencingControl getSequencingControl() {
        return this.getDatabaseSession().getSequencingControl();
    }

    public void setup() {
        this.shouldUseSeparateConnectionOriginal = this.getSequencingControl().shouldUseSeparateConnection();
        if (this.shouldUseSeparateConnectionOriginal != this.shouldUseSeparateConnection) {
            this.getSequencingControl().setShouldUseSeparateConnection(this.shouldUseSeparateConnection);
            this.getSequencingControl().resetSequencing();
        }
        this.getSequencingControl().initializePreallocated();
    }

    public void test() {
        this.beginTransaction();
        int seqNum1 = this.getSession().getNextSequenceNumberValue(Employee.class).intValue();
        this.rollbackTransaction();
        int seqNum2 = this.getSession().getNextSequenceNumberValue(Employee.class).intValue();
        int seqNum3 = this.getSession().getNextSequenceNumberValue(Employee.class).intValue();
        int seqNum4 = this.getSession().getNextSequenceNumberValue(Employee.class).intValue();
        this.failed = seqNum2 == seqNum4;
    }

    public void verify() {
        if (this.failed) {
            throw new TestErrorException("Duplication of sequence number has occurred");
        }
    }

    public void reset() {
        if (this.shouldUseSeparateConnectionOriginal != this.shouldUseSeparateConnection) {
            this.getSequencingControl().setShouldUseSeparateConnection(this.shouldUseSeparateConnectionOriginal);
            this.getSequencingControl().resetSequencing();
        }
        this.getSequencingControl().initializePreallocated();
    }
}

