/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.helper;

import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.testing.tests.junit.helper.JavaUtilTest;
import org.junit.Assert;
import org.junit.Test;

public class JavaSEPlatformTest {
    static final JavaSEPlatform LATEST = JavaUtilTest.initDefault();
    private static final VersionData[] TO_VALUE_DATA = new VersionData[]{new VersionData(1, 1, JavaSEPlatform.v1_1), new VersionData(1, 2, JavaSEPlatform.v1_2), new VersionData(1, 3, JavaSEPlatform.v1_3), new VersionData(1, 4, JavaSEPlatform.v1_4), new VersionData(1, 5, JavaSEPlatform.v1_5), new VersionData(1, 6, JavaSEPlatform.v1_6), new VersionData(1, 7, JavaSEPlatform.v1_7), new VersionData(1, 8, JavaSEPlatform.v1_8), new VersionData(1, 9, JavaSEPlatform.v9_0), new VersionData(1, 10, LATEST), new VersionData(9, 0, JavaSEPlatform.v9_0), new VersionData(10, 0, JavaSEPlatform.v10_0), new VersionData(11, 0, JavaSEPlatform.v11_0), new VersionData(12, 0, JavaSEPlatform.v12_0), new VersionData(13, 0, JavaSEPlatform.v13_0), new VersionData(14, 0, LATEST)};

    @Test
    public void testToValue() {
        for (VersionData data : TO_VALUE_DATA) {
            JavaSEPlatform out = JavaSEPlatform.toValue((int)data.major, (int)data.minor);
            Assert.assertEquals((String)("Expected " + data.platform.toString() + " for version number " + Integer.toString(data.major) + "." + Integer.toString(data.minor)), (Object)data.platform, (Object)out);
        }
    }

    private static final class VersionData {
        private final int major;
        private final int minor;
        private final JavaSEPlatform platform;

        private VersionData(int major, int minor, JavaSEPlatform platform) {
            this.major = major;
            this.minor = minor;
            this.platform = platform;
        }
    }
}

