/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReportQueryFunctionTypeTestCase
extends AutoVerifyTestCase {
    Vector<ReportQueryResult> results;
    boolean shouldHaveReadAllQueryInDescriptor;
    boolean hasSetReadAllQueryIntoDescriptor;

    public ReportQueryFunctionTypeTestCase() {
        this(false);
    }

    public ReportQueryFunctionTypeTestCase(boolean shouldHaveReadAllQueryInDescriptor) {
        this.shouldHaveReadAllQueryInDescriptor = shouldHaveReadAllQueryInDescriptor;
        String suffix = shouldHaveReadAllQueryInDescriptor ? " ReadAllQuery in descriptor." : "";
        this.setDescription("Tests the result types of report query that uses functions." + suffix);
        this.setName(this.getName() + suffix);
    }

    public void test() {
        ClassDescriptor desc;
        if (this.getSession().getLogin().getDriverClassName().equals("com.oracle.ias.jdbc.db2.DB2Driver")) {
            throw new TestWarningException("This test is not supported on DB2 DataDirect");
        }
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        reportQuery.addAverage("salary-ave", builder.get("salary"));
        if (this.getSession().getDatasourcePlatform().isOracle()) {
            reportQuery.addVariance("salary-var", builder.get("salary"));
        }
        if (!(this.getSession().getDatasourcePlatform().isSybase() || this.getSession().getDatasourcePlatform().isTimesTen() || this.getSession().getDatasourcePlatform().isDerby() || this.getSession().getDatasourcePlatform().isSymfoware())) {
            reportQuery.addStandardDeviation("salary-std", builder.get("salary"));
        }
        reportQuery.addSum("id-sum", builder.get("id"));
        reportQuery.addMinimum("id-min", builder.get("id"));
        reportQuery.addMaximum("id-max", builder.get("id"));
        if (this.shouldHaveReadAllQueryInDescriptor && !(desc = this.getSession().getDescriptor(Employee.class)).getQueryManager().hasReadAllQuery()) {
            desc.getQueryManager().setReadAllQuery(new ReadAllQuery());
            this.hasSetReadAllQueryIntoDescriptor = true;
        }
        this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)reportQuery);
    }

    protected void verify() {
        Object value;
        if (this.results.isEmpty()) {
            throw new TestErrorException("No results were returned from the report query.");
        }
        ReportQueryResult result = this.results.firstElement();
        if (this.getSession().getDatasourcePlatform().isDerby()) {
            return;
        }
        if (this.getSession().getDatasourcePlatform().isOracle()) {
            value = result.get("salary-ave");
            if (value instanceof Integer) {
                throw new TestErrorException("Incorrect result type for average function of report query.");
            }
            value = result.get("salary-var");
            if (value instanceof Integer) {
                throw new TestErrorException("Incorrect result type for variance function of report query.");
            }
            value = result.get("id-sum");
            if (!(value instanceof BigDecimal)) {
                throw new TestErrorException("Incorrect result type for sum function of report query.");
            }
            value = result.get("id-min");
            if (!(value instanceof BigDecimal)) {
                throw new TestErrorException("Incorrect result type for min function of report query.");
            }
            value = result.get("id-max");
            if (!(value instanceof BigDecimal)) {
                throw new TestErrorException("Incorrect result type for max function of report query.");
            }
        }
        if ((value = result.get("salary-std")) instanceof Integer) {
            throw new TestErrorException("Incorrect result type for standard deviation function of report query.");
        }
    }

    public void reset() {
        if (this.hasSetReadAllQueryIntoDescriptor) {
            ClassDescriptor desc = this.getSession().getDescriptor(Employee.class);
            desc.getQueryManager().setReadAllQuery(null);
        }
    }
}

