/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.concurrency;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcurrencyA;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcurrencyB;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcurrencyC;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.Equipment;
import org.eclipse.persistence.testing.tests.jpa.advanced.concurrency.Runner1;
import org.eclipse.persistence.testing.tests.jpa.advanced.concurrency.Runner2;
import org.eclipse.persistence.testing.tests.jpa.advanced.concurrency.TransitionRunner1;

public class ConcurrencyTest
extends JUnitTestCase {
    public ConcurrencyTest() {
    }

    public ConcurrencyTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConcurrencyTestSuite");
        suite.addTest((Test)new ConcurrencyTest("testDeadLockOnReadLock"));
        suite.addTest((Test)new ConcurrencyTest("testTransitionToDeferedFailure"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeadLockOnReadLock() {
        if (ConcurrencyTest.isOnServer()) {
            return;
        }
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        Department dept = new Department();
        em.persist((Object)dept);
        Equipment equip = new Equipment();
        em.persist((Object)equip);
        em.getTransaction().commit();
        em.close();
        try {
            Integer i = new Integer(5);
            Thread thread1 = new Thread(new Runner1(i, dept.getId(), equip.getId(), emf));
            thread1.setName("Runner1");
            Thread thread2 = new Thread(new Runner2(i, dept.getId(), equip.getId(), emf));
            thread2.setName("Runner2");
            thread2.start();
            thread1.start();
            try {
                Thread.currentThread();
                Thread.sleep(8000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Integer e = i;
            synchronized (e) {
                i.notifyAll();
            }
            try {
                thread2.join(30000L);
                thread1.join(30000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            if (thread2.isAlive() || thread1.isAlive()) {
                thread2.interrupt();
                thread1.interrupt();
                ConcurrencyTest.fail((String)"Dead-lock occurred");
            }
        }
        finally {
            em = emf.createEntityManager();
            em.getTransaction().begin();
            em.remove(em.find(Department.class, (Object)dept.getId()));
            em.remove(em.find(Equipment.class, (Object)equip.getId()));
            em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransitionToDeferedFailure() {
        if (ConcurrencyTest.isOnServer()) {
            return;
        }
        Integer toWaitOn = new Integer(4);
        Thread thread1 = null;
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        ConcurrencyA a = new ConcurrencyA();
        ConcurrencyA a2 = new ConcurrencyA();
        ConcurrencyB b = new ConcurrencyB();
        ConcurrencyC c = new ConcurrencyC();
        em.persist((Object)a);
        em.persist((Object)a2);
        em.persist((Object)c);
        em.persist((Object)b);
        em.getTransaction().commit();
        em.close();
        try {
            Integer n;
            thread1 = new Thread(new TransitionRunner1(toWaitOn, b, c, emf));
            thread1.start();
            em = emf.createEntityManager();
            a = (ConcurrencyA)em.find(ConcurrencyA.class, (Object)a.getId());
            a2 = (ConcurrencyA)em.find(ConcurrencyA.class, (Object)a2.getId());
            b = (ConcurrencyB)em.find(ConcurrencyB.class, (Object)b.getId());
            c = (ConcurrencyC)em.find(ConcurrencyC.class, (Object)c.getId());
            a2.setName(System.currentTimeMillis() + "_A");
            a.setConcurrencyB(b);
            a.setConcurrencyC(c);
            RepeatableWriteUnitOfWork uow = ((EntityManagerImpl)em).getActivePersistenceContext(null);
            try {
                Thread.currentThread();
                Thread.sleep(20000L);
                n = toWaitOn;
                synchronized (n) {
                    toWaitOn.notifyAll();
                    toWaitOn.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            uow.issueSQLbeforeCompletion(true);
            uow.mergeClonesAfterCompletion();
            n = toWaitOn;
            synchronized (n) {
                toWaitOn.notifyAll();
            }
            try {
                thread1.join(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (thread1.isAlive()) {
                thread1.interrupt();
            }
            em = emf.createEntityManager();
            em.getTransaction().begin();
            em.remove(em.find(ConcurrencyA.class, (Object)a.getId()));
            em.remove(em.find(ConcurrencyA.class, (Object)a2.getId()));
            em.remove(em.find(ConcurrencyC.class, (Object)c.getId()));
            em.remove(em.find(ConcurrencyB.class, (Object)b.getId()));
            em.getTransaction().commit();
        }
    }
}

