/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestSuite;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.helper.SerializationHelper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups.BaseFetchGroupTests;
import org.junit.Test;

public class SimpleSerializeFetchGroupTests
extends BaseFetchGroupTests {
    public SimpleSerializeFetchGroupTests() {
    }

    public SimpleSerializeFetchGroupTests(String name) {
        super(name);
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SimpleSerializeFetchGroupTests");
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("testSetup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("verifyWriteReplaceOnFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("verifyAddAttributeInDetachedEntityFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("singleResultEmptyFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("resultListEmptyFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("resultListPeriodFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("managerFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("managerFetchGroupWithJoinFetch"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("employeeNamesFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("joinFetchEmployeeAddressWithDynamicFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("joinFetchEmployeeAddressPhoneWithDynamicFetchGroup"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("verifyFetchedRelationshipAttributes"));
        suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("attrAndVHContainSameObjectAfterGetRealAttributeValue"));
        if (!SimpleSerializeFetchGroupTests.isJPA10()) {
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("findMinimalFetchGroup"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("findEmptyFetchGroup_setUnfetchedSalary"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("verifyUnfetchedAttributes"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("simpleSerializeAndMerge"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("partialMerge"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyGroupMerge"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyGroupMerge2"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyWithPk"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyWithPkUseFullGroup"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyWithoutPk"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyWithoutPkUseFullGroup"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyNoCascade"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyCascadePrivateParts"));
            suite.addTest((junit.framework.Test)new SimpleSerializeFetchGroupTests("copyCascadeAllParts"));
        }
        return suite;
    }

    @Test
    public void verifyWriteReplaceOnFetchGroup() throws Exception {
        EntityFetchGroup fg = new EntityFetchGroup(new String[]{"basic", "a"});
        FetchGroup serFG = (FetchGroup)this.serialize((Serializable)fg);
        SimpleSerializeFetchGroupTests.assertNotNull((Object)serFG);
        SimpleSerializeFetchGroupTests.assertTrue((serFG.getClass() == EntityFetchGroup.class ? 1 : 0) != 0);
        SimpleSerializeFetchGroupTests.assertTrue((boolean)serFG.hasItems());
        AttributeItem basicFI = serFG.getItem("basic");
        SimpleSerializeFetchGroupTests.assertNotNull((Object)basicFI);
        AttributeItem aFI = serFG.getItem("a");
        SimpleSerializeFetchGroupTests.assertNotNull((Object)aFI);
        SimpleSerializeFetchGroupTests.assertNull((Object)aFI.getGroup());
    }

    @Test
    public void findMinimalFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        int minId = SimpleSerializeFetchGroupTests.minimumEmployeeId(em);
        SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        HashMap<String, FetchGroup> properties = new HashMap<String, FetchGroup>();
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("id");
        fg.addAttribute("version");
        properties.put("eclipselink.fetch-group", fg);
        Employee emp = (Employee)em.find(Employee.class, (Object)minId, properties);
        SimpleSerializeFetchGroupTests.assertNotNull((Object)emp);
        SimpleSerializeFetchGroupTests.assertFetched((Object)emp, fg);
        SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "id");
        SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "version");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "period");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "address");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
        SimpleSerializeFetchGroupTests.assertTrue((this.getFetchGroup(emp).getClass() == EntityFetchGroup.class ? 1 : 0) != 0);
        Employee serEmp = (Employee)this.serialize((Serializable)emp);
        SimpleSerializeFetchGroupTests.assertNotNull((Object)serEmp);
        SimpleSerializeFetchGroupTests.assertFetchedAttribute(serEmp, "id");
        SimpleSerializeFetchGroupTests.assertFetchedAttribute(serEmp, "version");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "firstName");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "lastName");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "gender");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "salary");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "startTime");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "endTime");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "period");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "address");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "manager");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "phoneNumbers");
        SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(serEmp, "projects");
        SimpleSerializeFetchGroupTests.assertTrue((boolean)(this.getFetchGroup(serEmp) instanceof EntityFetchGroup));
        serEmp.setFirstName("Doug");
        SimpleSerializeFetchGroupTests.assertFetchedAttribute(serEmp, "firstName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findEmptyFetchGroup_setUnfetchedSalary() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        int minId = SimpleSerializeFetchGroupTests.minimumEmployeeId(em);
        try {
            this.beginTransaction(em);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            HashMap<String, FetchGroup> properties = new HashMap<String, FetchGroup>();
            FetchGroup emptyFG = new FetchGroup();
            properties.put("eclipselink.fetch-group", emptyFG);
            Employee emp = (Employee)em.find(Employee.class, (Object)minId, properties);
            SimpleSerializeFetchGroupTests.assertNotNull((Object)emp);
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            emp.setSalary(1);
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            emp.getAddress();
            SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            emp.getPhoneNumbers().size();
            SimpleSerializeFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void verifyAddAttributeInDetachedEntityFetchGroup() {
        EntityFetchGroup detFG = new EntityFetchGroup(new String[]{"basic", "a"});
        SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)detFG.getItems().size());
        AttributeItem basicItem = detFG.getItem("basic");
        SimpleSerializeFetchGroupTests.assertNotNull((Object)basicItem);
        SimpleSerializeFetchGroupTests.assertEquals((String)"basic", (String)basicItem.getAttributeName());
        SimpleSerializeFetchGroupTests.assertNull((Object)basicItem.getGroup());
        SimpleSerializeFetchGroupTests.assertSame((Object)detFG, (Object)basicItem.getParent());
        AttributeItem aItem = detFG.getItem("a");
        SimpleSerializeFetchGroupTests.assertNotNull((Object)aItem);
        SimpleSerializeFetchGroupTests.assertEquals((String)"a", (String)aItem.getAttributeName());
        SimpleSerializeFetchGroupTests.assertNull((Object)aItem.getGroup());
        SimpleSerializeFetchGroupTests.assertSame((Object)detFG, (Object)aItem.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void singleResultEmptyFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleSerializeFetchGroupTests.minimumEmployeeId(em));
            FetchGroup emptyFG = new FetchGroup();
            query.setHint("eclipselink.fetch-group", (Object)emptyFG);
            Employee emp = (Employee)query.getSingleResult();
            SimpleSerializeFetchGroupTests.assertNotNull((Object)emp);
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            emp.getSalary();
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            emp.getAddress();
            SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            emp.getPhoneNumbers().size();
            SimpleSerializeFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resultListEmptyFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleSerializeFetchGroupTests.minimumEmployeeId(em));
            FetchGroup emptyFG = new FetchGroup();
            query.setHint("eclipselink.fetch-group", (Object)emptyFG);
            List emps = query.getResultList();
            SimpleSerializeFetchGroupTests.assertNotNull((Object)emps);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, emptyFG);
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getPeriod() != null) {
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getSalary();
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resultListPeriodFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleSerializeFetchGroupTests.minimumEmployeeId(em));
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("period");
            query.setHint("eclipselink.fetch-group", (Object)fg);
            List emps = query.getResultList();
            SimpleSerializeFetchGroupTests.assertNotNull((Object)emps);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, fg);
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "id");
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "version");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "lastName");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "gender");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "startTime");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "endTime");
            if (emp.getPeriod() != null) {
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "startDate");
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp.getPeriod(), "endDate");
            }
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "address");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "manager");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "phoneNumbers");
            SimpleSerializeFetchGroupTests.assertNotFetchedAttribute(emp, "projects");
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getSalary();
            SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void managerFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            SimpleSerializeFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleSerializeFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, managerFG);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            int nSqlToAdd = 0;
            if (emp.getManager() != null) {
                SimpleSerializeFetchGroupTests.assertFetchedAttribute(emp, "manager");
                ++nSqlToAdd;
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)(1 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getLastName();
            SimpleSerializeFetchGroupTests.assertEquals((int)(2 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)(3 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void managerFetchGroupWithJoinFetch() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            SimpleSerializeFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleSerializeFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, managerFG);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getManager();
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getLastName();
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void employeeNamesFetchGroup() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            int minId = SimpleSerializeFetchGroupTests.minimumEmployeeId(em);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)minId);
            FetchGroup namesFG = new FetchGroup();
            namesFG.addAttribute("firstName");
            namesFG.addAttribute("lastName");
            query.setHint("eclipselink.fetch-group", (Object)namesFG);
            SimpleSerializeFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleSerializeFetchGroupTests.assertSame((Object)namesFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getId();
            emp.getFirstName();
            emp.getLastName();
            emp.getVersion();
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getGender();
            emp.getSalary();
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(phone);
                phone.getAreaCode();
            }
            SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleSerializeFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(emp.getManager());
            } else {
                SimpleSerializeFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Override
    @Test
    public void joinFetchEmployeeAddressWithDynamicFetchGroup() {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleSerializeFetchGroupTests.assertNotNull((Object)emps);
    }

    @Override
    @Test
    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup() {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT p.owner.id FROM PhoneNumber p)");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleSerializeFetchGroupTests.assertNotNull((Object)emps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyUnfetchedAttributes() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            TypedQuery q = em.createQuery("SELECT e FROM Employee e WHERE e.id IN (SELECT MIN(p.owner.id) FROM PhoneNumber p)", Employee.class);
            FetchGroup fg = new FetchGroup("Employee.empty");
            q.setHint("eclipselink.fetch-group", (Object)fg);
            Employee emp = (Employee)q.getSingleResult();
            SimpleSerializeFetchGroupTests.assertNotNull((Object)emp);
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            IndirectList phonesIL = (IndirectList)emp.getPhoneNumbers();
            SimpleSerializeFetchGroupTests.assertFalse((boolean)phonesIL.isInstantiated());
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleSerializeFetchGroupTests.assertTrue((emp.getPhoneNumbers().size() > 0 ? 1 : 0) != 0);
            SimpleSerializeFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void verifyFetchedRelationshipAttributes() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        FetchGroup fg = new FetchGroup("Employee.relationships");
        fg.addAttribute("address");
        fg.addAttribute("phoneNumbers");
        fg.addAttribute("manager");
        fg.addAttribute("projects");
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("eclipselink.fetch-group", fg);
        Employee emp = SimpleSerializeFetchGroupTests.minimumEmployee(em, hints);
        SimpleSerializeFetchGroupTests.assertNotNull((Object)emp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleSerializeAndMerge() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        int id = SimpleSerializeFetchGroupTests.minEmployeeIdWithAddressAndPhones(em);
        HashMap<String, PhoneNumber> phonesOriginal = new HashMap<String, PhoneNumber>();
        Employee empOriginal = (Employee)em.find(Employee.class, (Object)id);
        for (PhoneNumber phone : empOriginal.getPhoneNumbers()) {
            phonesOriginal.put(phone.getType(), phone);
        }
        this.closeEntityManager(em);
        SimpleSerializeFetchGroupTests.clearCache((String)"fieldaccess");
        int newSalary = empOriginal.getSalary() * 2;
        if (newSalary == 0) {
            newSalary = 100;
        }
        em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = " + id);
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        fetchGroup.addAttribute("address.country");
        fetchGroup.addAttribute("phoneNumbers.areaCode");
        fetchGroup.addAttribute("phoneNumbers.owner.id");
        fetchGroup.setShouldLoad(true);
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        Employee emp = (Employee)query.getSingleResult();
        try {
            Employee empSerialized = (Employee)this.serialize((Serializable)emp);
            SimpleSerializeFetchGroupTests.assertFetched((Object)empSerialized, fetchGroup);
            empSerialized.setFirstName("newFirstName");
            empSerialized.setLastName("newLastName");
            empSerialized.setSalary(newSalary);
            FetchGroup extendedFetchGroup = fetchGroup.clone();
            extendedFetchGroup.addAttribute("salary");
            SimpleSerializeFetchGroupTests.assertFetched((Object)empSerialized, extendedFetchGroup);
            empSerialized.getAddress().setCountry("newCountry");
            SimpleSerializeFetchGroupTests.assertFetched((Object)empSerialized.getAddress(), fetchGroup.getGroup("address"));
            empSerialized.getAddress().setCity("newCity");
            extendedFetchGroup.addAttribute("address.city");
            SimpleSerializeFetchGroupTests.assertFetched((Object)empSerialized.getAddress(), extendedFetchGroup.getGroup("address"));
            extendedFetchGroup.addAttribute("phoneNumbers.number");
            for (Object phone : empSerialized.getPhoneNumbers()) {
                phone.setAreaCode("000");
                SimpleSerializeFetchGroupTests.assertFetched(phone, fetchGroup.getGroup("phoneNumbers"));
                phone.setNumber("0000000");
                SimpleSerializeFetchGroupTests.assertFetched(phone, extendedFetchGroup.getGroup("phoneNumbers"));
            }
            Employee empDeserialized = (Employee)this.serialize((Serializable)empSerialized);
            SimpleSerializeFetchGroupTests.assertFetched((Object)empDeserialized, extendedFetchGroup);
            SimpleSerializeFetchGroupTests.assertFetched((Object)empDeserialized.getAddress(), extendedFetchGroup.getGroup("address"));
            for (Object phone : empDeserialized.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertFetched(phone, extendedFetchGroup.getGroup("phoneNumbers"));
            }
            Employee empMerged = (Employee)em.merge((Object)empDeserialized);
            SimpleSerializeFetchGroupTests.assertEquals((String)"newFirstName", (String)empMerged.getFirstName());
            SimpleSerializeFetchGroupTests.assertEquals((String)"newLastName", (String)empMerged.getLastName());
            SimpleSerializeFetchGroupTests.assertEquals((int)newSalary, (int)empMerged.getSalary());
            SimpleSerializeFetchGroupTests.assertEquals((String)"newCountry", (String)empMerged.getAddress().getCountry());
            SimpleSerializeFetchGroupTests.assertEquals((String)"newCity", (String)empMerged.getAddress().getCity());
            for (Object phone : empMerged.getPhoneNumbers()) {
                SimpleSerializeFetchGroupTests.assertEquals((String)"000", (String)phone.getAreaCode());
                SimpleSerializeFetchGroupTests.assertEquals((String)"0000000", (String)phone.getNumber());
            }
            SimpleSerializeFetchGroupTests.assertEquals((Object)empOriginal.getGender(), (Object)empMerged.getGender());
            if (empOriginal.getDepartment() != null) {
                SimpleSerializeFetchGroupTests.assertEquals((Object)empOriginal.getDepartment().getId(), (Object)empMerged.getDepartment().getId());
            }
            if (empOriginal.getPeriod() != null) {
                SimpleSerializeFetchGroupTests.assertEquals((Object)empOriginal.getPeriod().getStartDate(), (Object)empMerged.getPeriod().getStartDate());
                SimpleSerializeFetchGroupTests.assertEquals((Object)empOriginal.getPeriod().getEndDate(), (Object)empMerged.getPeriod().getEndDate());
            }
            SimpleSerializeFetchGroupTests.assertEquals((Object)empOriginal.getPayScale(), (Object)empMerged.getPayScale());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        em.clear();
        HashMap<String, String> hints = new HashMap<String, String>(2);
        hints.put("eclipselink.cache-usage", "CheckCacheOnly");
        Employee empShared = (Employee)em.find(Employee.class, (Object)id, hints);
        SimpleSerializeFetchGroupTests.assertEquals((String)"newFirstName", (String)empShared.getFirstName());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newLastName", (String)empShared.getLastName());
        SimpleSerializeFetchGroupTests.assertEquals((int)newSalary, (int)empShared.getSalary());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newCountry", (String)empShared.getAddress().getCountry());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newCity", (String)empShared.getAddress().getCity());
        for (PhoneNumber phone : empShared.getPhoneNumbers()) {
            SimpleSerializeFetchGroupTests.assertEquals((String)"000", (String)phone.getAreaCode());
            SimpleSerializeFetchGroupTests.assertEquals((String)"0000000", (String)phone.getNumber());
        }
        SimpleSerializeFetchGroupTests.clearCache((String)"fieldaccess");
        em.clear();
        Employee empDb = (Employee)em.find(Employee.class, (Object)id);
        SimpleSerializeFetchGroupTests.assertEquals((String)"newFirstName", (String)empDb.getFirstName());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newLastName", (String)empDb.getLastName());
        SimpleSerializeFetchGroupTests.assertEquals((int)newSalary, (int)empDb.getSalary());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newCountry", (String)empDb.getAddress().getCountry());
        SimpleSerializeFetchGroupTests.assertEquals((String)"newCity", (String)empDb.getAddress().getCity());
        for (PhoneNumber phone : empDb.getPhoneNumbers()) {
            SimpleSerializeFetchGroupTests.assertEquals((String)"000", (String)phone.getAreaCode());
            SimpleSerializeFetchGroupTests.assertEquals((String)"0000000", (String)phone.getNumber());
        }
        this.beginTransaction(em);
        try {
            empDb.setFirstName(empOriginal.getFirstName());
            empDb.setLastName(empOriginal.getLastName());
            empDb.setSalary(empOriginal.getSalary());
            empDb.getAddress().setCountry(empOriginal.getAddress().getCountry());
            empDb.getAddress().setCity(empOriginal.getAddress().getCity());
            for (PhoneNumber phone : empDb.getPhoneNumbers()) {
                PhoneNumber phoneOriginal = (PhoneNumber)phonesOriginal.get(phone.getType());
                phone.setAreaCode(phoneOriginal.getAreaCode());
                phone.setNumber(phoneOriginal.getNumber());
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialMerge() throws Exception {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            TypedQuery query = em.createQuery("SELECT e FROM Employee e WHERE e.address IS NOT NULL AND e.id IN (SELECT MIN(p.owner.id) FROM PhoneNumber p)", Employee.class);
            FetchGroup fetchGroup = new FetchGroup();
            fetchGroup.addAttribute("firstName");
            fetchGroup.addAttribute("lastName");
            FetchGroup phonesFG = this.phoneDescriptor.getFetchGroupManager().createFullFetchGroup();
            phonesFG.addAttribute("owner.id");
            phonesFG.removeAttribute("status");
            phonesFG.setShouldLoad(true);
            fetchGroup.addAttribute("phoneNumbers", (AttributeGroup)phonesFG);
            fetchGroup.setShouldLoad(true);
            query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
            Employee emp = (Employee)query.getSingleResult();
            Employee detachedEmp = (Employee)this.serialize((Serializable)emp);
            detachedEmp.setFirstName(emp.getLastName());
            detachedEmp.setLastName(emp.getFirstName());
            detachedEmp.addPhoneNumber(new PhoneNumber("TEST", "999", "999999"));
            detachedEmp.setSalary(1);
            em.merge((Object)detachedEmp);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyGroupMerge() {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            TypedQuery query = em.createQuery("SELECT e FROM Employee e WHERE e.id IN (SELECT MIN(ee.id) FROM Employee ee)", Employee.class);
            Employee emp = (Employee)query.getSingleResult();
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            System.out.println(">>> Employee retrieved");
            CopyGroup group = new CopyGroup();
            group.addAttribute("firstName");
            group.addAttribute("lastName");
            group.addAttribute("address");
            Employee empCopy = (Employee)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)emp, (AttributeGroup)group);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            System.out.println(">>> Employee copied");
            empCopy.setFirstName(emp.getLastName());
            empCopy.setLastName(emp.getFirstName());
            em.merge((Object)empCopy);
            System.out.println(">>> Sparse merge complete");
            em.flush();
            System.out.println(">>> Flush complete");
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyGroupMerge2() {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            TypedQuery query = em.createQuery("SELECT e FROM Employee e", Employee.class);
            query.setHint("eclipselink.batch", (Object)"e.address");
            List employees = query.getResultList();
            SimpleSerializeFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            System.out.println(">>> Employees retrieved");
            CopyGroup group = new CopyGroup();
            group.addAttribute("firstName");
            group.addAttribute("lastName");
            group.addAttribute("address");
            List employeesCopy = (List)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)employees, (AttributeGroup)group);
            SimpleSerializeFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            System.out.println(">>> Employees copied");
            for (Employee empCopy : employeesCopy) {
                String firstName = empCopy.getFirstName();
                String lastName = empCopy.getLastName();
                empCopy.setFirstName(lastName);
                empCopy.setLastName(firstName);
                em.merge((Object)empCopy);
            }
            System.out.println(">>> Sparse merge complete");
            em.flush();
            System.out.println(">>> Flush complete");
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    @Test
    public void copyWithPk() {
        this.copyWithOrWithoutPk(false, false);
    }

    @Test
    public void copyWithPkUseFullGroup() {
        this.copyWithOrWithoutPk(false, true);
    }

    @Test
    public void copyWithoutPk() {
        this.copyWithOrWithoutPk(true, false);
    }

    @Test
    public void copyWithoutPkUseFullGroup() {
        this.copyWithOrWithoutPk(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyWithOrWithoutPk(boolean noPk, boolean useFullGroup) {
        CopyGroup group = new CopyGroup();
        if (noPk) {
            group.setShouldResetPrimaryKey(true);
            group.setShouldResetVersion(true);
        }
        group.cascadeTree();
        group.addAttribute("firstName");
        group.addAttribute("lastName");
        group.addAttribute("gender");
        group.addAttribute("period");
        group.addAttribute("salary");
        if (useFullGroup) {
            CopyGroup address = this.addressDescriptor.getFetchGroupManager().createFullFetchGroup().toCopyGroup();
            address.removeAttribute("employees");
            if (noPk) {
                address.removeAttribute("id");
                address.setShouldResetPrimaryKey(true);
                address.setShouldResetVersion(true);
            }
            group.addAttribute("address", address);
            CopyGroup phones = this.phoneDescriptor.getFetchGroupManager().createFullFetchGroup().toCopyGroup();
            if (noPk) {
                phones.setShouldResetPrimaryKey(true);
            }
            if (!noPk) {
                phones.addAttribute("owner.id");
            }
            group.addAttribute("phoneNumbers", phones);
        } else {
            group.addAttribute("address.country");
            group.addAttribute("address.province");
            group.addAttribute("address.street");
            group.addAttribute("address.postalCode");
            group.addAttribute("address.city");
            if (noPk) {
                group.addAttribute("phoneNumbers.owner");
            } else {
                group.addAttribute("phoneNumbers.owner.id");
            }
            group.addAttribute("phoneNumbers.type");
            group.addAttribute("phoneNumbers.areaCode");
            group.addAttribute("phoneNumbers.number");
        }
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            int nExpectedUpdates;
            int nExpectedInserts;
            this.beginTransaction(em);
            Employee emp = SimpleSerializeFetchGroupTests.minimumEmployee(em);
            Employee empCopy = (Employee)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)emp, (AttributeGroup)group);
            if (noPk) {
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(empCopy);
                SimpleSerializeFetchGroupTests.assertNoFetchGroup(empCopy.getAddress());
                for (PhoneNumber phoneCopy : empCopy.getPhoneNumbers()) {
                    SimpleSerializeFetchGroupTests.assertNoFetchGroup(phoneCopy);
                }
                em.persist((Object)empCopy);
            } else {
                FetchGroup fetchGroup = group.toFetchGroup();
                this.employeeDescriptor.getFetchGroupManager().prepareAndVerify(fetchGroup);
                SimpleSerializeFetchGroupTests.assertFetched((Object)empCopy, fetchGroup);
                EntityFetchGroup addressEntityFetchGroup = this.addressDescriptor.getFetchGroupManager().getEntityFetchGroup(fetchGroup.getGroup("address"));
                if (addressEntityFetchGroup == null) {
                    SimpleSerializeFetchGroupTests.assertNoFetchGroup(empCopy.getAddress());
                } else {
                    SimpleSerializeFetchGroupTests.assertFetched((Object)empCopy.getAddress(), (FetchGroup)addressEntityFetchGroup);
                }
                EntityFetchGroup phonesEntityFetchGroup = this.phoneDescriptor.getFetchGroupManager().getEntityFetchGroup(fetchGroup.getGroup("phoneNumbers"));
                for (PhoneNumber phoneCopy : empCopy.getPhoneNumbers()) {
                    if (phonesEntityFetchGroup == null) {
                        SimpleSerializeFetchGroupTests.assertNoFetchGroup(phoneCopy);
                        continue;
                    }
                    SimpleSerializeFetchGroupTests.assertFetched((Object)phoneCopy, (FetchGroup)phonesEntityFetchGroup);
                }
                empCopy.setFirstName((empCopy.getFirstName() != null ? empCopy.getFirstName() : "") + "_NEW");
                empCopy.setSalary(empCopy.getSalary() * 2 + 1);
                empCopy.getAddress().setCountry((empCopy.getAddress().getCountry() != null ? empCopy.getAddress().getCountry() : "") + "_NEW");
                for (PhoneNumber phoneCopy : empCopy.getPhoneNumbers()) {
                    if (phoneCopy.getAreaCode() != null && phoneCopy.getAreaCode().equals("000")) {
                        phoneCopy.setAreaCode("111");
                        continue;
                    }
                    phoneCopy.setAreaCode("000");
                }
                em.merge((Object)empCopy);
            }
            int nExpectedInsertsOrUpdates = 3 + empCopy.getPhoneNumbers().size();
            if (noPk) {
                nExpectedInserts = nExpectedInsertsOrUpdates;
                nExpectedUpdates = this.getQuerySQLTracker(em).getTotalSQLUPDATECalls();
            } else {
                nExpectedInserts = 0;
                nExpectedUpdates = nExpectedInsertsOrUpdates;
            }
            em.flush();
            SimpleSerializeFetchGroupTests.assertEquals((int)nExpectedInserts, (int)this.getQuerySQLTracker(em).getTotalSQLINSERTCalls());
            SimpleSerializeFetchGroupTests.assertEquals((int)nExpectedUpdates, (int)this.getQuerySQLTracker(em).getTotalSQLUPDATECalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    @Test
    public void copyNoCascade() {
        this.copyCascade(1);
    }

    @Test
    public void copyCascadePrivateParts() {
        this.copyCascade(2);
    }

    @Test
    public void copyCascadeAllParts() {
        this.copyCascade(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyCascade(int cascadeDepth) {
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            List<Employee> employeesCopy;
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e");
            List employees = query.getResultList();
            CopyGroup group = new CopyGroup();
            if (cascadeDepth == 1) {
                group.dontCascade();
            } else if (cascadeDepth == 2) {
                group.cascadePrivateParts();
            } else if (cascadeDepth == 3) {
                group.cascadeAllParts();
            } else {
                SimpleSerializeFetchGroupTests.fail((String)("Invalid cascadeDepth = " + cascadeDepth));
            }
            group.setShouldResetPrimaryKey(true);
            if (cascadeDepth == 1 || cascadeDepth == 2) {
                employeesCopy = new ArrayList(employees.size());
                for (Employee emp : employees) {
                    CopyGroup groupClone = group.clone();
                    employeesCopy.add((Employee)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)emp, (AttributeGroup)groupClone));
                }
            } else {
                employeesCopy = (List)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)employees, (AttributeGroup)group);
            }
            IdentityHashSet originalEmployees = new IdentityHashSet();
            IdentityHashSet copyEmployees = new IdentityHashSet();
            IdentityHashSet originalAddresses = new IdentityHashSet();
            IdentityHashSet copyAddresses = new IdentityHashSet();
            IdentityHashSet originalProjects = new IdentityHashSet();
            IdentityHashSet copyProjects = new IdentityHashSet();
            IdentityHashSet originalPhones = new IdentityHashSet();
            IdentityHashSet copyPhones = new IdentityHashSet();
            int size = employees.size();
            for (int i = 0; i < size; ++i) {
                boolean same;
                Employee emp = (Employee)employees.get(i);
                Employee empCopy = (Employee)employeesCopy.get(i);
                if (cascadeDepth == 3) {
                    originalEmployees.add((Object)emp);
                    copyEmployees.add((Object)empCopy);
                }
                if (emp.getAddress() == null) {
                    SimpleSerializeFetchGroupTests.assertTrue((String)"emp.getAddress() == null, but empCopy.getAddress() != null", (empCopy.getAddress() == null ? 1 : 0) != 0);
                } else {
                    originalAddresses.add((Object)emp.getAddress());
                    copyAddresses.add((Object)empCopy.getAddress());
                    if (cascadeDepth == 1 || cascadeDepth == 2) {
                        SimpleSerializeFetchGroupTests.assertTrue((String)"address has been copied", (emp.getAddress() == empCopy.getAddress() ? 1 : 0) != 0);
                    } else {
                        SimpleSerializeFetchGroupTests.assertFalse((String)"address has not been copied", (emp.getAddress() == empCopy.getAddress() ? 1 : 0) != 0);
                    }
                }
                for (Project project : emp.getProjects()) {
                    originalProjects.add((Object)project);
                    same = false;
                    for (Project projectCopy : empCopy.getProjects()) {
                        copyProjects.add((Object)projectCopy);
                        if (same || project != projectCopy) continue;
                        same = true;
                    }
                    if (cascadeDepth == 1 || cascadeDepth == 2) {
                        SimpleSerializeFetchGroupTests.assertTrue((String)"project has been copied", (boolean)same);
                        continue;
                    }
                    SimpleSerializeFetchGroupTests.assertFalse((String)"project has not been copied", (boolean)same);
                }
                for (Employee managedEmp : emp.getManagedEmployees()) {
                    originalEmployees.add((Object)managedEmp);
                    same = false;
                    for (Employee managedEmpCopy : empCopy.getManagedEmployees()) {
                        copyEmployees.add((Object)managedEmpCopy);
                        if (same || managedEmp != managedEmpCopy) continue;
                        same = true;
                    }
                    if (cascadeDepth == 1 || cascadeDepth == 2) {
                        SimpleSerializeFetchGroupTests.assertTrue((String)"managedEmployee has been copied", (boolean)same);
                        continue;
                    }
                    SimpleSerializeFetchGroupTests.assertFalse((String)"managedEmployee has not been copied", (boolean)same);
                }
                if (emp.getManager() == null) {
                    SimpleSerializeFetchGroupTests.assertTrue((String)"emp.getManager() == null, but empCopy.getManager() != null", (empCopy.getManager() == null ? 1 : 0) != 0);
                } else {
                    originalEmployees.add((Object)emp.getManager());
                    copyEmployees.add((Object)empCopy.getManager());
                    if (cascadeDepth == 1 || cascadeDepth == 2) {
                        SimpleSerializeFetchGroupTests.assertTrue((String)"manager has been copied", (emp.getManager() == empCopy.getManager() ? 1 : 0) != 0);
                    } else {
                        SimpleSerializeFetchGroupTests.assertFalse((String)"manager has not been copied", (emp.getManager() == empCopy.getManager() ? 1 : 0) != 0);
                    }
                }
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    originalPhones.add((Object)phone);
                    same = false;
                    for (PhoneNumber phoneCopy : empCopy.getPhoneNumbers()) {
                        copyPhones.add((Object)phoneCopy);
                        if (same || phone != phoneCopy) continue;
                        same = true;
                    }
                    if (cascadeDepth == 1) {
                        SimpleSerializeFetchGroupTests.assertTrue((String)"phone has been copied", (boolean)same);
                        continue;
                    }
                    SimpleSerializeFetchGroupTests.assertFalse((String)"phone has not been copied", (boolean)same);
                }
            }
            SimpleSerializeFetchGroupTests.assertTrue((String)("copyEmployees.size() == " + copyEmployees.size() + "; was expected " + originalEmployees.size()), (originalEmployees.size() == copyEmployees.size() ? 1 : 0) != 0);
            SimpleSerializeFetchGroupTests.assertTrue((String)("copyAddresses.size() == " + copyAddresses.size() + "; was expected " + originalAddresses.size()), (originalAddresses.size() == copyAddresses.size() ? 1 : 0) != 0);
            SimpleSerializeFetchGroupTests.assertTrue((String)("copyProjects.size() == " + copyProjects.size() + "; was expected " + originalProjects.size()), (originalProjects.size() == copyProjects.size() ? 1 : 0) != 0);
            SimpleSerializeFetchGroupTests.assertTrue((String)("copyPhones.size() == " + copyPhones.size() + "; was expected " + originalPhones.size()), (originalPhones.size() == copyPhones.size() ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void attrAndVHContainSameObjectAfterGetRealAttributeValue() throws Exception {
        String errorMsg = "";
        EntityManager em = SimpleSerializeFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.address IS NOT NULL and e.manager IS NOT NULL");
            List employees = query.getResultList();
            OneToOneMapping addressMapping = (OneToOneMapping)this.employeeDescriptor.getMappingForAttributeName("address");
            OneToOneMapping managerMapping = (OneToOneMapping)this.employeeDescriptor.getMappingForAttributeName("manager");
            InstanceVariableAttributeAccessor addressAccessor = new InstanceVariableAttributeAccessor();
            addressAccessor.setAttributeName("address");
            addressAccessor.initializeAttributes(Employee.class);
            InstanceVariableAttributeAccessor managerAccessor = new InstanceVariableAttributeAccessor();
            managerAccessor.setAttributeName("manager");
            managerAccessor.initializeAttributes(Employee.class);
            AbstractSession session = (AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession();
            for (Employee emp : employees) {
                Employee managerAttr;
                Employee managerVH;
                Address addressAttr;
                String localErrorMsg = "";
                Address addressVH = (Address)addressMapping.getRealAttributeValueFromObject((Object)emp, session);
                if (addressVH != (addressAttr = (Address)addressAccessor.getAttributeValueFromObject((Object)emp))) {
                    localErrorMsg = localErrorMsg + "\n\taddressVH = " + addressVH + " != addressAttr = " + addressAttr;
                }
                if ((managerVH = (Employee)managerMapping.getRealAttributeValueFromObject((Object)emp, session)) != (managerAttr = (Employee)managerAccessor.getAttributeValueFromObject((Object)emp))) {
                    localErrorMsg = localErrorMsg + "\n\tmanagerVH = " + managerVH + " != managerAttr = " + managerAttr;
                }
                if (localErrorMsg.length() <= 0) continue;
                localErrorMsg = emp.toString() + localErrorMsg + "\n";
                errorMsg = errorMsg + localErrorMsg;
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            errorMsg = '\n' + errorMsg;
            SimpleSerializeFetchGroupTests.fail((String)errorMsg);
        }
    }

    private <T> T serialize(Serializable entity) throws IOException, ClassNotFoundException {
        byte[] bytes = SerializationHelper.serialize((Serializable)entity);
        ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return (T)inStream.readObject();
    }
}

