/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.concurrent;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;

public class JPAComplexUpdateEmployeeConcurrencyComparisonTest
extends ConcurrentPerformanceComparisonTest {
    protected List<Employee> employees;
    protected int index;
    protected long count;
    protected int errors;

    public JPAComplexUpdateEmployeeConcurrencyComparisonTest() {
        this.setDescription("This test compares the concurrency of complex update Employee.");
    }

    public synchronized int incrementIndex() {
        ++this.index;
        if (this.index >= this.employees.size()) {
            this.index = 0;
        }
        return this.index;
    }

    public void setup() {
        super.setup();
        EntityManager manager = this.createEntityManager();
        this.employees = manager.createQuery("Select e from Employee e").getResultList();
        for (Employee employee : this.employees) {
            employee.getAddress().getCity();
            employee.getPhoneNumbers().size();
        }
        manager.close();
        this.index = 0;
        this.count = 0L;
    }

    public void runTask() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee originalEmployee = this.employees.get(this.incrementIndex());
        Employee employee = (Employee)manager.find(Employee.class, (Object)originalEmployee.getId());
        ++this.count;
        employee.setFirstName(originalEmployee.getFirstName() + this.count);
        employee.setLastName(originalEmployee.getLastName() + this.count);
        employee.getAddress().setStreet(originalEmployee.getAddress().getStreet() + this.count);
        employee.getAddress().setCity(originalEmployee.getAddress().getCity() + this.count);
        PhoneNumber workFax = null;
        for (PhoneNumber phone : employee.getPhoneNumbers()) {
            if (!phone.getType().equals("work-fax")) continue;
            workFax = phone;
            break;
        }
        if (workFax == null) {
            PhoneNumber phone = new PhoneNumber();
            phone.setType("work-fax");
            phone.setAreaCode("613");
            phone.setNumber("9991111");
            employee.addPhoneNumber(phone);
        } else {
            employee.removePhoneNumber(workFax);
            manager.remove(workFax);
        }
        try {
            manager.getTransaction().commit();
        }
        catch (Exception exception) {
            ++this.errors;
            System.out.println("" + this.errors + ":" + exception);
        }
        manager.close();
    }
}

