/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.FromAliasExpression;
import org.eclipse.persistence.internal.expressions.SubSelectDatabaseTable;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.ReportItem;

public class FromSubSelectExpression
extends TableExpression {
    protected SubSelectExpression subSelect;

    public FromSubSelectExpression() {
    }

    public FromSubSelectExpression(SubSelectExpression subSelect) {
        this.subSelect = subSelect;
        this.table = new SubSelectDatabaseTable(subSelect);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int computeHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String descriptionOfNodeType() {
        return "FromSubSelect";
    }

    @Override
    public Expression get(String alias) {
        FromAliasExpression aliasExpression = new FromAliasExpression(alias, this);
        return aliasExpression;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.subSelect != null) {
            for (ReportItem item : this.subSelect.getSubQuery().getItems()) {
                if (item.getAttributeExpression().isQueryKeyExpression()) continue;
                item.setAttributeExpression(item.getAttributeExpression().as(item.getName()));
            }
            this.subSelect.normalizeSubSelect(normalizer, normalizer.getClonedExpressions());
        }
        return super.normalize(normalizer);
    }

    @Override
    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.subSelect != null) {
            this.subSelect.iterateOn(iterator);
        }
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.subSelect != null) {
            this.subSelect = (SubSelectExpression)this.subSelect.copiedVersionFrom(alreadyDone);
            this.table = new SubSelectDatabaseTable(this.subSelect);
        }
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getAlias(this.subSelect.rebuildOn(newBase));
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase);
        return twistedBase.getAlias(this.subSelect.twistedForBaseAndContext(newBase, context, oldBase));
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        this.subSelect.writeDescriptionOn(writer);
        writer.write(this.tableAliasesDescription());
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        return super.aliasForTable(this.getTable());
    }

    public SubSelectExpression getSubSelect() {
        return this.subSelect;
    }

    public void setSubSelect(SubSelectExpression subSelect) {
        this.subSelect = subSelect;
        this.table = new SubSelectDatabaseTable(subSelect);
    }
}

