/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;

public class ParameterExpression
extends BaseExpression {
    protected DatabaseField field;
    protected Expression localBase;
    protected boolean isProperty = false;
    Object type;

    public ParameterExpression() {
    }

    public ParameterExpression(String fieldName) {
        this(new DatabaseField(fieldName));
    }

    public ParameterExpression(DatabaseField field) {
        this.field = field;
    }

    public ParameterExpression(String fieldName, Expression localbaseExpression, Object type) {
        this(new DatabaseField(fieldName), localbaseExpression);
        this.type = type;
    }

    public ParameterExpression(DatabaseField field, Expression localbaseExpression) {
        this.field = field;
        this.localBase = localbaseExpression;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ParameterExpression expression = (ParameterExpression)object;
        return this.getField() == expression.getField() || this.getField() != null && this.getField().equals(expression.getField());
    }

    @Override
    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getField() != null) {
            hashCode += this.getField().hashCode();
        }
        return hashCode;
    }

    public String basicDescription() {
        return String.valueOf(this.getField());
    }

    @Override
    public String descriptionOfNodeType() {
        return "Parameter";
    }

    @Override
    public Expression get(String attributeOrQueryKey) {
        ParameterExpression expression = new ParameterExpression(attributeOrQueryKey);
        expression.setBaseExpression(this);
        return expression;
    }

    @Override
    public ExpressionBuilder getBuilder() {
        if (this.localBase == null) {
            if (this.getBaseExpression() != null) {
                return this.getBaseExpression().getBuilder();
            }
            return null;
        }
        return this.localBase.getBuilder();
    }

    public DatabaseField getField() {
        return this.field;
    }

    public void setField(DatabaseField field) {
        this.field = field;
    }

    @Override
    public Expression getField(DatabaseField field) {
        ParameterExpression expression = new ParameterExpression(field);
        expression.setBaseExpression(this);
        return expression;
    }

    public Expression getLocalBase() {
        return this.localBase;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object type) {
        this.type = type;
    }

    public Object getValue(AbstractRecord translationRow, AbstractSession session) {
        return this.getValue(translationRow, null, session);
    }

    public Object getValue(AbstractRecord translationRow, DatabaseQuery query, AbstractSession session) {
        if (this.field == null) {
            return null;
        }
        Object value = null;
        if (this.baseExpression != null) {
            value = ((ParameterExpression)this.baseExpression).getValue(translationRow, query, session);
            if (value == null) {
                return null;
            }
            ClassDescriptor descriptor = session.getDescriptor(value);
            if (descriptor != null && descriptor.isAggregateDescriptor() && ((ParameterExpression)this.getBaseExpression()).getLocalBase().isObjectExpression()) {
                descriptor = ((ObjectExpression)((ParameterExpression)this.getBaseExpression()).getLocalBase()).getDescriptor();
            }
            if (descriptor == null) {
                this.validateParameterValueAgainstMapping(value, true);
            } else {
                value = descriptor.getObjectBuilder().unwrapObject(value, session);
                this.validateParameterValueAgainstMapping(value, true);
                translationRow.put(((ParameterExpression)this.baseExpression).getField(), value);
                DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForField(this.field);
                if (mapping != null) {
                    value = mapping.valueFromObject(value, this.field, session);
                } else {
                    mapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.field.getName());
                    if (mapping != null) {
                        value = mapping.getRealAttributeValueFromObject(value, session);
                    } else {
                        DatabaseField queryKeyField = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.field.getName());
                        if (queryKeyField != null && (mapping = descriptor.getObjectBuilder().getMappingForField(this.field)) != null) {
                            value = mapping.valueFromObject(value, this.field, session);
                        }
                    }
                }
            }
        } else {
            value = translationRow == null ? AbstractRecord.noEntry : translationRow.getIndicatingNoEntry(this.field);
            if (value == AbstractRecord.noEntry || value == null && this.isProperty) {
                if (this.isProperty) {
                    value = query != null ? query.getSession().getProperty(this.field.getName()) : session.getProperty(this.field.getName());
                    if (value == null) {
                        throw QueryException.missingContextPropertyForPropertyParameterExpression(query, this.field.getName());
                    }
                    return value;
                }
                if (translationRow != null) {
                    value = translationRow.getIndicatingNoEntry(new DatabaseField(this.field.getName()));
                }
                if (value == AbstractRecord.noEntry || value == null) {
                    throw QueryException.parameterNameMismatch(this.field.getName());
                }
            }
            this.validateParameterValueAgainstMapping(value, false);
        }
        if (this.localBase != null) {
            value = this.localBase.getFieldValue(value, session);
        }
        return value;
    }

    @Override
    public boolean isParameterExpression() {
        return true;
    }

    @Override
    public boolean isValueExpression() {
        return true;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.getLocalBase() != null) {
            this.setLocalBase(this.getLocalBase().copiedVersionFrom(alreadyDone));
        }
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.shouldPrintParameterValues()) {
            Object value = this.getValue(printer.getTranslationRow(), printer.getSession());
            if (value instanceof Collection) {
                printer.printValuelist((Collection)value);
            } else if (this.getField() == null) {
                printer.printPrimitive(value);
            } else {
                printer.printParameter(this);
            }
        } else if (this.getField() != null) {
            printer.printParameter(this);
        }
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        ((DataExpression)this.getLocalBase()).getBaseExpression().printJava(printer);
        printer.printString(".getParameter(\"" + this.getField().getQualifiedName() + "\")");
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        ParameterExpression result = (ParameterExpression)this.clone();
        result.setLocalBase(this.localBase.rebuildOn(newBase));
        return result;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
    }

    public void setIsProperty(boolean isProperty) {
        this.isProperty = isProperty;
    }

    @Override
    public void setLocalBase(Expression localBase) {
        this.localBase = localBase;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        if (this.isProperty()) {
            return context.getProperty(this.getField());
        }
        if (newBase == oldBase) {
            return this;
        }
        return context.getField(this.getField());
    }

    protected void validateParameterValueAgainstMapping(Object value, boolean useBaseExpression) {
        DatabaseMapping mapping;
        Expression queryKey = null;
        if (useBaseExpression) {
            ParameterExpression baseExpression = (ParameterExpression)this.getBaseExpression();
            queryKey = baseExpression.getLocalBase();
        } else {
            queryKey = this.getLocalBase();
        }
        if (value != null && !(value instanceof Collection) && queryKey != null && queryKey.isObjectExpression() && (mapping = ((ObjectExpression)queryKey).getMapping()) != null) {
            if (mapping.isCollectionMapping() && queryKey.isMapEntryExpression() && !((MapEntryExpression)queryKey).shouldReturnMapEntry()) {
                Class keyTypeClass;
                ContainerPolicy cp = mapping.getContainerPolicy();
                Object keyType = cp.getKeyType();
                Class clazz = keyTypeClass = keyType instanceof Class ? (Class)keyType : ((ClassDescriptor)keyType).getJavaClass();
                if (!keyTypeClass.isInstance(value)) {
                    throw QueryException.incorrectClassForObjectComparison(this.baseExpression, value, mapping);
                }
            } else if (!mapping.isDirectCollectionMapping() && mapping.isForeignReferenceMapping() && !mapping.getReferenceDescriptor().getJavaClass().isInstance(value)) {
                throw QueryException.incorrectClassForObjectComparison(this.baseExpression, value, mapping);
            }
        }
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.getField() != null) {
            return this.getValue(translationRow, session);
        }
        throw QueryException.cannotConformExpression();
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.basicDescription());
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, List<DatabaseField> newFields, SQLSelectStatement statement) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions()) {
            printer.getCall().setUsesBinding(false);
        }
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        newFields.add(new DatabaseField("*"));
        this.printSQL(printer);
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(writer, indent);
        }
    }
}

