/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.io.StringWriter;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class QueryMonitor {
    public static final Map<String, Number> cacheHits = new ConcurrentHashMap<String, Number>();
    public static final Map<String, Number> cacheMisses = new ConcurrentHashMap<String, Number>();
    public static long dumpTime = System.currentTimeMillis();
    public static Boolean shouldMonitor;

    public static boolean shouldMonitor() {
        if (shouldMonitor == null) {
            shouldMonitor = Boolean.FALSE;
            String property = PrivilegedAccessHelper.getSystemProperty("org.eclipse.persistence.querymonitor");
            if (property != null && property.toUpperCase().equals("TRUE")) {
                shouldMonitor = Boolean.TRUE;
            }
        }
        return shouldMonitor;
    }

    public static void checkDumpTime() {
        if (System.currentTimeMillis() - dumpTime > 100000L) {
            dumpTime = System.currentTimeMillis();
            StringWriter writer = new StringWriter();
            writer.write("Query Monitor:");
            writer.write(String.valueOf(dumpTime));
            writer.write("\n");
            writer.write("Query");
            writer.write("\t");
            writer.write("Cache");
            writer.write("\t");
            writer.write("Database");
            writer.write("\n");
            TreeSet<String> queries = new TreeSet<String>(cacheMisses.keySet());
            queries.addAll(cacheHits.keySet());
            for (String query : queries) {
                Number misses;
                Number hits = cacheHits.get(query);
                if (hits == null) {
                    hits = 0;
                }
                if ((misses = cacheMisses.get(query)) == null) {
                    misses = 0;
                }
                writer.write(query);
                writer.write("\t");
                writer.write(hits.toString());
                writer.write("\t");
                writer.write(misses.toString());
                writer.write("\n");
            }
            System.out.println(writer.toString());
        }
    }

    public static void incrementReadObjectHits(ReadObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-findByPrimaryKey";
        Number hits = cacheHits.get(name);
        if (hits == null) {
            hits = 0;
        }
        hits = hits.intValue() + 1;
        cacheHits.put(name, hits);
    }

    public static void incrementReadObjectMisses(ReadObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-findByPrimaryKey";
        Number misses = cacheMisses.get(name);
        if (misses == null) {
            misses = 0;
        }
        misses = misses.intValue() + 1;
        cacheMisses.put(name, misses);
    }

    public static void incrementReadAllHits(ReadAllQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName();
        name = query.getName() == null ? name + "-findAll" : name + "-" + query.getName();
        Number hits = cacheHits.get(name);
        if (hits == null) {
            hits = 0;
        }
        hits = hits.intValue() + 1;
        cacheHits.put(name, hits);
    }

    public static void incrementReadAllMisses(ReadAllQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName();
        name = query.getName() == null ? name + "-findAll" : name + "-" + query.getName();
        Number misses = cacheMisses.get(name);
        if (misses == null) {
            misses = 0;
        }
        misses = misses.intValue() + 1;
        cacheMisses.put(name, misses);
    }

    public static void incrementInsert(WriteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-insert";
        Number misses = cacheMisses.get(name);
        if (misses == null) {
            misses = 0;
        }
        misses = misses.intValue() + 1;
        cacheMisses.put(name, misses);
    }

    public static void incrementUpdate(WriteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-update";
        Number misses = cacheMisses.get(name);
        if (misses == null) {
            misses = 0;
        }
        misses = misses.intValue() + 1;
        cacheMisses.put(name, misses);
    }

    public static void incrementDelete(DeleteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-delete";
        Number misses = cacheMisses.get(name);
        if (misses == null) {
            misses = 0;
        }
        misses = misses.intValue() + 1;
        cacheMisses.put(name, misses);
    }
}

