/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.util.ObjectUtil;

public class DeleteIfVersion
extends Delete {
    private final Version matchVersion;

    public DeleteIfVersion(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, Version matchVersion) {
        this(keyBytes, prevValChoice, matchVersion, 0L);
    }

    public DeleteIfVersion(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, Version matchVersion, long tableId) {
        super(InternalOperation.OpCode.DELETE_IF_VERSION, keyBytes, prevValChoice, tableId);
        ObjectUtil.checkNull("matchVersion", matchVersion);
        this.matchVersion = matchVersion;
    }

    DeleteIfVersion(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.DELETE_IF_VERSION, in, serialVersion);
        this.matchVersion = Version.createVersion(in, serialVersion);
    }

    Version getMatchVersion() {
        return this.matchVersion;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.matchVersion.writeFastExternal(out, serialVersion);
    }

    @Override
    public String toString() {
        return super.toString() + " MatchVersion: " + this.matchVersion;
    }
}

