/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryValue;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BinaryNode;

@Persistent(version=1)
public class FixedBinaryValueImpl
extends FieldValueImpl
implements FixedBinaryValue {
    private static final long serialVersionUID = 1L;
    private byte[] value;
    private final FixedBinaryDefImpl def;

    FixedBinaryValueImpl(byte[] value, FixedBinaryDefImpl def) {
        this.value = value;
        this.def = def;
    }

    private FixedBinaryValueImpl() {
        this.def = null;
    }

    @Override
    public FixedBinaryValueImpl clone() {
        return new FixedBinaryValueImpl(this.value, this.def);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 2 * SizeOf.OBJECT_REF_OVERHEAD + SizeOf.byteArraySize(this.value.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof FixedBinaryValueImpl) {
            FixedBinaryValueImpl otherImpl = (FixedBinaryValueImpl)other;
            return this.def.equals(otherImpl.def) && Arrays.equals(this.value, otherImpl.get());
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof FixedBinaryValueImpl) {
            return 0;
        }
        throw new ClassCastException("Object is not an FixedBinaryValue");
    }

    @Override
    public String toString() {
        return Base64Variants.getDefaultVariant().encode(this.value, false);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.FIXED_BINARY;
    }

    @Override
    public FixedBinaryDefImpl getDefinition() {
        return this.def;
    }

    @Override
    public FixedBinaryValue asFixedBinary() {
        return this;
    }

    @Override
    public boolean isFixedBinary() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public JsonNode toJsonNode() {
        return new BinaryNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(Base64Variants.getDefaultVariant().encode(this.value, true));
    }

    @Override
    public byte[] getFixedBytes() {
        return this.getBytes();
    }
}

