/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.ops.IndexIterate;
import oracle.kv.impl.api.ops.IndexKeysIterate;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultIndexKeys;
import oracle.kv.impl.api.ops.ResultIndexRows;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.ShardScanIterator;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiGetResult;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.Row;
import oracle.kv.table.TableIteratorOptions;

public class IndexScan {
    static final Comparator<byte[]> KEY_BYTES_COMPARATOR = new Key.BytesComparator();

    private IndexScan() {
    }

    static AsyncTableIterator<Row> createTableIterator(TableAPIImpl tableAPI, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions tio, IterationHandleNotifier iterHandleNotifier) {
        return IndexScan.createTableIterator(tableAPI, indexKey, mro, tio, null, iterHandleNotifier);
    }

    static AsyncTableIterator<Row> createTableIterator(final TableAPIImpl tableAPI, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions tio, Set<RepGroupId> shardSet, IterationHandleNotifier iterHandleNotifier) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), mro);
        final IndexImpl index = (IndexImpl)indexKey.getIndex();
        final TableImpl table = index.getTable();
        final IndexRange range = new IndexRange(indexKey, mro, tio);
        final boolean needDupElim = IndexScan.needDupElimination(indexKey);
        ExecuteOptions options = new ExecuteOptions(tio);
        Direction dir = tio != null ? tio.getDirection() : Direction.FORWARD;
        return new ShardScanIterator<Row>(tableAPI.getStore(), options, dir, shardSet, iterHandleNotifier){

            @Override
            protected ShardScanIterator.ShardStream createStream(RepGroupId groupId) {
                return new IndexRowScanStream(groupId);
            }

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexIterate(index.getName(), targetTables, range, resumeSecondaryKey, resumePrimaryKey, this.batchSize, 0, 1);
            }

            @Override
            protected void convertResult(Result result, List<Row> rows) {
                IndexScan.convertResultRows(tableAPI, table, targetTables, result, rows);
            }

            @Override
            protected byte[] extractResumeSecondaryKey(Result result) {
                byte[] bytes = result.getSecondaryResumeKey();
                if (bytes != null || !result.hasMoreElements()) {
                    return bytes;
                }
                ArrayList<Row> rowList = new ArrayList<Row>();
                this.convertResult(result, (List<Row>)rowList);
                Row lastRow = (Row)rowList.get(rowList.size() - 1);
                return index.serializeIndexKey(index.createIndexKey(lastRow));
            }

            @Override
            protected int compare(Row one, Row two) {
                throw new IllegalStateException("Unexpected call");
            }

            class IndexRowScanStream
            extends ShardScanIterator.ShardStream {
                HashSet<BinaryValueImpl> thePrimKeysSet;

                IndexRowScanStream(RepGroupId groupId) {
                    super(groupId, null, null);
                    if (needDupElim) {
                        this.thePrimKeysSet = new HashSet(1000);
                    }
                }

                @Override
                protected void setResumeKey(Result result) {
                    super.setResumeKey(result);
                    if (!needDupElim) {
                        return;
                    }
                    ListIterator<ResultIndexRows> listIter = result.getIndexRowList().listIterator();
                    while (listIter.hasNext()) {
                        ResultIndexRows indexRow = listIter.next();
                        BinaryValueImpl binPrimKey = FieldDefImpl.binaryDef.createBinary(indexRow.getKeyBytes());
                        boolean added = this.thePrimKeysSet.add(binPrimKey);
                        if (added) continue;
                        listIter.remove();
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    byte[] key2;
                    IndexRowScanStream other = (IndexRowScanStream)o;
                    ResultIndexRows res1 = this.currentResultSet.getIndexRowList().get(this.currentResultPos);
                    ResultIndexRows res2 = other.currentResultSet.getIndexRowList().get(other.currentResultPos);
                    byte[] key1 = res1.getIndexKeyBytes();
                    int cmp = IndexImpl.compareUnsignedBytes(key1, key2 = res2.getIndexKeyBytes());
                    if (cmp == 0) {
                        cmp = KEY_BYTES_COMPARATOR.compare(res1.getKeyBytes(), res2.getKeyBytes());
                    }
                    return itrDirection == Direction.FORWARD ? cmp : cmp * -1;
                }
            }
        };
    }

    private static boolean needDupElimination(IndexKeyImpl key) {
        int i;
        IndexImpl index = (IndexImpl)key.getIndex();
        if (!index.isMultiKey() || key.isComplete()) {
            return false;
        }
        if (key.size() == 0) {
            return true;
        }
        List<IndexImpl.IndexField> ipaths = index.getIndexFields();
        if (index.isMapBothIndex()) {
            for (i = 0; i < key.size(); ++i) {
                if (!ipaths.get(i).isMapKeys()) continue;
                return false;
            }
        }
        for (i = key.size(); i < index.numFields(); ++i) {
            if (!ipaths.get(i).isMultiKey()) continue;
            return true;
        }
        return false;
    }

    static AsyncTableIterator<KeyPair> createTableKeysIterator(TableAPIImpl apiImpl, IndexKeyImpl indexKey, MultiRowOptions mro, TableIteratorOptions tio, IterationHandleNotifier iterHandleNotifier) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), mro);
        final IndexImpl index = (IndexImpl)indexKey.getIndex();
        final IndexRange range = new IndexRange(indexKey, mro, tio);
        ExecuteOptions options = new ExecuteOptions(tio);
        Direction dir = tio != null ? tio.getDirection() : Direction.FORWARD;
        return new ShardScanIterator<KeyPair>(apiImpl.getStore(), options, dir, null, iterHandleNotifier){

            @Override
            protected ShardScanIterator.ShardStream createStream(RepGroupId groupId) {
                return new IndexKeyScanStream(groupId);
            }

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexKeysIterate(index.getName(), targetTables, range, resumeSecondaryKey, resumePrimaryKey, this.batchSize, 0, 1);
            }

            @Override
            protected void convertResult(Result result, List<KeyPair> elementList) {
                IndexScan.convertResultKeyPairs(index, targetTables, result, elementList);
            }

            @Override
            protected int compare(KeyPair one, KeyPair two) {
                throw new IllegalStateException("Unexpected call");
            }

            class IndexKeyScanStream
            extends ShardScanIterator.ShardStream {
                IndexKeyScanStream(RepGroupId groupId) {
                    super(groupId, null, null);
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    byte[] key2;
                    IndexKeyScanStream other = (IndexKeyScanStream)o;
                    ResultIndexKeys res1 = this.currentResultSet.getIndexKeyList().get(this.currentResultPos);
                    ResultIndexKeys res2 = other.currentResultSet.getIndexKeyList().get(other.currentResultPos);
                    byte[] key1 = res1.getIndexKeyBytes();
                    int cmp = IndexImpl.compareUnsignedBytes(key1, key2 = res2.getIndexKeyBytes());
                    if (cmp == 0) {
                        cmp = KEY_BYTES_COMPARATOR.compare(res1.getPrimaryKeyBytes(), res2.getPrimaryKeyBytes());
                    }
                    return itrDirection == Direction.FORWARD ? cmp : cmp * -1;
                }
            }
        };
    }

    static MultiGetResult<Row> multiGet(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, LogContext lc) {
        return new ShardMultiGetHandler(apiImpl, indexKey, continuationKey, mro, tio, lc).execute();
    }

    static void multiGetAsync(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, ResultHandler<MultiGetResult<Row>> handler) {
        new ShardMultiGetHandler(apiImpl, indexKey, continuationKey, mro, tio, null).executeAsync(handler);
    }

    static MultiGetResult<KeyPair> multiGetKeys(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, LogContext lc) {
        return new ShardMultiGetKeysHandler(apiImpl, indexKey, continuationKey, mro, tio, lc).execute();
    }

    static void multiGetKeysAsync(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, ResultHandler<MultiGetResult<KeyPair>> hnd) {
        new ShardMultiGetKeysHandler(apiImpl, indexKey, continuationKey, mro, tio, null).executeAsync(hnd);
    }

    private static void convertResultRows(TableAPIImpl apiImpl, TableImpl table, TargetTables targetTables, Result result, List<Row> rows) {
        List<ResultIndexRows> indexRowList = result.getIndexRowList();
        for (ResultIndexRows indexRow : indexRowList) {
            Row converted = IndexScan.convertRow(apiImpl, targetTables, table, indexRow);
            rows.add(converted);
        }
    }

    private static Row convertRow(TableAPIImpl apiImpl, TargetTables targetTables, TableImpl table, ResultIndexRows rowResult) {
        TableImpl startingTable = targetTables.hasAncestorTables() ? table.getTopLevelTable() : table;
        RowImpl fullKey = startingTable.createRowFromKeyBytes(rowResult.getKeyBytes());
        if (fullKey == null) {
            throw new IllegalStateException("Unable to deserialize a row from an index result");
        }
        ValueVersion vv = new ValueVersion(rowResult.getValue(), rowResult.getVersion());
        RowImpl row = apiImpl.getRowFromValueVersion(vv, fullKey, rowResult.getExpirationTime(), false);
        return row;
    }

    private static void convertResultKeyPairs(IndexImpl index, TargetTables targetTables, Result result, List<KeyPair> keyPairs) {
        TableImpl table = index.getTable();
        List<ResultIndexKeys> results = result.getIndexKeyList();
        for (ResultIndexKeys res : results) {
            IndexKeyImpl indexKeyImpl = IndexScan.convertIndexKey(index, res.getIndexKeyBytes());
            PrimaryKeyImpl pkey = IndexScan.convertPrimaryKey(table, targetTables, res);
            if (indexKeyImpl != null && pkey != null) {
                keyPairs.add(new KeyPair(pkey, indexKeyImpl));
                continue;
            }
            keyPairs.add(null);
        }
    }

    private static IndexKeyImpl convertIndexKey(IndexImpl index, byte[] bytes) {
        return index.deserializeIndexKey(bytes, false);
    }

    private static PrimaryKeyImpl convertPrimaryKey(TableImpl table, TargetTables targetTables, ResultIndexKeys res) {
        TableImpl startingTable = targetTables.hasAncestorTables() ? table.getTopLevelTable() : table;
        PrimaryKeyImpl pkey = startingTable.createPrimaryKeyFromKeyBytes(res.getPrimaryKeyBytes());
        pkey.setExpirationTime(res.getExpirationTime());
        return pkey;
    }

    private static abstract class BasicShardMultiGetHandler<T> {
        final TableAPIImpl apiImpl;
        final KVStoreImpl store;
        final RepGroupId[] repGroupIds;
        final IndexImpl index;
        final TableImpl table;
        final byte[] continuationKey;
        final TargetTables targetTables;
        final IndexRange range;
        final Consistency consistency;
        final long requestTimeout;
        final TimeUnit timeoutUnit;
        final int batchResultSize;
        final int maxReadKB;
        final LogContext lc;
        private int opBatchSize;
        private int opMaxReadKB;
        final List<T> rows = new ArrayList<T>();
        byte[] resumeSecondaryKey = null;
        byte[] resumePrimaryKey = null;
        private RepGroupId groupId;
        private int numRead = 0;
        private int readKB = 0;
        private int writeKB = 0;
        private byte[] contdKey = null;

        BasicShardMultiGetHandler(TableAPIImpl apiImpl, IndexKeyImpl key, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, LogContext lc) {
            this.apiImpl = apiImpl;
            this.store = apiImpl.getStore();
            Set<RepGroupId> rgids = this.store.getTopology().getRepGroupIds();
            this.repGroupIds = rgids.toArray(new RepGroupId[rgids.size()]);
            this.index = key.getIndexImpl();
            this.table = key.getTable();
            this.continuationKey = continuationKey;
            this.targetTables = TableAPIImpl.makeTargetTables(key.getTable(), mro);
            this.range = new IndexRange(key, mro, tio);
            this.consistency = TableAPIImpl.getConsistency(tio);
            this.requestTimeout = TableAPIImpl.getTimeout(tio);
            this.timeoutUnit = TableAPIImpl.getTimeoutUnit(tio);
            this.batchResultSize = TableAPIImpl.getBatchSize(tio);
            this.maxReadKB = TableAPIImpl.getMaxReadKB(tio);
            this.opBatchSize = this.batchResultSize;
            this.opMaxReadKB = this.maxReadKB;
            this.lc = lc;
        }

        abstract InternalOperation createIterateOp(int var1, int var2, int var3);

        abstract void convertResult(Result var1);

        MultiGetResult<T> execute() {
            Request request;
            Result result;
            this.initIteration();
            while (!this.processResult(result = this.store.executeRequest(request = this.createRequest()))) {
            }
            return this.createResult();
        }

        private void initIteration() {
            if (this.continuationKey != null && this.continuationKey.length > 0) {
                byte len;
                byte gid;
                int pos = 0;
                if ((gid = this.continuationKey[pos++]) < 1 || gid > this.repGroupIds.length) {
                    throw new IllegalArgumentException("Invalid shard id in continuation key: " + gid);
                }
                this.groupId = new RepGroupId(gid);
                if (this.continuationKey.length > 1 && (len = this.continuationKey[pos++]) > 0) {
                    this.resumeSecondaryKey = Arrays.copyOfRange(this.continuationKey, pos, pos + len);
                    assert ((pos += len) < this.continuationKey.length);
                    len = this.continuationKey[pos++];
                    this.resumePrimaryKey = Arrays.copyOfRange(this.continuationKey, pos, pos + len);
                }
            } else {
                this.groupId = this.getNextRepGroup(null);
            }
        }

        private Request createRequest() {
            int emptyReadFactor = this.readKB == 0 && this.groupId.getGroupId() == this.repGroupIds.length ? 1 : 0;
            InternalOperation op = this.createIterateOp(this.opBatchSize, this.opMaxReadKB, emptyReadFactor);
            return this.store.makeReadRequest(op, this.groupId, this.consistency, this.requestTimeout, this.timeoutUnit, this.lc);
        }

        private boolean processResult(Result result) {
            this.numRead += result.getNumRecords();
            this.readKB += result.getReadKB();
            this.writeKB += result.getWriteKB();
            if (result.getNumRecords() > 0) {
                this.convertResult(result);
                this.resumeSecondaryKey = result.getSecondaryResumeKey();
                this.resumePrimaryKey = result.getPrimaryResumeKey();
            }
            if (result.hasMoreElements()) {
                this.contdKey = BasicShardMultiGetHandler.genContinuationKey(this.groupId, this.resumeSecondaryKey, this.resumePrimaryKey);
                return true;
            }
            this.groupId = this.getNextRepGroup(this.groupId);
            if (this.groupId == null) {
                return true;
            }
            if (this.maxReadKB != 0) {
                if (this.readKB >= this.maxReadKB) {
                    this.contdKey = BasicShardMultiGetHandler.genContinuationKey(this.groupId, null, null);
                    return true;
                }
                this.opMaxReadKB = this.maxReadKB - this.readKB;
            }
            if (this.batchResultSize != 0) {
                if (this.numRead >= this.batchResultSize) {
                    this.contdKey = BasicShardMultiGetHandler.genContinuationKey(this.groupId, null, null);
                    return true;
                }
                this.opBatchSize = this.batchResultSize - this.numRead;
            }
            if (this.resumeSecondaryKey != null) {
                this.resumeSecondaryKey = null;
                this.resumePrimaryKey = null;
            }
            return false;
        }

        private MultiGetResult<T> createResult() {
            return new MultiGetResult<T>(this.rows, this.contdKey, this.readKB, this.writeKB);
        }

        void executeAsync(final ResultHandler<MultiGetResult<T>> handler) {
            this.initIteration();
            class ExecuteAsyncHandler
            implements ResultHandler<Result> {
                ExecuteAsyncHandler() {
                }

                void execute() {
                    BasicShardMultiGetHandler.this.store.executeRequest(BasicShardMultiGetHandler.this.createRequest(), this);
                }

                @Override
                public void onResult(Result result, Throwable exception) {
                    if (exception != null) {
                        handler.onResult(null, exception);
                    } else if (BasicShardMultiGetHandler.this.processResult(result)) {
                        handler.onResult(BasicShardMultiGetHandler.this.createResult(), null);
                    } else {
                        this.execute();
                    }
                }
            }
            new ExecuteAsyncHandler().execute();
        }

        private static byte[] genContinuationKey(RepGroupId repGroupId, byte[] resumeSecondKey, byte[] resumePrimaryKey) {
            int len = (resumeSecondKey != null ? resumeSecondKey.length + 1 : 0) + (resumePrimaryKey != null ? resumePrimaryKey.length + 1 : 0) + 1;
            byte[] bytes = new byte[len];
            int pos = 0;
            bytes[pos++] = (byte)repGroupId.getGroupId();
            if (resumeSecondKey != null) {
                bytes[pos++] = (byte)resumeSecondKey.length;
                System.arraycopy(resumeSecondKey, 0, bytes, pos, resumeSecondKey.length);
                pos += resumeSecondKey.length;
                if (resumePrimaryKey != null) {
                    bytes[pos++] = (byte)resumePrimaryKey.length;
                    System.arraycopy(resumePrimaryKey, 0, bytes, pos, resumePrimaryKey.length);
                }
            }
            return bytes;
        }

        private RepGroupId getNextRepGroup(RepGroupId repGroupId) {
            if (repGroupId == null) {
                return this.repGroupIds[0];
            }
            if (repGroupId.getGroupId() == this.repGroupIds.length) {
                return null;
            }
            return this.repGroupIds[repGroupId.getGroupId()];
        }
    }

    private static class ShardMultiGetKeysHandler
    extends BasicShardMultiGetHandler<KeyPair> {
        ShardMultiGetKeysHandler(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, LogContext lc) {
            super(apiImpl, indexKey, continuationKey, mro, tio, lc);
        }

        @Override
        InternalOperation createIterateOp(int batchSize, int readKBLimit, int emptyReadFactor) {
            return new IndexKeysIterate(this.index.getName(), this.targetTables, this.range, this.resumeSecondaryKey, this.resumePrimaryKey, batchSize, readKBLimit, emptyReadFactor);
        }

        @Override
        void convertResult(Result result) {
            IndexScan.convertResultKeyPairs(this.index, this.targetTables, result, this.rows);
        }
    }

    private static class ShardMultiGetHandler
    extends BasicShardMultiGetHandler<Row> {
        ShardMultiGetHandler(TableAPIImpl apiImpl, IndexKeyImpl indexKey, byte[] continuationKey, MultiRowOptions mro, TableIteratorOptions tio, LogContext lc) {
            super(apiImpl, indexKey, continuationKey, mro, tio, lc);
        }

        @Override
        InternalOperation createIterateOp(int batchSize, int readKBLimit, int emptyReadFactor) {
            return new IndexIterate(this.index.getName(), this.targetTables, this.range, this.resumeSecondaryKey, this.resumePrimaryKey, batchSize, readKBLimit, emptyReadFactor);
        }

        @Override
        void convertResult(Result result) {
            IndexScan.convertResultRows(this.apiImpl, this.table, this.targetTables, result, this.rows);
        }
    }
}

