/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import java.io.Serializable;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.util.FormatUtils;

public class Pruned
implements Measurement,
Serializable {
    private static final long serialVersionUID = 1L;
    private int numRemoved;
    private long start;
    private long end;

    public void record(Measurement target) {
        ++this.numRemoved;
        long mStart = target.getStart();
        long mEnd = target.getEnd();
        if (this.end < mEnd) {
            this.end = mEnd;
        }
        if (mEnd != 0L && this.start > mEnd) {
            this.start = mEnd;
        }
        if (mStart != 0L) {
            if (this.start == 0L) {
                this.start = mStart;
            } else if (this.start > mStart) {
                this.start = mStart;
            }
        }
    }

    @Override
    public int getId() {
        return Metrics.PRUNED.getId();
    }

    public String toString() {
        if (this.start == 0L) {
            return this.numRemoved + " measurements dropped.";
        }
        return this.numRemoved + " measurements from " + FormatUtils.formatDateAndTime(this.start) + FormatUtils.formatDateAndTime(this.end) + " dropped.";
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    public boolean exists() {
        return this.numRemoved > 0;
    }

    public int getNumRemoved() {
        return this.numRemoved;
    }
}

