/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.FuncSeqAggrIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

class FuncSeqAggr
extends Function {
    FuncSeqAggr(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_STAR(), TypeManager.ANY_ATOMIC_QSTN());
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall fncall) {
        return fncall.getArg(0).mayReturnNULL();
    }

    @Override
    ExprType getRetType(ExprFuncCall fncall) {
        if (this.theCode == FunctionLib.FuncCode.FN_SEQ_COUNT) {
            return TypeManager.LONG_ONE();
        }
        FieldDefImpl inType = fncall.getInput().getType().getDef();
        FieldDef.Type inTypeCode = inType.getType();
        boolean isMinMax = this.theCode == FunctionLib.FuncCode.FN_SEQ_MIN || this.theCode == FunctionLib.FuncCode.FN_SEQ_MAX;
        boolean isSum = this.theCode == FunctionLib.FuncCode.FN_SEQ_SUM;
        switch (inTypeCode) {
            case INTEGER: {
                if (isMinMax) {
                    return TypeManager.INT_QSTN();
                }
                if (isSum) {
                    return TypeManager.LONG_QSTN();
                }
                return TypeManager.DOUBLE_QSTN();
            }
            case LONG: {
                if (isMinMax || isSum) {
                    return TypeManager.LONG_QSTN();
                }
                return TypeManager.DOUBLE_QSTN();
            }
            case FLOAT: 
            case DOUBLE: {
                return TypeManager.DOUBLE_QSTN();
            }
            case NUMBER: {
                return TypeManager.NUMBER_QSTN();
            }
            case STRING: {
                if (!isMinMax) break;
                return TypeManager.STRING_QSTN();
            }
            case TIMESTAMP: {
                if (!isMinMax) break;
                return TypeManager.TIMESTAMP_QSTN();
            }
            case BOOLEAN: {
                if (!isMinMax) break;
                return TypeManager.BOOLEAN_QSTN();
            }
            case ENUM: {
                if (!isMinMax) break;
                return TypeManager.createType(fncall.getInput().getType(), ExprType.Quantifier.QSTN);
            }
            case JSON: 
            case ANY_JSON_ATOMIC: {
                return TypeManager.ANY_JATOMIC_QSTN();
            }
            case ANY_ATOMIC: 
            case ANY: {
                return this.theReturnType;
            }
        }
        throw new QueryException("Invalid input type for the " + this.theName + "function:\n" + inType.getDDLString(), fncall.getLocation());
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        return new FuncSeqAggrIter(caller, this.theCode, resultReg, argIters[0]);
    }
}

