/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.ExprRecConstr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldValue;

public class RecConstrIter
extends PlanIter {
    private final PlanIter[] theArgs;
    private final RecordDefImpl theDef;

    public RecConstrIter(ExprRecConstr e, int resultReg, PlanIter[] args) {
        super(e, resultReg);
        this.theArgs = args;
        this.theDef = e.getDef();
    }

    RecConstrIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theArgs = RecConstrIter.deserializeIters(in, serialVersion);
        this.theDef = (RecordDefImpl)RecConstrIter.deserializeFieldDef(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        RecConstrIter.serializeIters(this.theArgs, out, serialVersion);
        RecConstrIter.serializeFieldDef(this.theDef, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.REC_CONSTR;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter arg : this.theArgs) {
            arg.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        int numArgs = this.theArgs.length;
        RecordValueImpl rec = this.theDef.createRecord();
        for (int i = 0; i < numArgs; ++i) {
            String fname = this.theDef.getFieldName(i);
            boolean more = this.theArgs[i].next(rcb);
            FieldValueImpl fval = !more ? NullValueImpl.getInstance() : rcb.getRegVal(this.theArgs[i].getResultReg());
            if (this.theArgs[i].next(rcb)) {
                throw new QueryException("Field expression in record constructor returns more one item", this.theLocation);
            }
            if (fval.isTuple()) {
                fval = ((TupleValue)fval).toRecord();
            }
            try {
                rec.put(fname, (FieldValue)fval);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (rcb.getTraceLevel() >= 4) {
                    rcb.trace("Query Plan:\n" + rcb.getRootIter().display() + "\nValue:\n" + fval);
                }
                throw new QueryException(e, this.theLocation);
            }
        }
        rcb.setRegVal(this.theResultReg, rec);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter arg : this.theArgs) {
            arg.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter arg : this.theArgs) {
            arg.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("Type:\n");
        formatter.indent(sb);
        this.theDef.display(sb, formatter);
        sb.append("\n");
        for (int i = 0; i < this.theArgs.length; ++i) {
            this.theArgs[i].display(sb, formatter);
            if (i >= this.theArgs.length - 1) continue;
            sb.append(",\n");
        }
    }
}

