/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class AuthContext
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;
    public static final int HAS_TOKEN = 1;
    public static final int HAS_FORWARDER_TOKEN = 2;
    public static final int HAS_CLIENT_HOST = 4;
    public static final AuthContext NULL_CTX = null;
    private LoginToken loginToken;
    private LoginToken forwarderToken;
    private String clientHost;

    public AuthContext(LoginToken loginToken) {
        this.loginToken = loginToken;
        this.forwarderToken = null;
        this.clientHost = null;
    }

    public AuthContext(LoginToken loginToken, LoginToken forwarderToken, String clientHost) {
        this.loginToken = loginToken;
        this.forwarderToken = forwarderToken;
        this.clientHost = clientHost;
    }

    public AuthContext(DataInput in, short serialVersion) throws IOException {
        byte flags = in.readByte();
        this.loginToken = (flags & 1) != 0 ? new LoginToken(in, serialVersion) : null;
        this.forwarderToken = (flags & 2) != 0 ? new LoginToken(in, serialVersion) : null;
        this.clientHost = (flags & 4) == 0 ? null : (serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF());
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        int flags = 0;
        if (this.loginToken != null) {
            flags |= 1;
        }
        if (this.forwarderToken != null) {
            flags |= 2;
        }
        if (this.clientHost != null) {
            flags |= 4;
        }
        out.writeByte((byte)flags);
        if (this.loginToken != null) {
            this.loginToken.writeFastExternal(out, serialVersion);
        }
        if (this.forwarderToken != null) {
            this.forwarderToken.writeFastExternal(out, serialVersion);
        }
        if (this.clientHost != null) {
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullString(out, serialVersion, this.clientHost);
            } else {
                out.writeUTF(this.clientHost);
            }
        }
    }

    public LoginToken getLoginToken() {
        return this.loginToken;
    }

    public LoginToken getForwarderLoginToken() {
        return this.forwarderToken;
    }

    public String getClientHost() {
        return this.clientHost;
    }
}

